/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.data.gis.handlers;

import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequenceFactory;
import com.vividsolutions.jts.io.ByteOrderValues;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.InputStreamInStream;
import com.vividsolutions.jts.io.OutStream;
import com.vividsolutions.jts.io.OutputStreamOutStream;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GeometryConverter {
    private int byteOrder = 2;
    private static PrecisionModel precisionModel = new PrecisionModel();
    private static CoordinateSequenceFactory coordinateSequenceFactory = CoordinateArraySequenceFactory.instance();
    private static int outputDimension = 2;
    private static final GeometryConverter INSTANCE = new GeometryConverter();

    public static GeometryConverter getInstance() {
        return INSTANCE;
    }

    public Geometry from(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
                byte[] sridBytes = new byte[4];
                inputStream.read(sridBytes);
                int srid = ByteOrderValues.getInt((byte[])sridBytes, (int)this.byteOrder);
                GeometryFactory geometryFactory = new GeometryFactory(precisionModel, srid, coordinateSequenceFactory);
                WKBReader wkbReader = new WKBReader(geometryFactory);
                return wkbReader.read((InStream)new InputStreamInStream((InputStream)inputStream));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ParseException | IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Geometry from(String str) {
        try {
            return new WKTReader().read(str);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public byte[] to(Geometry userObject) {
        if (userObject == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                byte[] sridBytes = new byte[4];
                ByteOrderValues.putInt((int)userObject.getSRID(), (byte[])sridBytes, (int)this.byteOrder);
                outputStream.write(sridBytes);
                WKBWriter wkbWriter = new WKBWriter(outputDimension, this.byteOrder);
                wkbWriter.write(userObject, (OutStream)new OutputStreamOutStream((OutputStream)outputStream));
                return outputStream.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
    }
}

