/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ValueFormatSelector;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageResultSetPresentation
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.resultset.presentation";
    private Button autoSwitchMode;
    private Button showDescription;
    private Button columnWidthByValue;
    private Button showConnectionName;
    private Button transformComplexTypes;
    private Button rightJustifyNumbers;
    private Button rightJustifyDateTime;
    private Button gridShowOddRows;
    private Button colorizeDataTypes;
    private Spinner gridRowBatchSize;
    private Button gridShowCellIcons;
    private Button gridShowAttrFilters;
    private Button gridShowAttrOrder;
    private Button gridShowAttrIcons;
    private Combo gridDoubleClickBehavior;
    private Spinner textTabSize;
    private Spinner textMaxColumnSize;
    private ValueFormatSelector textValueFormat;
    private Button showNulls;
    private Button textDelimiterLeading;
    private Button textDelimiterTrailing;

    @Override
    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("resultset.behavior.autoSwitchMode") || store.contains("resultset.show.columnDescription") || store.contains("resultset.calc.columnWidthByValues") || store.contains("resultset.show.connectionName") || store.contains("resultset.show.oddRows") || store.contains("resultset.show.colorizeDataTypes") || store.contains("resultset.show.rightJustifyNumbers") || store.contains("resultset.show.rightJustifyDateTime") || store.contains("resultset.transform.complex.type") || store.contains("resultset.show.cellIcons") || store.contains("resultset.behavior.doubleClick") || store.contains("resultset.show.attFilters") || store.contains("resultset.show.row.batch.size") || store.contains("resultset.text.tab.size") || store.contains("resultset.text.max.column.size") || store.contains("resultset.text.value.format") || store.contains("resultset.text.show.nulls") || store.contains("resultset.text.delimiter.leading") || store.contains("resultset.text.delimiter.trailing");
    }

    @Override
    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @Override
    protected Control createPreferenceContent(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        Group uiGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_database_resultsets_group_common, (int)1, (int)0, (int)0);
        ((GridData)uiGroup.getLayoutData()).horizontalSpan = 2;
        this.autoSwitchMode = UIUtils.createCheckbox((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_switch_mode_on_rows, (boolean)false);
        this.showDescription = UIUtils.createCheckbox((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_show_column_description, (boolean)false);
        this.columnWidthByValue = UIUtils.createCheckbox((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_calc_column_width_by_values, (String)CoreMessages.pref_page_database_resultsets_label_calc_column_width_by_values_tip, (boolean)false, (int)1);
        this.showConnectionName = UIUtils.createCheckbox((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_show_connection_name, (boolean)false);
        this.transformComplexTypes = UIUtils.createCheckbox((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_structurize_complex_types, (String)CoreMessages.pref_page_database_resultsets_label_structurize_complex_types_tip, (boolean)false, (int)1);
        this.rightJustifyNumbers = UIUtils.createCheckbox((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_right_justify_numbers_and_date, null, (boolean)false, (int)1);
        this.rightJustifyDateTime = UIUtils.createCheckbox((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_right_justify_datetime, null, (boolean)false, (int)1);
        uiGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_database_resultsets_group_grid, (int)2, (int)2, (int)0);
        this.gridShowOddRows = UIUtils.createCheckbox((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_mark_odd_rows, null, (boolean)false, (int)2);
        this.colorizeDataTypes = UIUtils.createCheckbox((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_colorize_data_types, null, (boolean)false, (int)2);
        this.gridRowBatchSize = UIUtils.createLabelSpinner((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_row_batch_size, (int)1, (int)1, (int)Short.MAX_VALUE);
        this.gridRowBatchSize.setToolTipText(CoreMessages.pref_page_database_resultsets_label_row_batch_size_tip);
        this.gridShowCellIcons = UIUtils.createCheckbox((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_show_cell_icons, null, (boolean)false, (int)2);
        this.gridShowAttrIcons = UIUtils.createCheckbox((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_show_attr_icons, (String)CoreMessages.pref_page_database_resultsets_label_show_attr_icons_tip, (boolean)false, (int)2);
        this.gridShowAttrFilters = UIUtils.createCheckbox((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_show_attr_filters, (String)CoreMessages.pref_page_database_resultsets_label_show_attr_filters_tip, (boolean)false, (int)2);
        this.gridShowAttrOrder = UIUtils.createCheckbox((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_show_attr_ordering, (String)CoreMessages.pref_page_database_resultsets_label_show_attr_ordering_tip, (boolean)false, (int)2);
        this.gridDoubleClickBehavior = UIUtils.createLabelCombo((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_double_click_behavior, (int)8);
        this.gridDoubleClickBehavior.add("None", Spreadsheet.DoubleClickBehavior.NONE.ordinal());
        this.gridDoubleClickBehavior.add("Editor", Spreadsheet.DoubleClickBehavior.EDITOR.ordinal());
        this.gridDoubleClickBehavior.add("Inline Editor", Spreadsheet.DoubleClickBehavior.INLINE_EDITOR.ordinal());
        uiGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_database_resultsets_group_plain_text, (int)2, (int)2, (int)0);
        this.textTabSize = UIUtils.createLabelSpinner((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_tab_width, (int)0, (int)1, (int)100);
        this.textMaxColumnSize = UIUtils.createLabelSpinner((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_maximum_column_length, (int)0, (int)10, (int)Integer.MAX_VALUE);
        this.textValueFormat = new ValueFormatSelector((Composite)uiGroup);
        this.showNulls = UIUtils.createCheckbox((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_text_show_nulls, null, (boolean)false, (int)2);
        this.textDelimiterLeading = UIUtils.createCheckbox((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_text_delimiter_leading, null, (boolean)false, (int)2);
        this.textDelimiterTrailing = UIUtils.createCheckbox((Composite)uiGroup, (String)CoreMessages.pref_page_database_resultsets_label_text_delimiter_trailing, null, (boolean)false, (int)2);
        return composite;
    }

    @Override
    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.gridShowOddRows.setSelection(store.getBoolean("resultset.show.oddRows"));
            this.colorizeDataTypes.setSelection(store.getBoolean("resultset.show.colorizeDataTypes"));
            this.rightJustifyNumbers.setSelection(store.getBoolean("resultset.show.rightJustifyNumbers"));
            this.rightJustifyDateTime.setSelection(store.getBoolean("resultset.show.rightJustifyDateTime"));
            this.transformComplexTypes.setSelection(store.getBoolean("resultset.transform.complex.type"));
            this.gridRowBatchSize.setSelection(store.getInt("resultset.show.row.batch.size"));
            this.gridShowCellIcons.setSelection(store.getBoolean("resultset.show.cellIcons"));
            this.gridShowAttrIcons.setSelection(store.getBoolean("resultset.show.attIcons"));
            this.gridShowAttrFilters.setSelection(store.getBoolean("resultset.show.attFilters"));
            this.gridShowAttrOrder.setSelection(store.getBoolean("resultset.show.attOrdering"));
            this.gridDoubleClickBehavior.select(Spreadsheet.DoubleClickBehavior.valueOf(store.getString("resultset.behavior.doubleClick")).ordinal());
            this.autoSwitchMode.setSelection(store.getBoolean("resultset.behavior.autoSwitchMode"));
            this.showDescription.setSelection(store.getBoolean("resultset.show.columnDescription"));
            this.columnWidthByValue.setSelection(store.getBoolean("resultset.calc.columnWidthByValues"));
            this.showConnectionName.setSelection(store.getBoolean("resultset.show.connectionName"));
            this.textTabSize.setSelection(store.getInt("resultset.text.tab.size"));
            this.textMaxColumnSize.setSelection(store.getInt("resultset.text.max.column.size"));
            this.textValueFormat.select(DBDDisplayFormat.safeValueOf((String)store.getString("resultset.text.value.format")));
            this.showNulls.setSelection(store.getBoolean("resultset.text.show.nulls"));
            this.textDelimiterLeading.setSelection(store.getBoolean("resultset.text.delimiter.leading"));
            this.textDelimiterTrailing.setSelection(store.getBoolean("resultset.text.delimiter.trailing"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    @Override
    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("resultset.show.oddRows", this.gridShowOddRows.getSelection());
            store.setValue("resultset.show.colorizeDataTypes", this.colorizeDataTypes.getSelection());
            store.setValue("resultset.show.rightJustifyNumbers", this.rightJustifyNumbers.getSelection());
            store.setValue("resultset.show.rightJustifyDateTime", this.rightJustifyDateTime.getSelection());
            store.setValue("resultset.transform.complex.type", this.transformComplexTypes.getSelection());
            store.setValue("resultset.show.row.batch.size", this.gridRowBatchSize.getSelection());
            store.setValue("resultset.show.cellIcons", this.gridShowCellIcons.getSelection());
            store.setValue("resultset.show.attIcons", this.gridShowAttrIcons.getSelection());
            store.setValue("resultset.show.attFilters", this.gridShowAttrFilters.getSelection());
            store.setValue("resultset.show.attOrdering", this.gridShowAttrOrder.getSelection());
            store.setValue("resultset.behavior.doubleClick", ((Spreadsheet.DoubleClickBehavior)CommonUtils.fromOrdinal(Spreadsheet.DoubleClickBehavior.class, (int)this.gridDoubleClickBehavior.getSelectionIndex())).name());
            store.setValue("resultset.behavior.autoSwitchMode", this.autoSwitchMode.getSelection());
            store.setValue("resultset.show.columnDescription", this.showDescription.getSelection());
            store.setValue("resultset.calc.columnWidthByValues", this.columnWidthByValue.getSelection());
            store.setValue("resultset.show.connectionName", this.showConnectionName.getSelection());
            store.setValue("resultset.text.tab.size", this.textTabSize.getSelection());
            store.setValue("resultset.text.max.column.size", this.textMaxColumnSize.getSelection());
            store.setValue("resultset.text.value.format", this.textValueFormat.getSelection().name());
            store.setValue("resultset.text.show.nulls", this.showNulls.getSelection());
            store.setValue("resultset.text.delimiter.leading", this.textDelimiterLeading.getSelection());
            store.setValue("resultset.text.delimiter.trailing", this.textDelimiterLeading.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    @Override
    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("resultset.show.oddRows");
        store.setToDefault("resultset.show.colorizeDataTypes");
        store.setToDefault("resultset.show.rightJustifyNumbers");
        store.setToDefault("resultset.show.rightJustifyDateTime");
        store.setToDefault("resultset.transform.complex.type");
        store.setToDefault("resultset.show.row.batch.size");
        store.setToDefault("resultset.show.cellIcons");
        store.setToDefault("resultset.show.attIcons");
        store.setToDefault("resultset.show.attFilters");
        store.setToDefault("resultset.show.attOrdering");
        store.setToDefault("resultset.behavior.doubleClick");
        store.setToDefault("resultset.behavior.autoSwitchMode");
        store.setToDefault("resultset.show.columnDescription");
        store.setToDefault("resultset.calc.columnWidthByValues");
        store.setToDefault("resultset.show.connectionName");
        store.setToDefault("resultset.text.tab.size");
        store.setToDefault("resultset.text.max.column.size");
        store.setToDefault("resultset.text.value.format");
        store.setToDefault("resultset.text.show.nulls");
        store.setToDefault("resultset.text.delimiter.leading");
        store.setToDefault("resultset.text.delimiter.trailing");
    }

    @Override
    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

