/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.project;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeColumnViewerLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProjectListener;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.ui.LazyLabelProvider;
import org.jkiss.dbeaver.ui.ProgramInfo;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorViewBase;
import org.jkiss.utils.CommonUtils;

public class ProjectExplorerView
extends NavigatorViewBase
implements DBPProjectListener {
    public static final String VIEW_ID = "org.jkiss.dbeaver.core.projectExplorer";
    private ViewerColumnController columnController;

    public ProjectExplorerView() {
        DBeaverCore.getInstance().getProjectRegistry().addProjectListener(this);
    }

    @Override
    public DBNNode getRootNode() {
        DBNProject projectNode = this.getModel().getRoot().getProject(DBeaverCore.getInstance().getProjectRegistry().getActiveProject());
        return projectNode != null ? projectNode : this.getModel().getRoot();
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        TreeViewer viewer = this.getNavigatorViewer();
        assert (viewer != null);
        viewer.getTree().setHeaderVisible(true);
        this.createColumns(viewer);
        UIUtils.setHelp((Control)parent, (String)"view-project-explorer");
        viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof DBNProjectDatabases);
            }
        });
        this.updateTitle();
    }

    private void createColumns(TreeViewer viewer) {
        Color shadowColor = viewer.getControl().getDisplay().getSystemColor(17);
        final ILabelProvider mainLabelProvider = (ILabelProvider)viewer.getLabelProvider();
        this.columnController = new ViewerColumnController("projectExplorer", (ColumnViewer)viewer);
        this.columnController.addColumn("Name", "Resource name", 16384, true, true, (CellLabelProvider)new TreeColumnViewerLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return mainLabelProvider.getText(element);
            }

            public Image getImage(Object element) {
                return mainLabelProvider.getImage(element);
            }
        }));
        this.columnController.addColumn("DataSource", "Datasource(s) associated with resource", 16384, true, false, (CellLabelProvider)new TreeColumnViewerLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Collection containers;
                DBNNode node = (DBNNode)element;
                if (node instanceof DBNDatabaseNode) {
                    return ((DBNDatabaseNode)node).getDataSourceContainer().getName();
                }
                if (node instanceof DBNResource && !CommonUtils.isEmpty((Collection)(containers = ((DBNResource)node).getAssociatedDataSources()))) {
                    StringBuilder text = new StringBuilder();
                    for (DBPDataSourceContainer container : containers) {
                        if (text.length() > 0) {
                            text.append(", ");
                        }
                        text.append(container.getName());
                    }
                    return text.toString();
                }
                return "";
            }

            public Image getImage(Object element) {
                return null;
            }
        }));
        this.columnController.addColumn("Preview", "Script content preview", 16384, false, false, (CellLabelProvider)new LazyLabelProvider(shadowColor){

            public String getLazyText(Object element) {
                if (element instanceof DBNNode) {
                    return ((DBNNode)element).getNodeDescription();
                }
                return null;
            }
        });
        this.columnController.addColumn("Size", "File size", 16384, false, false, (CellLabelProvider)new TreeColumnViewerLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IResource resource;
                DBNNode node = (DBNNode)element;
                if (node instanceof DBNResource && (resource = ((DBNResource)node).getResource()) instanceof IFile) {
                    return String.valueOf(resource.getLocation().toFile().length());
                }
                return "";
            }
        }));
        this.columnController.addColumn("Modified", "Time the file was last modified", 16384, false, false, (CellLabelProvider)new TreeColumnViewerLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

            public String getText(Object element) {
                IResource resource;
                DBNNode node = (DBNNode)element;
                if (node instanceof DBNResource && ((resource = ((DBNResource)node).getResource()) instanceof IFile || resource instanceof IFolder)) {
                    return this.sdf.format(new Date(resource.getLocation().toFile().lastModified()));
                }
                return "";
            }
        }));
        this.columnController.addColumn("Type", "Resource type", 16384, false, false, (CellLabelProvider)new TreeColumnViewerLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IResource resource;
                ProgramInfo program;
                DBNNode node = (DBNNode)element;
                if (node instanceof DBNResource && (program = ProgramInfo.getProgram(resource = ((DBNResource)node).getResource())) != null) {
                    return program.getProgram().getName();
                }
                return "";
            }
        }));
        this.columnController.createColumns(false);
    }

    @Override
    protected int getTreeStyle() {
        return super.getTreeStyle() | 0x10000;
    }

    @Override
    public void dispose() {
        DBeaverCore.getInstance().getProjectRegistry().removeProjectListener(this);
        super.dispose();
    }

    public void handleActiveProjectChange(IProject oldValue, IProject newValue) {
        this.getNavigatorTree().reloadTree(this.getRootNode());
        this.updateTitle();
        UIUtils.asyncExec(() -> UIUtils.packColumns((Tree)this.getNavigatorTree().getViewer().getTree(), (boolean)true, null));
    }

    private void updateTitle() {
        this.setPartName("Project - " + this.getRootNode().getNodeName());
    }

    @Override
    public void configureView() {
        this.columnController.configureColumns();
    }
}

