/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.text.handlers;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.text.BaseTextEditor;
import org.jkiss.dbeaver.ui.editors.text.handlers.AbstractTextHandler;
import org.jkiss.utils.CommonUtils;

public final class MorphDelimitedListHandler
extends AbstractTextHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)executionEvent);
        BaseTextEditor textEditor = BaseTextEditor.getTextEditor(HandlerUtil.getActiveEditor((ExecutionEvent)executionEvent));
        if (textEditor != null) {
            ISelection selection;
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
            ISelectionProvider provider = textEditor.getSelectionProvider();
            if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection) {
                ITextSelection textSelection = (ITextSelection)selection;
                if (textSelection.getLength() <= 0) {
                    UIUtils.showMessageBox((Shell)activeShell, (String)"Morph text", (String)"Text selection is empty. You need to select some text to morph", (int)2);
                    return null;
                }
                String formattedText = this.morphText(activeShell, textSelection.getText());
                if (formattedText != null) {
                    try {
                        document.replace(textSelection.getOffset(), textSelection.getLength(), formattedText);
                    }
                    catch (BadLocationException e) {
                        DBeaverUI.getInstance().showError("Morph text", "Error replacing text", e);
                    }
                }
            }
        }
        return null;
    }

    private String morphText(Shell activeShell, String text) {
        ConfigDialog configDialog = new ConfigDialog(activeShell);
        if (configDialog.open() != 0) {
            return null;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        MorphDelimitedListSettings settings = configDialog.morphSettings;
        String sourceDelimiter = settings.getSourceDelimiter();
        if (sourceDelimiter.contains("\n") && !sourceDelimiter.contains("\r")) {
            sourceDelimiter = String.valueOf(sourceDelimiter) + "\r";
        }
        StringTokenizer st = new StringTokenizer(text, sourceDelimiter);
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        StringBuilder buf = new StringBuilder();
        if (!CommonUtils.isEmpty((String)settings.getLeadingText())) {
            buf.append(settings.getLeadingText());
        }
        int lastLineFeed = 0;
        int i = 0;
        while (i < tokens.size()) {
            String token = (String)tokens.get(i);
            if (!CommonUtils.isEmpty((String)settings.getQuoteString())) {
                buf.append(settings.getQuoteString()).append(token).append(settings.getQuoteString());
                lastLineFeed += settings.getQuoteString().length() * 2 + token.length();
            } else {
                buf.append(token);
                lastLineFeed += token.length();
            }
            if (i < tokens.size() - 1) {
                buf.append(settings.getTargetDelimiter());
                lastLineFeed += settings.getTargetDelimiter().length();
                if (settings.wrapLine > 0) {
                    int nextTokenLength = ((String)tokens.get(i + 1)).length();
                    if (!CommonUtils.isEmpty((String)settings.getQuoteString())) {
                        nextTokenLength += settings.getQuoteString().length() * 2;
                    }
                    if (lastLineFeed + nextTokenLength > settings.wrapLine) {
                        buf.append("\n");
                        lastLineFeed = 0;
                    }
                }
            }
            ++i;
        }
        if (!CommonUtils.isEmpty((String)settings.getTrailingText())) {
            buf.append(settings.getTrailingText());
        }
        return buf.toString();
    }

    public static class ConfigDialog
    extends Dialog {
        static final String PARAM_SOURCE_DELIMITER = "sourceDelimiter";
        static final String PARAM_TARGET_DELIMITER = "targetDelimiter";
        static final String PARAM_QUOTE_STRING = "quoteString";
        static final String PARAM_WRAP_LINE = "wrapLine";
        static final String PARAM_LEADING_TEXT = "leadingText";
        static final String PARAM_TRAILING_TEXT = "trailingText";
        protected final IDialogSettings settings = UIUtils.getDialogSettings((String)"MorphDelimitedListConfigDialog");
        private Combo sourceDelimCombo;
        private Combo targetDelimCombo;
        private Combo quoteStringCombo;
        private Spinner wrapLineAtColumn;
        private Text leadingText;
        private Text trailingText;
        protected MorphDelimitedListSettings morphSettings = new MorphDelimitedListSettings();

        protected ConfigDialog(Shell shell) {
            super(shell);
            this.morphSettings.setSourceDelimiter("\t\n,");
            this.morphSettings.setTargetDelimiter(",");
            this.morphSettings.setQuoteString("\"");
            this.morphSettings.setWrapLine(80);
            if (this.settings.get(PARAM_SOURCE_DELIMITER) != null) {
                this.morphSettings.setSourceDelimiter(this.settings.get(PARAM_SOURCE_DELIMITER));
            }
            if (this.settings.get(PARAM_TARGET_DELIMITER) != null) {
                this.morphSettings.setTargetDelimiter(this.settings.get(PARAM_TARGET_DELIMITER));
            }
            if (this.settings.get(PARAM_QUOTE_STRING) != null) {
                this.morphSettings.setQuoteString(this.settings.get(PARAM_QUOTE_STRING));
            }
            if (this.settings.get(PARAM_WRAP_LINE) != null) {
                try {
                    this.morphSettings.setWrapLine(Integer.parseInt(this.settings.get(PARAM_WRAP_LINE)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.settings.get(PARAM_LEADING_TEXT) != null) {
                this.morphSettings.setLeadingText(this.settings.get(PARAM_LEADING_TEXT));
            }
            if (this.settings.get(PARAM_TRAILING_TEXT) != null) {
                this.morphSettings.setTrailingText(this.settings.get(PARAM_TRAILING_TEXT));
            }
        }

        protected IDialogSettings getDialogBoundsSettings() {
            return this.settings;
        }

        protected boolean isResizable() {
            return true;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText("Delimited text options");
        }

        protected Control createDialogArea(Composite parent) {
            Composite group = (Composite)super.createDialogArea(parent);
            ((GridLayout)group.getLayout()).numColumns = 1;
            int textWidthHint = UIUtils.getFontHeight((Control)parent) * 10;
            Group sourceGroup = UIUtils.createControlGroup((Composite)group, (String)"Source", (int)2, (int)768, (int)-1);
            this.sourceDelimCombo = UIUtils.createDelimiterCombo((Composite)sourceGroup, (String)"Column Delimiter", (String[])new String[]{"\n", "\t", ";", ","}, (String)this.morphSettings.getSourceDelimiter(), (boolean)true);
            ((GridData)this.sourceDelimCombo.getLayoutData()).widthHint = textWidthHint;
            Group targetGroup = UIUtils.createControlGroup((Composite)group, (String)"Target", (int)2, (int)1808, (int)-1);
            this.targetDelimCombo = UIUtils.createDelimiterCombo((Composite)targetGroup, (String)"Result delimiter", (String[])new String[]{"\n", "\t", ";", ","}, (String)this.morphSettings.getTargetDelimiter(), (boolean)false);
            this.quoteStringCombo = UIUtils.createDelimiterCombo((Composite)targetGroup, (String)"String quote character", (String[])new String[]{"\"", "'"}, (String)this.morphSettings.getQuoteString(), (boolean)false);
            this.wrapLineAtColumn = UIUtils.createLabelSpinner((Composite)targetGroup, (String)"Wrap line at column", (String)"Inserts line feeds after spcified number of characters. Zero means no wrap.", (int)this.morphSettings.getWrapLine(), (int)0, (int)Integer.MAX_VALUE);
            this.leadingText = UIUtils.createLabelText((Composite)targetGroup, (String)"Leading text", (String)this.morphSettings.getLeadingText(), (int)2562);
            ((GridData)this.leadingText.getLayoutData()).widthHint = textWidthHint;
            ((GridData)this.leadingText.getLayoutData()).verticalAlignment = 4;
            ((GridData)this.leadingText.getLayoutData()).grabExcessVerticalSpace = true;
            this.trailingText = UIUtils.createLabelText((Composite)targetGroup, (String)"Trailing text", (String)this.morphSettings.getTrailingText(), (int)2562);
            ((GridData)this.trailingText.getLayoutData()).widthHint = textWidthHint;
            ((GridData)this.trailingText.getLayoutData()).verticalAlignment = 4;
            ((GridData)this.trailingText.getLayoutData()).grabExcessVerticalSpace = true;
            return group;
        }

        protected void okPressed() {
            this.morphSettings.setSourceDelimiter(CommonUtils.unescapeDisplayString((String)this.sourceDelimCombo.getText()));
            this.morphSettings.setTargetDelimiter(CommonUtils.unescapeDisplayString((String)this.targetDelimCombo.getText()));
            this.morphSettings.setQuoteString(CommonUtils.unescapeDisplayString((String)this.quoteStringCombo.getText()));
            this.morphSettings.setWrapLine(this.wrapLineAtColumn.getSelection());
            this.morphSettings.setLeadingText(this.leadingText.getText());
            this.morphSettings.setTrailingText(this.trailingText.getText());
            this.settings.put(PARAM_SOURCE_DELIMITER, this.morphSettings.getSourceDelimiter());
            this.settings.put(PARAM_TARGET_DELIMITER, this.morphSettings.getTargetDelimiter());
            this.settings.put(PARAM_QUOTE_STRING, this.morphSettings.getQuoteString());
            this.settings.put(PARAM_WRAP_LINE, this.morphSettings.getWrapLine());
            this.settings.put(PARAM_LEADING_TEXT, this.morphSettings.getLeadingText());
            this.settings.put(PARAM_TRAILING_TEXT, this.morphSettings.getTrailingText());
            super.okPressed();
        }
    }

    public static class MorphDelimitedListSettings {
        private String sourceDelimiter;
        private String targetDelimiter;
        private String quoteString;
        private int wrapLine;
        private String leadingText;
        private String trailingText;

        public String getSourceDelimiter() {
            return this.sourceDelimiter;
        }

        public void setSourceDelimiter(String sourceDelimiter) {
            this.sourceDelimiter = sourceDelimiter;
        }

        public String getTargetDelimiter() {
            return this.targetDelimiter;
        }

        public void setTargetDelimiter(String targetDelimiter) {
            this.targetDelimiter = targetDelimiter;
        }

        public String getQuoteString() {
            return this.quoteString;
        }

        public void setQuoteString(String quoteString) {
            this.quoteString = quoteString;
        }

        public int getWrapLine() {
            return this.wrapLine;
        }

        public void setWrapLine(int wrapLine) {
            this.wrapLine = wrapLine;
        }

        public String getLeadingText() {
            return this.leadingText;
        }

        public void setLeadingText(String leadingText) {
            this.leadingText = leadingText;
        }

        public String getTrailingText() {
            return this.trailingText;
        }

        public void setTrailingText(String trailingText) {
            this.trailingText = trailingText;
        }
    }
}

