/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.text;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.ICommentsSupport;
import org.jkiss.dbeaver.ui.ISingleControlEditor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.INonPersistentEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.content.ContentEditorInput;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.IOUtils;

public abstract class BaseTextEditor
extends AbstractDecoratedTextEditor
implements ISingleControlEditor {
    public static final String TEXT_EDITOR_CONTEXT = "org.eclipse.ui.textEditorScope";
    public static final String GROUP_SQL_PREFERENCES = "sql.preferences";
    public static final String GROUP_SQL_ADDITIONS = "sql.additions";
    public static final String GROUP_SQL_EXTRAS = "sql.extras";
    private static Map<String, Integer> ACTION_TRANSLATE_MAP;

    public static Map<String, Integer> getActionMap() {
        if (ACTION_TRANSLATE_MAP == null) {
            ACTION_TRANSLATE_MAP = new HashMap<String, Integer>();
            AbstractTextEditor.IdMapEntry[] idMapEntryArray = ACTION_MAP;
            int n = ACTION_MAP.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractTextEditor.IdMapEntry entry = idMapEntryArray[n2];
                ACTION_TRANSLATE_MAP.put(entry.getActionId(), entry.getAction());
                ++n2;
            }
        }
        return ACTION_TRANSLATE_MAP;
    }

    public static BaseTextEditor getTextEditor(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        if (editor instanceof BaseTextEditor) {
            return (BaseTextEditor)editor;
        }
        return (BaseTextEditor)((Object)editor.getAdapter(BaseTextEditor.class));
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (input != this.getEditorInput()) {
            this.releaseEditorInput();
        }
        super.doSetInput(input);
    }

    public void dispose() {
        this.releaseEditorInput();
        super.dispose();
    }

    public void releaseEditorInput() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof ContentEditorInput) {
            ((ContentEditorInput)editorInput).release();
        }
    }

    @Nullable
    public Document getDocument() {
        IDocumentProvider provider = this.getDocumentProvider();
        return provider == null ? null : (Document)provider.getDocument((Object)this.getEditorInput());
    }

    @Nullable
    public StyledText getEditorControl() {
        TextViewer textViewer = this.getTextViewer();
        return textViewer == null ? null : textViewer.getTextWidget();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.getSite() instanceof SubEditorSite) {
            this.getTextViewer().getTextWidget().setKeyBinding(127, 127);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        IAction preferencesAction;
        menu.add((IContributionItem)new Separator("group.undo"));
        menu.add((IContributionItem)new GroupMarker("group.save"));
        menu.add((IContributionItem)new Separator("group.copy"));
        menu.add((IContributionItem)new Separator("group.print"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("group.find"));
        menu.add((IContributionItem)new Separator("group.add"));
        menu.add((IContributionItem)new Separator("group.rest"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker(GROUP_SQL_ADDITIONS));
        menu.add((IContributionItem)new GroupMarker(GROUP_SQL_EXTRAS));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker(GROUP_SQL_PREFERENCES));
        if (this.isEditable()) {
            this.addAction(menu, "group.undo", ITextEditorActionConstants.UNDO);
            this.addAction(menu, "group.save", ITextEditorActionConstants.SAVE);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.CUT);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.COPY);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.PASTE);
            IAction action = this.getAction("QuickAssist");
            if (action != null && action.isEnabled()) {
                this.addAction(menu, "group.edit", "QuickAssist");
            }
        } else {
            this.addAction(menu, "group.copy", ITextEditorActionConstants.COPY);
        }
        if ((preferencesAction = this.getAction("Preferences.ContextAction")) != null) {
            menu.appendToGroup(GROUP_SQL_PREFERENCES, preferencesAction);
        }
    }

    @Nullable
    public TextViewer getTextViewer() {
        return (TextViewer)this.getSourceViewer();
    }

    @Nullable
    public SourceViewer getViewer() {
        return (SourceViewer)super.getSourceViewer();
    }

    public void enableUndoManager(boolean enable) {
        TextViewer textViewer = this.getTextViewer();
        IUndoManager undoManager = textViewer.getUndoManager();
        if (undoManager != null) {
            if (!enable) {
                undoManager.disconnect();
            } else {
                undoManager.connect((ITextViewer)textViewer);
            }
        }
    }

    public void handleActivate() {
        this.safelySanityCheckState(this.getEditorInput());
    }

    @Nullable
    public ICommentsSupport getCommentsSupport() {
        return null;
    }

    protected boolean isReadOnly() {
        return false;
    }

    public void loadFromExternalFile() {
        Document document;
        File loadFile = DialogUtils.openFile((Shell)this.getSite().getShell(), (String[])new String[]{"*.sql", "*.txt", "*", "*.*"});
        if (loadFile == null) {
            return;
        }
        String newContent = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(loadFile), GeneralUtils.DEFAULT_FILE_CHARSET);){
                StringWriter buffer = new StringWriter();
                IOUtils.copyText((Reader)reader, (Writer)buffer);
                newContent = buffer.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DBUserInterface.getInstance().showError("Can't load file", "Can't load file '" + loadFile.getAbsolutePath() + "' - " + e.getMessage());
        }
        if (newContent != null && (document = this.getDocument()) != null) {
            document.set(newContent);
        }
    }

    public void saveToExternalFile() {
        IEditorInput editorInput = this.getEditorInput();
        IFile curFile = EditorUtils.getFileFromInput(editorInput);
        String fileName = curFile == null ? null : curFile.getName();
        final Document document = this.getDocument();
        final File saveFile = DialogUtils.selectFileForSave((Shell)this.getSite().getShell(), (String)"Save SQL script", (String[])new String[]{"*.sql", "*.txt", "*", "*.*"}, (String)fileName);
        if (document == null || saveFile == null) {
            return;
        }
        try {
            UIUtils.runInProgressService((DBRRunnableWithProgress)new DBRRunnableWithProgress(){

                public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        StringReader cr = new StringReader(document.get());
                        ContentUtils.saveContentToFile((Reader)cr, (File)saveFile, (String)"UTF-8", (DBRProgressMonitor)monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            DBUserInterface.getInstance().showError("Save failed", null, e.getTargetException());
        }
        this.afterSaveToFile(saveFile);
    }

    protected void afterSaveToFile(File saveFile) {
    }

    @Nullable
    public int[] getCurrentLines() {
        return null;
    }

    protected boolean isNonPersistentEditor() {
        return this.getEditorInput() instanceof INonPersistentEditorInput;
    }
}

