/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetectorExtension;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.MultipleHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.URLHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.indent.SQLAutoIndentStrategy;
import org.jkiss.dbeaver.ui.editors.sql.indent.SQLCommentAutoIndentStrategy;
import org.jkiss.dbeaver.ui.editors.sql.indent.SQLStringAutoIndentStrategy;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCompletionProcessor;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCompletionSorter;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLContentAssistant;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLDoubleClickStrategy;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLFormattingStrategy;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLHyperlinkDetector;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLInformationProvider;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLPartitionScanner;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLReconcilingStrategy;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLRuleManager;
import org.jkiss.dbeaver.ui.editors.sql.util.SQLAnnotationHover;
import org.jkiss.utils.ArrayUtils;

public class SQLEditorSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private SQLEditorBase editor;
    private SQLRuleManager ruleManager;
    private IContentAssistProcessor completionProcessor;
    private IHyperlinkDetector hyperlinkDetector;

    public SQLEditorSourceViewerConfiguration(SQLEditorBase editor, IPreferenceStore preferenceStore) {
        super(preferenceStore);
        this.editor = editor;
        this.ruleManager = editor.getRuleManager();
        this.completionProcessor = new SQLCompletionProcessor(editor);
        this.hyperlinkDetector = new SQLHyperlinkDetector(editor, editor.getSyntaxManager());
    }

    public IUndoManager getUndoManager(ISourceViewer sourceViewer) {
        return new TextViewerUndoManager(200);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new SQLAnnotationHover(this.getSQLEditor());
    }

    @Nullable
    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if ("__dftl_partition_content_type".equals(contentType)) {
            return new IAutoEditStrategy[]{new SQLAutoIndentStrategy("___sql_partitioning", this.editor.getSyntaxManager())};
        }
        if ("sql_comment".equals(contentType) || "sql_multiline_comment".equals(contentType)) {
            return new IAutoEditStrategy[]{new SQLCommentAutoIndentStrategy("___sql_partitioning")};
        }
        if ("sql_character".equals(contentType)) {
            return new IAutoEditStrategy[]{new SQLStringAutoIndentStrategy("sql_character")};
        }
        return new IAutoEditStrategy[0];
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "___sql_partitioning";
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        DBPPreferenceStore store;
        DBPPreferenceStore configStore = store = this.editor.getActivePreferenceStore();
        SQLContentAssistant assistant = new SQLContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        if (this.completionProcessor != null) {
            assistant.setContentAssistProcessor(this.completionProcessor, "__dftl_partition_content_type");
        }
        assistant.enableAutoActivation(store.getBoolean("SQLEditor.ContentAssistant.auto.activation.enable"));
        assistant.setAutoActivationDelay(store.getInt("SQLEditor.ContentAssistant.auto.activation.delay"));
        assistant.setProposalPopupOrientation(10);
        assistant.setSorter(new SQLCompletionSorter());
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        Color foreground = new Color((Device)UIUtils.getDisplay(), 0, 0, 0);
        Color background = new Color((Device)UIUtils.getDisplay(), 255, 255, 255);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setContextInformationPopupForeground(foreground);
        assistant.setContextInformationPopupBackground(background);
        assistant.enableAutoInsert(store.getBoolean("SQLEditor.ContentAssistant.insert.single.proposal"));
        assistant.setShowEmptyList(true);
        DBPPreferenceListener prefListener = event -> {
            switch (event.getProperty()) {
                case "SQLEditor.ContentAssistant.auto.activation.enable": {
                    assistant.enableAutoActivation(configStore.getBoolean("SQLEditor.ContentAssistant.auto.activation.enable"));
                    break;
                }
                case "SQLEditor.ContentAssistant.auto.activation.delay": {
                    assistant.setAutoActivationDelay(configStore.getInt("SQLEditor.ContentAssistant.auto.activation.delay"));
                    break;
                }
                case "SQLEditor.ContentAssistant.insert.single.proposal": {
                    assistant.enableAutoInsert(configStore.getBoolean("SQLEditor.ContentAssistant.insert.single.proposal"));
                }
            }
        };
        configStore.addPropertyChangeListener(prefListener);
        this.editor.getTextViewer().getControl().addDisposeListener(e -> configStore.removePropertyChangeListener(prefListener));
        return assistant;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return parent -> new DefaultInformationControl(parent, true);
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        ContentFormatter formatter = new ContentFormatter();
        formatter.setDocumentPartitioning("___sql_partitioning");
        SQLFormattingStrategy formattingStrategy = new SQLFormattingStrategy(sourceViewer, this, this.editor.getSyntaxManager());
        String[] stringArray = SQLPartitionScanner.SQL_CONTENT_TYPES;
        int n = SQLPartitionScanner.SQL_CONTENT_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String ct = stringArray[n2];
            formatter.setFormattingStrategy((IFormattingStrategy)formattingStrategy, ct);
            ++n2;
        }
        formatter.enablePartitionAwareFormatting(false);
        return formatter;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new SQLDoubleClickStrategy();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        String docPartitioning = this.getConfiguredDocumentPartitioning(sourceViewer);
        reconciler.setDocumentPartitioning(docPartitioning);
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.ruleManager);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        this.addContentTypeDamageRepairer(reconciler, "sql_multiline_comment", "org.jkiss.dbeaver.sql.editor.color.comment.foreground");
        this.addContentTypeDamageRepairer(reconciler, "sql_comment", "org.jkiss.dbeaver.sql.editor.color.comment.foreground");
        this.addContentTypeDamageRepairer(reconciler, "sql_character", "org.jkiss.dbeaver.sql.editor.color.string.foreground");
        this.addContentTypeDamageRepairer(reconciler, "sql_quoted", "org.jkiss.dbeaver.sql.editor.color.datatype.foreground");
        return reconciler;
    }

    private void addContentTypeDamageRepairer(PresentationReconciler reconciler, String contentType, String colorId) {
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(this.ruleManager.getColor(colorId))));
        reconciler.setDamager((IPresentationDamager)dr, contentType);
        reconciler.setRepairer((IPresentationRepairer)dr, contentType);
    }

    public SQLEditorBase getSQLEditor() {
        return this.editor;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new SQLAnnotationHover(this.getSQLEditor());
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return SQLPartitionScanner.SQL_CONTENT_TYPES;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        SQLDialect dialect = this.editor.getSQLDialect();
        return (String[])ArrayUtils.add(String.class, (Object[])dialect.getSingleLineComments(), (Object)"");
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        String[] contentTypes;
        InformationPresenter presenter = new InformationPresenter(this.getInformationControlCreator(sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        SQLInformationProvider provider = new SQLInformationProvider(this.getSQLEditor());
        String[] stringArray = contentTypes = this.getConfiguredContentTypes(sourceViewer);
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String contentType = stringArray[n2];
            presenter.setInformationProvider((IInformationProvider)provider, contentType);
            ++n2;
        }
        presenter.setSizeConstraints(60, 10, true, true);
        return presenter;
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        return new MultipleHyperlinkPresenter(new RGB(0, 0, 255)){};
    }

    @Nullable
    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null) {
            return null;
        }
        return new IHyperlinkDetector[]{this.hyperlinkDetector, new URLHyperlinkDetector()};
    }

    void onDataSourceChange() {
        if (this.hyperlinkDetector instanceof IHyperlinkDetectorExtension) {
            ((IHyperlinkDetectorExtension)this.hyperlinkDetector).dispose();
        }
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (!this.editor.isFoldingEnabled()) {
            return null;
        }
        SQLReconcilingStrategy strategy = new SQLReconcilingStrategy();
        strategy.setEditor(this.editor);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, true);
        return reconciler;
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute attribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)attribute));
        }
    }
}

