/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.part.FileEditorInput;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;

public class SQLEditorInputFactory
implements IElementFactory {
    static final Log log = Log.getLog(SQLEditorInputFactory.class);
    private static final String ID_FACTORY = SQLEditorInputFactory.class.getName();
    private static final String TAG_PATH = "path";

    public IAdaptable createElement(IMemento memento) {
        String fileName = memento.getString(TAG_PATH);
        if (fileName == null) {
            return null;
        }
        DBeaverCore.getInstance();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileName));
        if (file != null) {
            if (!file.exists()) {
                try {
                    file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    log.error((Object)"Can't create new file", (Throwable)e);
                    return null;
                }
            }
            return new FileEditorInput(file);
        }
        return null;
    }

    public static String getFactoryId() {
        return ID_FACTORY;
    }

    public static void saveState(IMemento memento, IFileEditorInput input) {
        IFile file = input.getFile();
        memento.putString(TAG_PATH, file.getFullPath().toString());
    }
}

