/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity.properties;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.registry.editor.EntityEditorDescriptor;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.IActiveWorkbenchPart;
import org.jkiss.dbeaver.ui.IPropertyChangeReflector;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.ISingleControlEditor;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolderEditorSite;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderPage;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorContributorManager;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorContributorUser;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;

public class TabbedFolderPageEditor
extends TabbedFolderPage
implements IDatabaseEditorContributorUser,
ISaveablePart,
IRefreshablePart,
IAdaptable {
    private static final Log log = Log.getLog(TabbedFolderPageEditor.class);
    private IDatabaseEditor mainEditor;
    private EntityEditorDescriptor editorDescriptor;
    private IEditorPart editor;
    private IEditorActionBarContributor actionContributor;
    private IEditorSite nestedEditorSite;

    public TabbedFolderPageEditor(IDatabaseEditor mainEditor, EntityEditorDescriptor editorDescriptor) {
        this.mainEditor = mainEditor;
        this.editorDescriptor = editorDescriptor;
    }

    public IEditorPart getEditor() {
        return this.editor;
    }

    @Override
    public void createControl(Composite parent) {
        this.editor = this.editorDescriptor.createEditor();
        IWorkbenchPartSite ownerSite = this.mainEditor.getSite();
        if (ownerSite instanceof MultiPageEditorSite) {
            final MultiPageEditorPart ownerMultiPageEditor = ((MultiPageEditorSite)ownerSite).getMultiPageEditor();
            this.nestedEditorSite = new TabbedFolderPageEditorSite(ownerMultiPageEditor, this.editor);
            if (ownerMultiPageEditor instanceof IPropertyChangeReflector) {
                this.editor.addPropertyListener(new IPropertyListener(){

                    public void propertyChanged(Object source, int propId) {
                        ((IPropertyChangeReflector)ownerMultiPageEditor).handlePropertyChange(propId);
                    }
                });
            }
        } else {
            this.nestedEditorSite = new SubEditorSite((IWorkbenchPartSite)this.mainEditor.getEditorSite());
        }
        try {
            this.editor.init(this.nestedEditorSite, this.editorDescriptor.getNestedEditorInput(this.mainEditor.getEditorInput()));
        }
        catch (PartInitException e) {
            DBUserInterface.getInstance().showError("Create SQL viewer", null, (Throwable)e);
        }
        this.editor.createPartControl(parent);
        if (this.editor instanceof ISingleControlEditor) {
            Control editorControl = ((ISingleControlEditor)this.editor).getEditorControl();
            assert (editorControl != null);
            editorControl.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    ISelectionProvider selectionProvider = TabbedFolderPageEditor.this.editor.getSite().getSelectionProvider();
                    TabbedFolderPageEditor.this.mainEditor.getSite().setSelectionProvider(selectionProvider);
                    if (TabbedFolderPageEditor.this.actionContributor != null) {
                        TabbedFolderPageEditor.this.actionContributor.setActiveEditor(TabbedFolderPageEditor.this.editor);
                    }
                    TabbedFolderPageEditor.this.activateNestedSite(true);
                }

                public void focusLost(FocusEvent e) {
                    TabbedFolderPageEditor.this.activateNestedSite(false);
                    if (TabbedFolderPageEditor.this.actionContributor != null) {
                        TabbedFolderPageEditor.this.actionContributor.setActiveEditor(null);
                    }
                }
            });
        }
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TabbedFolderPageEditor.this.editor != null) {
                    TabbedFolderPageEditor.this.editor.dispose();
                    TabbedFolderPageEditor.this.editor = null;
                }
            }
        });
    }

    @Override
    public void dispose() {
        if (this.nestedEditorSite instanceof MultiPageEditorSite) {
            ((MultiPageEditorSite)this.nestedEditorSite).dispose();
            this.nestedEditorSite = null;
        }
        super.dispose();
    }

    @Override
    public void setFocus() {
        this.editor.setFocus();
    }

    @Override
    public void aboutToBeShown() {
        if (this.editor instanceof IActiveWorkbenchPart) {
            ((IActiveWorkbenchPart)this.editor).activatePart();
        }
    }

    @Override
    public void aboutToBeHidden() {
        if (this.editor instanceof IActiveWorkbenchPart) {
            ((IActiveWorkbenchPart)this.editor).deactivatePart();
        }
    }

    private void activateNestedSite(boolean activate) {
        IKeyBindingService keyBindingService;
        if (this.nestedEditorSite instanceof INestable) {
            if (activate) {
                ((INestable)this.nestedEditorSite).activate();
            } else {
                ((INestable)this.nestedEditorSite).deactivate();
            }
        }
        if (this.nestedEditorSite instanceof MultiPageEditorSite && (keyBindingService = ((MultiPageEditorSite)this.nestedEditorSite).getMultiPageEditor().getEditorSite().getKeyBindingService()) instanceof INestableKeyBindingService) {
            ((INestableKeyBindingService)keyBindingService).activateKeyBindingService((IWorkbenchSite)(activate ? this.nestedEditorSite : null));
        }
    }

    public void refreshPart(Object source, boolean force) {
        if (this.editor instanceof IRefreshablePart) {
            ((IRefreshablePart)this.editor).refreshPart(source, force);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.editor != null) {
            if (adapter.isAssignableFrom(this.editor.getClass())) {
                return adapter.cast(this.editor);
            }
            return (T)this.editor.getAdapter(adapter);
        }
        return null;
    }

    @Override
    public IEditorActionBarContributor getContributor(IDatabaseEditorContributorManager manager) {
        Class<? extends IEditorActionBarContributor> contributorClass = this.editorDescriptor.getContributorClass();
        if (contributorClass == null) {
            return null;
        }
        this.actionContributor = manager.getContributor(contributorClass);
        if (this.actionContributor == null) {
            try {
                this.actionContributor = contributorClass.newInstance();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return this.actionContributor;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.editor != null) {
            this.editor.doSave(monitor);
        }
    }

    public void doSaveAs() {
        if (this.editor != null) {
            this.editor.doSaveAs();
        }
    }

    public boolean isDirty() {
        return this.editor != null && this.editor.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return this.editor != null && this.editor.isSaveAsAllowed();
    }

    public boolean isSaveOnCloseNeeded() {
        return this.editor != null && this.editor.isSaveOnCloseNeeded();
    }

    private class TabbedFolderPageEditorSite
    extends MultiPageEditorSite
    implements ITabbedFolderEditorSite {
        public TabbedFolderPageEditorSite(MultiPageEditorPart multiPageEditor, IEditorPart editor) {
            super(multiPageEditor, editor);
        }

        public String getId() {
            String id = TabbedFolderPageEditor.this.editorDescriptor.getId();
            return id;
        }

        @Override
        @NotNull
        public IEditorPart getFolderEditor() {
            return TabbedFolderPageEditor.this.mainEditor;
        }
    }
}

