/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.WorkbenchJob;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverGalleryViewer;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverTreeViewer;
import org.jkiss.utils.CommonUtils;

public class DriverSelectViewer
extends Viewer {
    private static final int REFRESH_DELAY = 200;
    private static final String CLEAR_ICON = "org.jkiss.dbeaver.ui.dialogs.driver.DriverSelectViewer.CLEAR_ICON";
    private static final String DISABLED_CLEAR_ICON = "org.jkiss.dbeaver.ui.dialogs.driver.DriverSelectViewer.DCLEAR_ICON";
    private static final String PROP_SELECTOR_VIEW_TYPE = "driver.selector.view.type";
    private ToolItem switchItem;
    private final Object site;
    private final List<DataSourceProviderDescriptor> providers;
    private final boolean expandRecent;
    private final Composite composite;
    private StructuredViewer selectorViewer;
    private Text filterText;
    private Job refreshJob;
    private Composite selectorComposite;

    static {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/etool16/clear_co.png");
        if (descriptor != null) {
            JFaceResources.getImageRegistry().put(CLEAR_ICON, descriptor);
        }
        if ((descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/dtool16/clear_co.png")) != null) {
            JFaceResources.getImageRegistry().put(DISABLED_CLEAR_ICON, descriptor);
        }
    }

    private static SelectorViewType getCurrentSelectorViewType() {
        String viewTypeStr = DBeaverCore.getGlobalPreferenceStore().getString(PROP_SELECTOR_VIEW_TYPE);
        if (viewTypeStr == null) {
            return SelectorViewType.tree;
        }
        try {
            return SelectorViewType.valueOf(viewTypeStr);
        }
        catch (IllegalArgumentException e) {
            return SelectorViewType.tree;
        }
    }

    private static void setCurrentSelectorViewType(SelectorViewType viewType) {
        DBeaverCore.getGlobalPreferenceStore().setValue(PROP_SELECTOR_VIEW_TYPE, viewType.name());
    }

    public DriverSelectViewer(Composite parent, Object site, List<DataSourceProviderDescriptor> providers, boolean expandRecent) {
        this.site = site;
        this.providers = providers;
        this.expandRecent = expandRecent;
        this.composite = new Composite(parent, 0);
        if (parent.getLayout() instanceof GridLayout) {
            this.composite.setLayoutData((Object)new GridData(1808));
        }
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite.setLayout((Layout)layout);
        this.createFilterControl();
        this.selectorComposite = UIUtils.createComposite((Composite)this.composite, (int)1);
        this.selectorComposite.setLayoutData((Object)new GridData(1808));
        this.selectorComposite.setForeground(this.filterText.getForeground());
        this.selectorComposite.setBackground(this.filterText.getBackground());
        this.createSelectorControl();
        this.refreshJob = this.createRefreshJob();
    }

    private Control getSelectorControl() {
        return this.selectorViewer.getControl();
    }

    private void createFilterControl() {
        Composite filterComposite = new Composite(this.composite, 2048);
        GridLayout filterLayout = new GridLayout(2, false);
        filterLayout.marginHeight = 0;
        filterLayout.marginWidth = 0;
        filterComposite.setLayout((Layout)filterLayout);
        filterComposite.setFont(this.composite.getFont());
        this.filterText = new Text(filterComposite, 4);
        this.filterText.setMessage(CoreMessages.dialog_connection_driver_treecontrol_initialText);
        this.filterText.setLayoutData((Object)new GridData(768));
        this.filterText.addModifyListener(e -> this.textChanged());
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x1000002 || keyEvent.keyCode == 13) {
                    DriverSelectViewer.this.getSelectorControl().setFocus();
                }
            }
        });
        filterComposite.setBackground(this.filterText.getBackground());
        filterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.createFilterToolbar(filterComposite);
    }

    private void createFilterToolbar(Composite parent) {
        Image inactiveImage = JFaceResources.getImageRegistry().getDescriptor(DISABLED_CLEAR_ICON).createImage();
        Image activeImage = JFaceResources.getImageRegistry().getDescriptor(CLEAR_ICON).createImage();
        ToolBar switcherToolbar = new ToolBar(parent, 131328);
        ToolItem clearItem = new ToolItem(switcherToolbar, 8);
        clearItem.setImage(activeImage);
        clearItem.setDisabledImage(inactiveImage);
        clearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverSelectViewer.this.clearText();
                DriverSelectViewer.this.filterText.setFocus();
            }
        });
        clearItem.addDisposeListener(e -> {
            inactiveImage.dispose();
            activeImage.dispose();
        });
        this.switchItem = new ToolItem(switcherToolbar, 36);
        this.switchItem.setText("Toggle view");
        this.switchItem.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_SCHEMA));
        this.switchItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverSelectViewer.this.switchSelectorControl();
            }
        });
        switcherToolbar.setBackground(this.filterText.getBackground());
    }

    private void clearText() {
        this.filterText.setText("");
        this.textChanged();
    }

    @NotNull
    private String getFilterString() {
        return this.filterText != null ? this.filterText.getText() : "";
    }

    private void textChanged() {
        this.refreshJob.cancel();
        this.refreshJob.schedule(200L);
    }

    private void createSelectorControl() {
        if (DriverSelectViewer.getCurrentSelectorViewType() == SelectorViewType.tree) {
            this.switchItem.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_SCHEMA));
            this.switchItem.setSelection(true);
            this.selectorViewer = new DriverTreeViewer(this.selectorComposite, 2816);
            this.selectorViewer.getControl().setLayoutData((Object)new GridData(1808));
            UIUtils.asyncExec(() -> {
                if (this.selectorViewer instanceof DriverTreeViewer) {
                    ((DriverTreeViewer)this.selectorViewer).initDrivers(this.site, this.providers, this.expandRecent);
                }
            });
        } else {
            this.switchItem.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_TABLE));
            this.switchItem.setSelection(false);
            this.selectorViewer = new DriverGalleryViewer(this.selectorComposite, this.site, this.providers, this.expandRecent);
            this.selectorViewer.getControl().setLayoutData((Object)new GridData(1808));
            this.selectorViewer.getControl().addTraverseListener(e -> {
                IWizardContainer container;
                if (e.detail == 2 && this.site instanceof IWizardPage && (container = ((IWizardPage)this.site).getWizard().getContainer()) instanceof Window) {
                    ((Window)container).close();
                }
            });
        }
    }

    private void switchSelectorControl() {
        this.selectorComposite.setRedraw(false);
        try {
            SelectorViewType viewType = DriverSelectViewer.getCurrentSelectorViewType();
            viewType = viewType == SelectorViewType.tree ? SelectorViewType.browser : SelectorViewType.tree;
            DriverSelectViewer.setCurrentSelectorViewType(viewType);
            ISelection curSelection = this.selectorViewer.getSelection();
            this.selectorViewer.getControl().dispose();
            this.createSelectorControl();
            if (curSelection instanceof StructuredSelection && !curSelection.isEmpty()) {
                Object element = ((StructuredSelection)curSelection).getFirstElement();
                UIUtils.asyncExec(() -> this.selectorViewer.setSelection((ISelection)new StructuredSelection(element), true));
            }
            this.selectorComposite.layout(true, true);
        }
        finally {
            this.selectorComposite.setRedraw(true);
        }
        if (!CommonUtils.isEmpty((String)this.filterText.getText())) {
            this.textChanged();
        }
    }

    private WorkbenchJob createRefreshJob() {
        return new WorkbenchJob("Refresh driver filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (DriverSelectViewer.this.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                DriverSelectViewer.this.selectorViewer.getControl().setRedraw(false);
                try {
                    String text = DriverSelectViewer.this.getFilterString();
                    if (CommonUtils.isEmpty((String)text)) {
                        DriverSelectViewer.this.selectorViewer.setFilters(new ViewerFilter[0]);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    DriverFilter driverFilter = new DriverFilter();
                    driverFilter.setPattern(text);
                    DriverSelectViewer.this.selectorViewer.setFilters(new ViewerFilter[]{driverFilter});
                    if (DriverSelectViewer.this.selectorViewer instanceof AbstractTreeViewer) {
                        ((AbstractTreeViewer)DriverSelectViewer.this.selectorViewer).expandAll();
                    }
                }
                finally {
                    DriverSelectViewer.this.selectorViewer.getControl().setRedraw(true);
                }
                return Status.OK_STATUS;
            }
        };
    }

    public Control getControl() {
        return this.composite;
    }

    public Object getInput() {
        return this.selectorViewer.getInput();
    }

    public ISelection getSelection() {
        return this.selectorViewer.getSelection();
    }

    public void refresh() {
        this.selectorViewer.refresh();
    }

    public void refresh(DBPDriver driver) {
        this.selectorViewer.refresh((Object)driver);
    }

    public void setInput(Object input) {
        this.selectorViewer.setInput(input);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.selectorViewer.setSelection(selection, reveal);
    }

    private static class DriverFilter
    extends PatternFilter {
        DriverFilter() {
            this.setIncludeLeadingWildcard(true);
        }

        public boolean isElementVisible(Viewer viewer, Object element) {
            Object parent = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getParent(element);
            if (parent != null && this.isLeafMatch(viewer, parent)) {
                return true;
            }
            return this.isParentMatch(viewer, element) || this.isLeafMatch(viewer, element);
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            if (element instanceof DriverDescriptor) {
                return this.wordMatches(((DriverDescriptor)((Object)element)).getName()) || this.wordMatches(((DriverDescriptor)((Object)element)).getDescription());
            }
            return super.isLeafMatch(viewer, element);
        }
    }

    private static enum SelectorViewType {
        tree,
        browser;

    }
}

