/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.registry.driver.DriverDependencies;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverDownloadAutoPage;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverDownloadDialog;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverDownloadManualPage;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverDownloadPage;
import org.jkiss.utils.CommonUtils;

public class DriverDownloadWizard
extends Wizard
implements IExportWizard {
    private static final String DRIVER_DOWNLOAD_DIALOG_SETTINGS = "DriverDownload";
    private DriverDescriptor driver;
    private DriverDependencies dependencies;
    private boolean updateVersion;
    private boolean forceDownload;
    private DriverDownloadPage downloadPage;

    public DriverDownloadWizard(@NotNull DriverDescriptor driver, DriverDependencies dependencies, boolean updateVersion, boolean forceDownload) {
        this.driver = driver;
        this.dependencies = dependencies;
        this.updateVersion = updateVersion;
        this.forceDownload = forceDownload;
        this.setWindowTitle(updateVersion ? CoreMessages.dialog_driver_download_wizard_title_upload_files : CoreMessages.dialog_driver_download_wizard_title_setup_files);
        this.setNeedsProgressMonitor(this.isAutoDownloadWizard());
        this.loadSettings();
    }

    DriverDescriptor getDriver() {
        return this.driver;
    }

    public DriverDependencies getDependencies() {
        return this.dependencies;
    }

    public boolean isForceDownload() {
        return this.forceDownload;
    }

    public void setForceDownload(boolean forceDownload) {
        this.forceDownload = forceDownload;
    }

    public boolean isUpdateVersion() {
        return this.updateVersion;
    }

    public DriverDownloadDialog getContainer() {
        return (DriverDownloadDialog)super.getContainer();
    }

    private void loadSettings() {
        IDialogSettings section = UIUtils.getDialogSettings((String)DRIVER_DOWNLOAD_DIALOG_SETTINGS);
        this.setDialogSettings(section);
    }

    public void addPages() {
        super.addPages();
        this.downloadPage = this.isAutoDownloadWizard() ? new DriverDownloadAutoPage() : new DriverDownloadManualPage();
        this.addPage((IWizardPage)this.downloadPage);
    }

    void pageActivated(Object selectedPage) {
        this.downloadPage.resolveLibraries();
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.setWindowTitle(CoreMessages.dialog_driver_download_wizard_title_setting);
        this.setNeedsProgressMonitor(this.isAutoDownloadWizard());
        this.setHelpAvailable(false);
    }

    public boolean canFinish() {
        return true;
    }

    public boolean performFinish() {
        return this.downloadPage.performFinish();
    }

    public String getFinishText() {
        if (this.isAutoDownloadWizard()) {
            return CoreMessages.dialog_driver_download_wizard_download;
        }
        return CoreMessages.dialog_driver_download_wizard_open_download;
    }

    public boolean isAutoDownloadWizard() {
        return CommonUtils.isEmpty(this.getDriver().getDriverFileSources());
    }
}

