/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.view;

import java.util.List;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.AbstractPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;

public class StatisticsPresentation
extends AbstractPresentation {
    private Table table;
    private DBDAttributeBinding curAttribute;

    @Override
    public void createPresentation(@NotNull IResultSetController controller, @NotNull Composite parent) {
        super.createPresentation(controller, parent);
        UIUtils.createHorizontalLine((Composite)parent);
        this.table = new Table(parent, 65538);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatisticsPresentation.this.curAttribute = null;
                TableItem[] selection = StatisticsPresentation.this.table.getSelection();
                Object[] elements = new Object[selection.length];
                int i = 0;
                while (i < selection.length) {
                    elements[i] = selection[i].getData();
                    if (StatisticsPresentation.this.curAttribute == null) {
                        StatisticsPresentation.this.curAttribute = (DBDAttributeBinding)elements[i];
                    }
                    ++i;
                }
                StatisticsPresentation.this.fireSelectionChanged((ISelection)new StructuredSelection(elements));
            }
        });
        UIUtils.createTableColumn((Table)this.table, (int)16384, (String)"Name");
        UIUtils.createTableColumn((Table)this.table, (int)16384, (String)"Value");
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(manager -> UIUtils.fillDefaultTableContextMenu((IContributionManager)manager, (Table)this.table));
        menuMgr.setRemoveAllWhenShown(true);
        this.table.setMenu(menuMgr.createContextMenu((Control)this.table));
    }

    @Override
    public Control getControl() {
        return this.table;
    }

    @Override
    public void refreshData(boolean refreshMetadata, boolean append, boolean keepState) {
        this.table.removeAll();
        if (this.controller.getModel().getRowCount() > 0) {
            ResultSetRow row = this.controller.getModel().getRow(0);
            List<DBDAttributeBinding> visibleAttributes = this.controller.getModel().getVisibleAttributes();
            int i = 0;
            while (i < visibleAttributes.size()) {
                DBDAttributeBinding attr = visibleAttributes.get(i);
                Object value = row.getValues()[i];
                TableItem item = new TableItem(this.table, 16384);
                item.setText(0, attr.getName());
                item.setText(1, DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)DBDDisplayFormat.UI));
                item.setData((Object)attr);
                ++i;
            }
        }
        UIUtils.packColumns((Table)this.table);
    }

    @Override
    public void formatData(boolean refreshData) {
    }

    @Override
    public void clearMetaData() {
    }

    @Override
    public void updateValueView() {
    }

    @Override
    public void changeMode(boolean recordMode) {
    }

    @Override
    @Nullable
    public DBDAttributeBinding getCurrentAttribute() {
        return this.curAttribute;
    }

    @Override
    @Nullable
    public String copySelectionToString(ResultSetCopySettings settings) {
        return null;
    }
}

