/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.grouping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.StringEditorTable;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingResultsContainer;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

class GroupingConfigDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.GroupingConfigDialog";
    private final GroupingResultsContainer resultsContainer;
    private Table columnsTable;
    private Table functionsTable;

    public GroupingConfigDialog(Shell parentShell, GroupingResultsContainer resultsContainer) {
        super(parentShell, "Grouping configuration", (DBPImage)UIIcon.PANEL_AGGREGATE);
        this.resultsContainer = resultsContainer;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        ArrayList<String> proposals = new ArrayList<String>();
        DBDAttributeBinding[] dBDAttributeBindingArray = this.resultsContainer.getOwnerPresentation().getController().getModel().getAttributes();
        int n = dBDAttributeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
            proposals.add(attr.getName());
            ++n2;
        }
        SimpleContentProposalProvider proposalProvider = new SimpleContentProposalProvider(new String[0]);
        proposalProvider.setFiltering(true);
        proposalProvider.setProposals(proposals.toArray(new String[0]));
        this.columnsTable = StringEditorTable.createEditableList(composite, "Columns", this.resultsContainer.getGroupAttributes(), (DBPImage)DBIcon.TREE_ATTRIBUTE, (IContentProposalProvider)proposalProvider);
        Collections.addAll(proposals, "COUNT", "AVG", "MAX", "MIN", "SUM");
        proposalProvider.setProposals(proposals.toArray(new String[0]));
        this.functionsTable = StringEditorTable.createEditableList(composite, "Functions", this.resultsContainer.getGroupFunctions(), (DBPImage)DBIcon.TREE_FUNCTION, (IContentProposalProvider)proposalProvider);
        return composite;
    }

    protected void okPressed() {
        List<String> columns = StringEditorTable.collectValues(this.columnsTable);
        List<String> functions = StringEditorTable.collectValues(this.functionsTable);
        this.resultsContainer.setGrouping(columns, functions);
        super.okPressed();
    }
}

