/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.navigator;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorViewBase;
import org.jkiss.utils.CommonUtils;

public class NavigatorHandlerLocalFolderCreate
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            ArrayList<DBNDataSource> dataSources = new ArrayList<DBNDataSource>();
            DBNProjectDatabases databasesNode = null;
            DBNLocalFolder parentFolder = null;
            for (Object element : structSelection) {
                if (element instanceof DBNDataSource) {
                    dataSources.add((DBNDataSource)element);
                    element = ((DBNDataSource)element).getParentNode();
                }
                if (element instanceof DBNLocalFolder) {
                    parentFolder = (DBNLocalFolder)element;
                    databasesNode = parentFolder.getParentNode();
                    continue;
                }
                if (!(element instanceof DBNProjectDatabases)) continue;
                databasesNode = (DBNProjectDatabases)element;
            }
            if (databasesNode != null) {
                NavigatorHandlerLocalFolderCreate.createFolder(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), activePart, databasesNode, parentFolder, dataSources, null);
            }
        }
        return null;
    }

    public static boolean createFolder(IWorkbenchWindow workbenchWindow, IWorkbenchPart activePart, DBNProjectDatabases databases, final DBNLocalFolder parentFolder, Collection<DBNDataSource> nodes, String newName) {
        TreeViewer viewer;
        if (newName == null) {
            newName = EnterNameDialog.chooseName((Shell)workbenchWindow.getShell(), (String)"Folder name");
        }
        if (CommonUtils.isEmpty((String)newName)) {
            return false;
        }
        DBPDataSourceRegistry dsRegistry = databases.getDataSourceRegistry();
        DBPDataSourceFolder folder = dsRegistry.addFolder(parentFolder == null ? null : parentFolder.getFolder(), newName);
        for (DBNDataSource node : nodes) {
            node.setFolder(folder);
        }
        if (parentFolder != null && activePart instanceof NavigatorViewBase && (viewer = ((NavigatorViewBase)activePart).getNavigatorViewer()) != null) {
            UIUtils.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    viewer.expandToLevel((Object)parentFolder, 1);
                }
            });
        }
        DBNModel.updateConfigAndRefreshDatabases((DBNNode)databases);
        return true;
    }
}

