/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.formatter;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.impl.preferences.SimplePreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.registry.formatter.DataFormatterDescriptor;
import org.jkiss.dbeaver.registry.formatter.DataFormatterRegistry;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class DataFormatterProfile
implements DBDDataFormatterProfile,
DBPPreferenceListener {
    private static final String PROP_LANGUAGE = "dataformat.profile.language";
    private static final String PROP_COUNTRY = "dataformat.profile.country";
    private static final String PROP_VARIANT = "dataformat.profile.variant";
    public static final String DATAFORMAT_PREFIX = "dataformat.";
    public static final String DATAFORMAT_TYPE_PREFIX = "dataformat.type.";
    private DBPPreferenceStore store;
    private String name;
    private Locale locale;

    public DataFormatterProfile(String profileName, DBPPreferenceStore store) {
        this.name = profileName;
        this.store = store;
        this.loadProfile();
    }

    private void loadProfile() {
        String language = this.store.getString(PROP_LANGUAGE);
        String country = this.store.getString(PROP_COUNTRY);
        String variant = this.store.getString(PROP_VARIANT);
        this.locale = CommonUtils.isEmpty((String)language) ? Locale.getDefault() : (CommonUtils.isEmpty((String)country) ? new Locale(language) : (CommonUtils.isEmpty((String)variant) ? new Locale(language, country) : new Locale(language, country, variant)));
    }

    public void saveProfile() throws IOException {
        this.store.setValue(PROP_LANGUAGE, this.locale.getLanguage());
        this.store.setValue(PROP_COUNTRY, this.locale.getCountry());
        this.store.setValue(PROP_VARIANT, this.locale.getVariant());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)this.store);
    }

    public DBPPreferenceStore getPreferenceStore() {
        return this.store;
    }

    public String getProfileName() {
        return this.name;
    }

    public void setProfileName(String name) {
        this.name = name;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Map<Object, Object> getFormatterProperties(String typeId) {
        DataFormatterDescriptor formatter = DataFormatterRegistry.getInstance().getDataFormatter(typeId);
        Map defaultProperties = formatter.getSample().getDefaultProperties(this.locale);
        HashMap<Object, Object> formatterProps = new HashMap<Object, Object>();
        for (DBPPropertyDescriptor prop : formatter.getProperties()) {
            Object defaultValue = defaultProperties.get(prop.getId());
            Object propValue = PrefUtils.getPreferenceValue((DBPPreferenceStore)this.store, (String)(DATAFORMAT_TYPE_PREFIX + formatter.getId() + "." + prop.getId()), (Class)prop.getDataType());
            if (propValue == null || CommonUtils.equalObjects(defaultValue, (Object)propValue)) continue;
            formatterProps.put(prop.getId(), propValue);
        }
        return formatterProps;
    }

    public void setFormatterProperties(String typeId, Map<Object, Object> formatterProps) {
        DataFormatterDescriptor formatter = DataFormatterRegistry.getInstance().getDataFormatter(typeId);
        for (DBPPropertyDescriptor prop : formatter.getProperties()) {
            Object propValue;
            Object object = propValue = formatterProps == null ? null : formatterProps.get(prop.getId());
            if (propValue != null) {
                PrefUtils.setPreferenceValue((DBPPreferenceStore)this.store, (String)(DATAFORMAT_TYPE_PREFIX + formatter.getId() + "." + prop.getId()), (Object)propValue);
                continue;
            }
            this.store.setToDefault(DATAFORMAT_TYPE_PREFIX + formatter.getId() + "." + prop.getId());
        }
    }

    public boolean isOverridesParent() {
        if (this.store instanceof SimplePreferenceStore) {
            SimplePreferenceStore prefStore = (SimplePreferenceStore)this.store;
            if (prefStore.isSet(PROP_LANGUAGE) || prefStore.isSet(PROP_COUNTRY) || prefStore.isSet(PROP_VARIANT)) {
                return true;
            }
            for (DataFormatterDescriptor formatter : DataFormatterRegistry.getInstance().getDataFormatters()) {
                for (DBPPropertyDescriptor prop : formatter.getProperties()) {
                    if (!prefStore.isSet(DATAFORMAT_TYPE_PREFIX + formatter.getId() + "." + prop.getId())) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public void reset() {
        if (this.store instanceof SimplePreferenceStore) {
            this.store.setToDefault(PROP_LANGUAGE);
            this.store.setToDefault(PROP_COUNTRY);
            this.store.setToDefault(PROP_VARIANT);
            for (DataFormatterDescriptor formatter : DataFormatterRegistry.getInstance().getDataFormatters()) {
                for (DBPPropertyDescriptor prop : formatter.getProperties()) {
                    this.store.setToDefault(DATAFORMAT_TYPE_PREFIX + formatter.getId() + "." + prop.getId());
                }
            }
        }
        this.loadProfile();
    }

    public DBDDataFormatter createFormatter(String typeId, DBSTypedObject type) throws IllegalAccessException, InstantiationException, IllegalArgumentException {
        DataFormatterDescriptor descriptor = DataFormatterRegistry.getInstance().getDataFormatter(typeId);
        if (descriptor == null) {
            throw new IllegalArgumentException("Formatter '" + typeId + "' not found");
        }
        DBDDataFormatter formatter = descriptor.createFormatter();
        Map defProps = descriptor.getSample().getDefaultProperties(this.locale);
        Map<Object, Object> props = this.getFormatterProperties(typeId);
        HashMap<Object, Object> formatterProps = new HashMap<Object, Object>();
        if (defProps != null && !defProps.isEmpty()) {
            formatterProps.putAll(defProps);
        }
        if (props != null && !props.isEmpty()) {
            formatterProps.putAll(props);
        }
        formatter.init(type, this.locale, formatterProps);
        return formatter;
    }

    public static void initDefaultPreferences(DBPPreferenceStore store, Locale locale) {
        for (DataFormatterDescriptor formatter : DataFormatterRegistry.getInstance().getDataFormatters()) {
            Map defaultProperties = formatter.getSample().getDefaultProperties(locale);
            HashMap formatterProps = new HashMap();
            for (DBPPropertyDescriptor prop : formatter.getProperties()) {
                Object defaultValue = defaultProperties.get(prop.getId());
                if (defaultValue == null) continue;
                PrefUtils.setPreferenceDefaultValue((DBPPreferenceStore)store, (String)(DATAFORMAT_TYPE_PREFIX + formatter.getId() + "." + prop.getId()), defaultValue);
            }
        }
    }

    public void preferenceChange(DBPPreferenceListener.PreferenceChangeEvent event) {
        if (event.getProperty() != null && event.getProperty().startsWith(DATAFORMAT_PREFIX)) {
            this.loadProfile();
        }
    }
}

