/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.IOException;
import java.util.Map;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.impl.preferences.SimplePreferenceStore;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.utils.CommonUtils;

public class DataSourcePreferenceStore
extends SimplePreferenceStore {
    private final DataSourceDescriptor dataSourceDescriptor;

    DataSourcePreferenceStore(DataSourceDescriptor dataSourceDescriptor) {
        super(DBeaverCore.getGlobalPreferenceStore());
        this.dataSourceDescriptor = dataSourceDescriptor;
        Map<Object, Object> defaultConnectionProperties = dataSourceDescriptor.getDriver().getDefaultConnectionProperties();
        for (Map.Entry<Object, Object> prop : defaultConnectionProperties.entrySet()) {
            String propName = CommonUtils.toString((Object)prop.getKey());
            if (!propName.startsWith("@dbeaver-default-")) continue;
            this.getDefaultProperties().put(propName.substring("@dbeaver-default-".length()), CommonUtils.toString((Object)prop.getValue()));
        }
    }

    public DataSourceDescriptor getDataSourceDescriptor() {
        return this.dataSourceDescriptor;
    }

    public void save() throws IOException {
        this.dataSourceDescriptor.getRegistry().flushConfig();
    }
}

