/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.registry.ProjectRegistry;
import org.jkiss.dbeaver.registry.ResourceHandlerDescriptor;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.utils.CommonUtils;
import org.osgi.service.prefs.BackingStoreException;

public class PrefPageProjectSettings
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.projectSettings";
    private static final Log log = Log.getLog(PrefPageProjectSettings.class);
    private IProject project;
    private Table resourceTable;
    private TableEditor handlerTableEditor;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        UIUtils.createControlLabel((Composite)composite, (String)CoreMessages.pref_page_projects_settings_label_resource_location);
        this.resourceTable = new Table(composite, 67588);
        this.resourceTable.setLayoutData((Object)new GridData(1808));
        this.resourceTable.setHeaderVisible(true);
        this.resourceTable.setLinesVisible(true);
        UIUtils.createTableColumn((Table)this.resourceTable, (int)16384, (String)CoreMessages.pref_page_projects_settings_label_resource);
        UIUtils.createTableColumn((Table)this.resourceTable, (int)16384, (String)CoreMessages.pref_page_projects_settings_label_folder);
        this.resourceTable.setHeaderVisible(true);
        this.resourceTable.setLayoutData((Object)new GridData(1808));
        this.handlerTableEditor = new TableEditor(this.resourceTable);
        this.handlerTableEditor.verticalAlignment = 128;
        this.handlerTableEditor.horizontalAlignment = 131072;
        this.handlerTableEditor.grabHorizontal = true;
        this.handlerTableEditor.grabVertical = true;
        this.resourceTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                PrefPageProjectSettings.this.disposeOldEditor();
                final TableItem item = PrefPageProjectSettings.this.resourceTable.getItem(new Point(0, e.y));
                if (item == null) {
                    return;
                }
                int columnIndex = UIUtils.getColumnAtPos((TableItem)item, (int)e.x, (int)e.y);
                if (columnIndex <= 0) {
                    return;
                }
                if (columnIndex == 1) {
                    String resourcePath = item.getText(1);
                    if (PrefPageProjectSettings.this.project != null) {
                        Object[] result;
                        IFolder folder = PrefPageProjectSettings.this.project.getFolder(resourcePath);
                        ContainerSelectionDialog dialog = new ContainerSelectionDialog(PrefPageProjectSettings.this.resourceTable.getShell(), (IContainer)folder, true, String.valueOf(CoreMessages.pref_page_projects_settings_label_select) + item.getText(0) + CoreMessages.pref_page_projects_settings_label_root_folder);
                        dialog.showClosedProjects(false);
                        dialog.setValidator(new ISelectionValidator(){

                            public String isValid(Object selection) {
                                if (selection instanceof IPath) {
                                    File file = ((IPath)selection).toFile();
                                    if (file.isHidden() || file.getName().startsWith(".")) {
                                        return CoreMessages.pref_page_projects_settings_label_not_use_hidden_folders;
                                    }
                                    String[] segments = ((IPath)selection).segments();
                                    if (!PrefPageProjectSettings.this.project.getName().equals(segments[0])) {
                                        return CoreMessages.pref_page_projects_settings_label_not_store_resources_in_another_project;
                                    }
                                }
                                return null;
                            }
                        });
                        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1 && result[0] instanceof IPath) {
                            IPath plainPath = ((IPath)result[0]).removeFirstSegments(1).removeTrailingSeparator();
                            item.setText(1, plainPath.toString());
                        }
                    } else {
                        final Text editor = new Text((Composite)PrefPageProjectSettings.this.resourceTable, 0);
                        editor.setText(resourcePath);
                        editor.selectAll();
                        PrefPageProjectSettings.this.handlerTableEditor.setEditor((Control)editor, item, 1);
                        editor.setFocus();
                        editor.addFocusListener((FocusListener)new FocusAdapter(){

                            public void focusLost(FocusEvent e) {
                                item.setText(1, editor.getText());
                            }
                        });
                    }
                }
            }
        });
        UIUtils.createInfoLabel((Composite)composite, (String)CoreMessages.pref_page_projects_settings_label_restart_require_refresh_global_settings);
        this.performDefaults();
        return composite;
    }

    private void disposeOldEditor() {
        Control oldEditor = this.handlerTableEditor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
    }

    protected void performDefaults() {
        this.resourceTable.removeAll();
        ResourceHandlerDescriptor[] resourceHandlerDescriptorArray = DBeaverCore.getInstance().getProjectRegistry().getResourceHandlerDescriptors();
        int n = resourceHandlerDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceHandlerDescriptor descriptor = resourceHandlerDescriptorArray[n2];
            if (descriptor.isManagable()) {
                String defaultRoot;
                TableItem item = new TableItem(this.resourceTable, 0);
                item.setData((Object)descriptor);
                DBPImage icon = descriptor.getIcon();
                if (icon != null) {
                    item.setImage(DBeaverIcons.getImage((DBPImage)icon));
                }
                item.setText(0, descriptor.getName());
                String string = defaultRoot = this.project == null ? null : descriptor.getDefaultRoot(this.project);
                if (defaultRoot != null) {
                    item.setText(1, defaultRoot);
                }
            }
            ++n2;
        }
        UIUtils.packColumns((Table)this.resourceTable, (boolean)true);
        super.performDefaults();
    }

    public boolean performOk() {
        IEclipsePreferences resourceHandlers = ProjectRegistry.getResourceHandlerPreferences(this.project, "resourceRootFolder");
        ArrayList<IResource> refreshedResources = new ArrayList<IResource>();
        TableItem[] tableItemArray = this.resourceTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            ResourceHandlerDescriptor descriptor = (ResourceHandlerDescriptor)((Object)item.getData());
            String rootPath = item.getText(1);
            if (!CommonUtils.equalObjects((Object)descriptor.getDefaultRoot(this.project), (Object)rootPath)) {
                IResource newResource;
                IResource oldResource = this.project.findMember(descriptor.getDefaultRoot(this.project));
                if (oldResource != null) {
                    refreshedResources.add(oldResource);
                }
                if ((newResource = this.project.findMember(rootPath)) != null) {
                    refreshedResources.add(newResource);
                }
                resourceHandlers.put(descriptor.getId(), rootPath);
            }
            ++n2;
        }
        if (!refreshedResources.isEmpty()) {
            for (IResource resource : refreshedResources) {
                NavigatorUtils.refreshNavigatorResource(resource, (Object)this);
            }
        }
        try {
            resourceHandlers.flush();
        }
        catch (BackingStoreException e) {
            log.error((Object)e);
        }
        return super.performOk();
    }

    public IAdaptable getElement() {
        return this.project;
    }

    public void setElement(IAdaptable element) {
        this.project = element instanceof IProject ? (IProject)element : (IProject)DBUtils.getAdapter(IProject.class, (Object)element);
    }
}

