/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.Locale;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorViewBase;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageDatabaseNavigator
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.navigator";
    private Button expandOnConnectCheck;
    private Button showObjectTipsCheck;
    private Button sortCaseInsensitiveCheck;
    private Button sortFoldersFirstCheck;
    private Button groupByDriverCheck;
    private Text longListFetchSizeText;
    private Combo dsDoubleClickBehavior;
    private Combo objDoubleClickBehavior;

    public PrefPageDatabaseNavigator() {
        this.setPreferenceStore(new PreferenceStoreDelegate(DBeaverCore.getGlobalPreferenceStore()));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        Group navigatorGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_database_general_group_navigator, (int)2, (int)0, (int)0);
        this.expandOnConnectCheck = UIUtils.createCheckbox((Composite)navigatorGroup, (String)CoreMessages.pref_page_database_general_label_expand_navigator_tree, (String)"", (boolean)false, (int)2);
        this.showObjectTipsCheck = UIUtils.createCheckbox((Composite)navigatorGroup, (String)CoreMessages.pref_page_database_general_label_show_tips_in_tree, (String)CoreMessages.pref_page_database_general_label_show_tips_in_tree_tip, (boolean)false, (int)2);
        this.sortCaseInsensitiveCheck = UIUtils.createCheckbox((Composite)navigatorGroup, (String)CoreMessages.pref_page_database_general_label_order_elements_alphabetically, (String)"", (boolean)false, (int)2);
        this.sortFoldersFirstCheck = UIUtils.createCheckbox((Composite)navigatorGroup, (String)CoreMessages.pref_page_database_general_label_folders_first, (String)CoreMessages.pref_page_database_general_label_folders_first_tip, (boolean)false, (int)2);
        this.groupByDriverCheck = UIUtils.createCheckbox((Composite)navigatorGroup, (String)CoreMessages.pref_page_database_general_label_group_database_by_driver, (String)"", (boolean)false, (int)2);
        this.groupByDriverCheck.setEnabled(false);
        this.longListFetchSizeText = UIUtils.createLabelText((Composite)navigatorGroup, (String)CoreMessages.pref_page_database_general_label_long_list_fetch_size, (String)"", (int)2048);
        this.longListFetchSizeText.setToolTipText(CoreMessages.pref_page_database_general_label_long_list_fetch_size_tip);
        this.longListFetchSizeText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.objDoubleClickBehavior = UIUtils.createLabelCombo((Composite)navigatorGroup, (String)CoreMessages.pref_page_database_general_label_double_click_node, (int)12);
        this.objDoubleClickBehavior.add(CoreMessages.pref_page_database_general_label_double_click_node_open_properties, 0);
        this.objDoubleClickBehavior.add(CoreMessages.pref_page_database_general_label_double_click_node_expand_collapse, 1);
        this.dsDoubleClickBehavior = UIUtils.createLabelCombo((Composite)navigatorGroup, (String)CoreMessages.pref_page_database_general_label_double_click_connection, (int)12);
        this.dsDoubleClickBehavior.add(CoreMessages.pref_page_database_general_label_double_click_connection_open_properties, NavigatorViewBase.DoubleClickBehavior.EDIT.ordinal());
        this.dsDoubleClickBehavior.add(CoreMessages.pref_page_database_general_label_double_click_connection_conn_disconn, NavigatorViewBase.DoubleClickBehavior.CONNECT.ordinal());
        this.dsDoubleClickBehavior.add(CoreMessages.pref_page_database_general_label_double_click_connection_open_sqleditor, NavigatorViewBase.DoubleClickBehavior.SQL_EDITOR.ordinal());
        this.dsDoubleClickBehavior.add(CoreMessages.pref_page_database_general_label_double_click_connection_expand_collapse, NavigatorViewBase.DoubleClickBehavior.EXPAND.ordinal());
        this.dsDoubleClickBehavior.add(CoreMessages.pref_page_database_general_label_double_click_connection_open_new_sqleditor, NavigatorViewBase.DoubleClickBehavior.SQL_EDITOR_NEW.ordinal());
        this.performDefaults();
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        this.expandOnConnectCheck.setSelection(store.getBoolean("navigator.expand.on.connect"));
        this.showObjectTipsCheck.setSelection(store.getBoolean("navigator.show.objects.tips"));
        this.sortCaseInsensitiveCheck.setSelection(store.getBoolean("navigator.sort.case.insensitive"));
        this.sortFoldersFirstCheck.setSelection(store.getBoolean("navigator.sort.forlers.first"));
        this.groupByDriverCheck.setSelection(store.getBoolean("navigator.group.by.driver"));
        this.longListFetchSizeText.setText(store.getString("navigator.long.list.fetch.size"));
        NavigatorViewBase.DoubleClickBehavior objDCB = NavigatorViewBase.DoubleClickBehavior.valueOf(store.getString("navigator.object.doubleClick"));
        this.objDoubleClickBehavior.select(objDCB == NavigatorViewBase.DoubleClickBehavior.EXPAND ? 1 : 0);
        this.dsDoubleClickBehavior.select(NavigatorViewBase.DoubleClickBehavior.valueOf(store.getString("navigator.connection.doubleClick")).ordinal());
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        store.setValue("navigator.expand.on.connect", this.expandOnConnectCheck.getSelection());
        store.setValue("navigator.show.objects.tips", this.showObjectTipsCheck.getSelection());
        store.setValue("navigator.sort.case.insensitive", this.sortCaseInsensitiveCheck.getSelection());
        store.setValue("navigator.sort.forlers.first", this.sortFoldersFirstCheck.getSelection());
        store.setValue("navigator.group.by.driver", this.groupByDriverCheck.getSelection());
        store.setValue("navigator.long.list.fetch.size", this.longListFetchSizeText.getText());
        NavigatorViewBase.DoubleClickBehavior objDCB = NavigatorViewBase.DoubleClickBehavior.EXPAND;
        if (this.objDoubleClickBehavior.getSelectionIndex() == 0) {
            objDCB = NavigatorViewBase.DoubleClickBehavior.EDIT;
        }
        store.setValue("navigator.object.doubleClick", objDCB.name());
        store.setValue("navigator.connection.doubleClick", ((NavigatorViewBase.DoubleClickBehavior)CommonUtils.fromOrdinal(NavigatorViewBase.DoubleClickBehavior.class, (int)this.dsDoubleClickBehavior.getSelectionIndex())).name());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return true;
    }

    public void applyData(Object data) {
        super.applyData(data);
    }

    @Nullable
    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

