/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageDatabaseEditors
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.editors";
    private Button syncEditorDataSourceWithNavigator;
    private Button showGeneralToolbarEverywhere;
    private Button showEditToolbar;
    private Spinner toolbarDatabaseSelectorWidth;
    private Spinner toolbarSchemaSelectorWidth;

    public PrefPageDatabaseEditors() {
        this.setPreferenceStore(new PreferenceStoreDelegate(DBeaverCore.getGlobalPreferenceStore()));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        Group toolbarsGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_database_general_group_toolbars, (int)2, (int)0, (int)0);
        this.syncEditorDataSourceWithNavigator = UIUtils.createCheckbox((Composite)toolbarsGroup, (String)CoreMessages.pref_page_database_general_label_sync_editor_connection_with_navigator, (String)CoreMessages.pref_page_database_general_label_sync_editor_connection_with_navigator_tip, (boolean)false, (int)2);
        this.showGeneralToolbarEverywhere = UIUtils.createCheckbox((Composite)toolbarsGroup, (String)CoreMessages.pref_page_database_general_label_show_general_toolbar_everywhere, (String)CoreMessages.pref_page_database_general_label_show_general_toolbar_everywhere_tip, (boolean)false, (int)2);
        this.showEditToolbar = UIUtils.createCheckbox((Composite)toolbarsGroup, (String)CoreMessages.pref_page_database_general_label_show_edit_toolbar, (String)CoreMessages.pref_page_database_general_label_show_edit_toolbar_tip, (boolean)false, (int)2);
        this.toolbarDatabaseSelectorWidth = UIUtils.createLabelSpinner((Composite)toolbarsGroup, (String)CoreMessages.pref_page_database_general_label_database_selector_width, (String)CoreMessages.pref_page_database_general_label_database_selector_width_tip, (int)20, (int)10, (int)200);
        this.toolbarSchemaSelectorWidth = UIUtils.createLabelSpinner((Composite)toolbarsGroup, (String)CoreMessages.pref_page_database_general_label_schema_selector_width, (String)CoreMessages.pref_page_database_general_label_schema_selector_width_tip, (int)20, (int)10, (int)200);
        this.performDefaults();
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        this.syncEditorDataSourceWithNavigator.setSelection(store.getBoolean("navigator.sync.editor.datasource"));
        this.showGeneralToolbarEverywhere.setSelection(store.getBoolean("toolbars.show.general.always"));
        this.showEditToolbar.setSelection(store.getBoolean("toolbars.show.edit"));
        this.toolbarDatabaseSelectorWidth.setSelection(store.getInt("toolbars.database.selector.width"));
        this.toolbarSchemaSelectorWidth.setSelection(store.getInt("toolbars.schema.selector.width"));
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        store.setValue("navigator.sync.editor.datasource", this.syncEditorDataSourceWithNavigator.getSelection());
        store.setValue("toolbars.show.general.always", this.showGeneralToolbarEverywhere.getSelection());
        store.setValue("toolbars.show.edit", this.showEditToolbar.getSelection());
        store.setValue("toolbars.database.selector.width", this.toolbarDatabaseSelectorWidth.getSelection());
        store.setValue("toolbars.schema.selector.width", this.toolbarSchemaSelectorWidth.getSelection());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return true;
    }

    public void applyData(Object data) {
        super.applyData(data);
    }

    @Nullable
    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

