/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.registry.formatter.DataFormatterDescriptor;
import org.jkiss.dbeaver.registry.formatter.DataFormatterRegistry;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.LocaleSelectorControl;
import org.jkiss.dbeaver.ui.dialogs.DataFormatProfilesEditDialog;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;

public class PrefPageDataFormat
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.dataformat";
    private DBDDataFormatterProfile formatterProfile;
    private Font boldFont;
    private Combo typeCombo;
    private PropertyTreeViewer propertiesControl;
    private Text sampleText;
    private List<DataFormatterDescriptor> formatterDescriptors;
    private LocaleSelectorControl localeSelector;
    private String profileName;
    private Locale profileLocale;
    private Map<String, Map<Object, Object>> profileProperties = new HashMap<String, Map<Object, Object>>();
    private Combo profilesCombo;
    private PropertySourceCustom propertySource;
    private Button useNativeFormatCheck;

    public PrefPageDataFormat() {
        this.setPreferenceStore(new PreferenceStoreDelegate(DBeaverCore.getGlobalPreferenceStore()));
    }

    @Override
    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        return dataSourceDescriptor.getDataFormatterProfile().isOverridesParent();
    }

    @Override
    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @Override
    protected void createPreferenceHeader(Composite composite) {
        if (!this.isDataSourcePreferencePage()) {
            Composite profileGroup = UIUtils.createPlaceholder((Composite)composite, (int)3);
            profileGroup.setLayoutData((Object)new GridData(768));
            UIUtils.createControlLabel((Composite)profileGroup, (String)CoreMessages.pref_page_data_format_label_profile);
            this.profilesCombo = new Combo(profileGroup, 12);
            this.profilesCombo.setLayoutData((Object)new GridData(768));
            this.profilesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PrefPageDataFormat.this.changeProfile();
                }
            });
            Button editButton = new Button(profileGroup, 8);
            editButton.setText(CoreMessages.pref_page_data_format_button_manage_profiles);
            editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PrefPageDataFormat.this.manageProfiles();
                }
            });
        }
    }

    @Override
    protected Control createPreferenceContent(Composite parent) {
        this.boldFont = UIUtils.makeBoldFont((Font)parent.getFont());
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        this.localeSelector = new LocaleSelectorControl(composite, null);
        this.localeSelector.addListener(13, event -> {
            if (event.data instanceof Locale) {
                this.onLocaleChange((Locale)event.data);
            }
        });
        Group settingsGroup = new Group(composite, 0);
        settingsGroup.setText(CoreMessages.pref_page_data_format_group_settings);
        settingsGroup.setLayout((Layout)new GridLayout(2, false));
        settingsGroup.setLayoutData((Object)new GridData(770));
        this.useNativeFormatCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)CoreMessages.pref_page_data_format_datetime_use_native_formatting, (String)CoreMessages.pref_page_data_format_datetime_use_native_formatting_tip, (boolean)false, (int)2);
        Group formatGroup = new Group(composite, 0);
        formatGroup.setText(CoreMessages.pref_page_data_format_group_format);
        formatGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(770);
        gd.horizontalSpan = 2;
        formatGroup.setLayoutData((Object)gd);
        UIUtils.createControlLabel((Composite)formatGroup, (String)CoreMessages.pref_page_data_format_label_type);
        this.typeCombo = new Combo((Composite)formatGroup, 12);
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageDataFormat.this.reloadFormatter();
            }
        });
        Label propsLabel = UIUtils.createControlLabel((Composite)formatGroup, (String)CoreMessages.pref_page_data_format_label_settingt);
        propsLabel.setLayoutData((Object)new GridData(2));
        this.propertiesControl = new PropertyTreeViewer((Composite)formatGroup, 2048);
        this.propertiesControl.getControl().addListener(24, event -> this.saveFormatterProperties());
        UIUtils.createControlLabel((Composite)formatGroup, (String)CoreMessages.pref_page_data_format_label_sample);
        this.sampleText = new Text((Composite)formatGroup, 2056);
        this.sampleText.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private void manageProfiles() {
        DataFormatProfilesEditDialog dialog = new DataFormatProfilesEditDialog(this.getShell());
        dialog.open();
        this.refreshProfileList();
    }

    private DBDDataFormatterProfile getDefaultProfile() {
        if (this.isDataSourcePreferencePage()) {
            return this.getDataSourceContainer().getDataFormatterProfile();
        }
        return DataFormatterRegistry.getInstance().getGlobalProfile();
    }

    private void changeProfile() {
        DBDDataFormatterProfile newProfile;
        int selectionIndex = this.profilesCombo.getSelectionIndex();
        if (selectionIndex < 0) {
            return;
        }
        if (selectionIndex == 0) {
            newProfile = this.getDefaultProfile();
        } else {
            String newProfileName = this.profilesCombo.getItem(selectionIndex);
            newProfile = DataFormatterRegistry.getInstance().getCustomProfile(newProfileName);
        }
        if (newProfile != this.formatterProfile) {
            this.setCurrentProfile(newProfile);
        }
    }

    private void setCurrentProfile(DBDDataFormatterProfile profile) {
        if (this.formatterProfile == profile) {
            return;
        }
        this.formatterProfile = profile;
        this.formatterDescriptors = new ArrayList<DataFormatterDescriptor>(DataFormatterRegistry.getInstance().getDataFormatters());
        this.profileName = this.formatterProfile.getProfileName();
        this.profileLocale = this.formatterProfile.getLocale();
        this.profileProperties.clear();
        for (DataFormatterDescriptor dfd : this.formatterDescriptors) {
            Map formatterProps = this.formatterProfile.getFormatterProperties(dfd.getId());
            if (formatterProps == null) continue;
            this.profileProperties.put(dfd.getId(), formatterProps);
        }
        try {
            this.localeSelector.setLocale(this.profileLocale);
            this.typeCombo.removeAll();
            for (DataFormatterDescriptor formatter : this.formatterDescriptors) {
                this.typeCombo.add(formatter.getName());
            }
            if (this.typeCombo.getItemCount() > 0) {
                this.typeCombo.select(0);
            }
            this.reloadFormatter();
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    private void refreshProfileList() {
        if (this.isDataSourcePreferencePage()) {
            return;
        }
        int selectionIndex = this.profilesCombo.getSelectionIndex();
        String oldProfile = null;
        if (selectionIndex > 0) {
            oldProfile = this.profilesCombo.getItem(selectionIndex);
        }
        this.profilesCombo.removeAll();
        this.profilesCombo.add("<" + DataFormatterRegistry.getInstance().getGlobalProfile().getProfileName() + ">");
        for (DBDDataFormatterProfile profile : DataFormatterRegistry.getInstance().getCustomProfiles()) {
            this.profilesCombo.add(profile.getProfileName());
        }
        if (oldProfile != null) {
            this.profilesCombo.setText(oldProfile);
        }
        if (this.profilesCombo.getSelectionIndex() < 0) {
            this.profilesCombo.select(0);
        }
        this.profilesCombo.setEnabled(this.profilesCombo.getItemCount() >= 2);
        this.changeProfile();
    }

    private DataFormatterDescriptor getCurrentFormatter() {
        int selectionIndex = this.typeCombo.getSelectionIndex();
        if (selectionIndex < 0) {
            return null;
        }
        return this.formatterDescriptors.get(selectionIndex);
    }

    private void reloadFormatter() {
        DataFormatterDescriptor formatterDescriptor = this.getCurrentFormatter();
        if (formatterDescriptor == null) {
            return;
        }
        Map<Object, Object> formatterProps = this.profileProperties.get(formatterDescriptor.getId());
        Map defaultProps = formatterDescriptor.getSample().getDefaultProperties(this.localeSelector.getSelectedLocale());
        this.propertySource = new PropertySourceCustom(formatterDescriptor.getProperties(), formatterProps);
        this.propertySource.setDefaultValues(defaultProps);
        this.propertiesControl.loadProperties((DBPPropertySource)this.propertySource);
        this.reloadSample();
    }

    private void reloadSample() {
        DataFormatterDescriptor formatterDescriptor = this.getCurrentFormatter();
        if (formatterDescriptor == null) {
            return;
        }
        try {
            DBDDataFormatter formatter = formatterDescriptor.createFormatter();
            Map defProps = formatterDescriptor.getSample().getDefaultProperties(this.profileLocale);
            Map<Object, Object> props = this.profileProperties.get(formatterDescriptor.getId());
            HashMap<Object, Object> formatterProps = new HashMap<Object, Object>();
            if (defProps != null && !defProps.isEmpty()) {
                formatterProps.putAll(defProps);
            }
            if (props != null && !props.isEmpty()) {
                formatterProps.putAll(props);
            }
            formatter.init(null, this.profileLocale, formatterProps);
            String sampleValue = formatter.formatValue(formatterDescriptor.getSample().getSampleValue());
            this.sampleText.setText(sampleValue);
        }
        catch (Exception e) {
            log.warn((Object)"Can't render sample value", (Throwable)e);
        }
    }

    private void saveFormatterProperties() {
        DataFormatterDescriptor formatterDescriptor = this.getCurrentFormatter();
        if (formatterDescriptor == null) {
            return;
        }
        Map props = this.propertySource.getProperties();
        this.profileProperties.put(formatterDescriptor.getId(), props);
        this.reloadSample();
    }

    private void onLocaleChange(Locale locale) {
        if (!locale.equals(this.profileLocale)) {
            this.profileLocale = locale;
            DataFormatterDescriptor formatter = this.getCurrentFormatter();
            if (formatter != null) {
                this.propertySource.setDefaultValues(formatter.getSample().getDefaultProperties(locale));
                this.propertiesControl.refresh();
            }
            this.reloadSample();
        }
    }

    @Override
    protected void loadPreferences(DBPPreferenceStore store) {
        this.refreshProfileList();
        this.setCurrentProfile(this.getDefaultProfile());
        this.useNativeFormatCheck.setSelection(store.getBoolean("resultset.format.datetime.native"));
    }

    @Override
    protected void savePreferences(DBPPreferenceStore store) {
        try {
            this.formatterProfile.setProfileName(this.profileName);
            this.formatterProfile.setLocale(this.profileLocale);
            for (String typeId : this.profileProperties.keySet()) {
                this.formatterProfile.setFormatterProperties(typeId, this.profileProperties.get(typeId));
            }
            this.formatterProfile.saveProfile();
            store.setValue("resultset.format.datetime.native", this.useNativeFormatCheck.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    @Override
    protected void clearPreferences(DBPPreferenceStore store) {
        this.formatterProfile.reset();
        store.setToDefault("resultset.format.datetime.native");
    }

    @Override
    protected String getPropertyPageID() {
        return PAGE_ID;
    }

    @Override
    public void applyData(Object data) {
        super.applyData(data);
        if (data instanceof DBDDataFormatterProfile) {
            UIUtils.setComboSelection((Combo)this.profilesCombo, (String)((DBDDataFormatterProfile)data).getProfileName());
            this.changeProfile();
        }
    }

    public void dispose() {
        this.boldFont.dispose();
        super.dispose();
    }
}

