/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNEmptyNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilter;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorViewBase;
import org.jkiss.utils.CommonUtils;

public class DatabaseBrowserView
extends NavigatorViewBase {
    public static final String VIEW_ID = "org.jkiss.dbeaver.core.databaseBrowser";

    @Override
    protected INavigatorFilter getNavigatorFilter() {
        return new DatabaseNavigatorTreeFilter();
    }

    @Override
    public DBNNode getRootNode() {
        DBNProject projectNode;
        String secondaryId = this.getViewSite().getSecondaryId();
        if (!CommonUtils.isEmpty((String)secondaryId)) {
            try {
                return DatabaseBrowserView.getNodeFromSecondaryId(secondaryId);
            }
            catch (DBException e) {
                DBUserInterface.getInstance().showError("Open database browser", "Can't find database navigator node", (Throwable)e);
            }
        }
        return (projectNode = this.getModel().getRoot().getProject(DBeaverCore.getInstance().getProjectRegistry().getActiveProject())) == null ? new DBNEmptyNode() : projectNode.getDatabases();
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        UIUtils.setHelp((Control)parent, (String)"view-database-navigator");
        String secondaryId = this.getViewSite().getSecondaryId();
        if (!CommonUtils.isEmpty((String)secondaryId)) {
            try {
                DBNNode node = DatabaseBrowserView.getNodeFromSecondaryId(secondaryId);
                this.setPartName(node.getNodeName());
                this.setTitleImage(DBeaverIcons.getImage((DBPImage)node.getNodeIconDefault()));
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
    }

    public static String getSecondaryIdFromNode(DBNNode node) {
        IProject project = null;
        DBNNode dn = node;
        while (dn != null) {
            if (dn instanceof DBNProject) {
                project = ((DBNProject)dn).getProject();
                break;
            }
            dn = dn.getParentNode();
        }
        if (project == null) {
            throw new IllegalStateException("Bad navigator node: " + node.getNodeItemPath());
        }
        return String.valueOf(project.getName()) + "|" + node.getNodeItemPath().replace(":", "~");
    }

    public static DBNNode getNodeFromSecondaryId(String id) throws DBException {
        int divPos = id.indexOf(124);
        if (divPos == -1) {
            throw new DBException("Bad secondary ID: " + id);
        }
        String projectName = id.substring(0, divPos);
        String nodePath = id.substring(divPos + 1).replace("~", ":");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            throw new DBException("Project '" + projectName + "' not found");
        }
        DBNModel navigatorModel = DBeaverCore.getInstance().getNavigatorModel();
        navigatorModel.ensureProjectLoaded(project);
        return navigatorModel.getNodeByPath((DBRProgressMonitor)new VoidProgressMonitor(), project, nodePath);
    }
}

