/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.text;

import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.source.AbstractRulerColumn;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.GC;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.rulers.IContributedRulerColumn;
import org.eclipse.ui.texteditor.rulers.RulerColumnDescriptor;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.editors.text.BaseTextEditor;
import org.jkiss.utils.ArrayUtils;

public class ScriptPositionColumn
extends AbstractRulerColumn
implements IContributedRulerColumn {
    public static final String ID = "org.jkiss.dbeaver.ui.editors.columns.script.position";
    private RulerColumnDescriptor descriptor;
    private ITextEditor editor;
    private int[] currentLines;
    private volatile boolean visible = false;

    public RulerColumnDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(RulerColumnDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setEditor(ITextEditor editor) {
        this.editor = editor;
    }

    public ITextEditor getEditor() {
        return this.editor;
    }

    public void columnCreated() {
        this.visible = true;
        new UIJob("Update script ruler"){
            {
                this.setSystem(true);
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                int[] newCurrentLines;
                if (DBeaverCore.isClosing()) {
                    return Status.CANCEL_STATUS;
                }
                BaseTextEditor editor = (BaseTextEditor)ScriptPositionColumn.this.getEditor();
                if (editor == null || editor.getTextViewer() == null) {
                    return Status.CANCEL_STATUS;
                }
                StyledText textWidget = editor.getTextViewer().getTextWidget();
                if (textWidget == null || textWidget.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                if (textWidget.isVisible() && !Arrays.equals(newCurrentLines = editor.getCurrentLines(), ScriptPositionColumn.this.currentLines)) {
                    ScriptPositionColumn.this.currentLines = newCurrentLines;
                    ScriptPositionColumn.this.redraw();
                }
                if (ScriptPositionColumn.this.visible) {
                    this.schedule(100L);
                }
                return Status.OK_STATUS;
            }
        }.schedule(100L);
    }

    public void columnRemoved() {
        this.visible = false;
    }

    protected void paintLine(GC gc, int modelLine, int widgetLine, int linePixel, int lineHeight) {
        gc.setBackground(this.computeBackground(modelLine));
        gc.fillRectangle(0, linePixel, this.getWidth(), lineHeight);
        if (ArrayUtils.contains((int[])this.currentLines, (int)modelLine)) {
            gc.drawImage(DBeaverIcons.getImage((DBPImage)UIIcon.RULER_POSITION), 0, linePixel);
        }
    }
}

