/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocationManager;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.LocalNativeClientLocation;
import org.jkiss.dbeaver.registry.driver.RemoteNativeClientLocation;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ClientHomesPanel
extends Composite {
    private static final Log log = Log.getLog(ClientHomesPanel.class);
    private static String lastHomeDirectory;
    private Table homesTable;
    private Text idText;
    private Text pathText;
    private Text nameText;
    private Text productNameText;
    private Text productVersionText;
    private Button removeButton;
    private Font fontBold;
    private Font fontItalic;
    private DBPDriver driver;

    public ClientHomesPanel(Composite parent, int style) {
        super(parent, style);
        this.fontBold = UIUtils.makeBoldFont((Font)parent.getFont());
        this.fontItalic = UIUtils.modifyFont((Font)parent.getFont(), (int)2);
        this.addDisposeListener(e -> {
            UIUtils.dispose((Resource)this.fontBold);
            UIUtils.dispose((Resource)this.fontItalic);
        });
        GridLayout layout = new GridLayout(2, false);
        this.setLayout((Layout)layout);
        Composite listGroup = UIUtils.createPlaceholder((Composite)this, (int)1, (int)5);
        listGroup.setLayoutData((Object)new GridData(1040));
        ((GridData)listGroup.getLayoutData()).minimumWidth = 200;
        this.homesTable = new Table(listGroup, 68356);
        this.homesTable.setLayoutData((Object)new GridData(1808));
        this.homesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selection = ClientHomesPanel.this.homesTable.getSelection();
                if (ArrayUtils.isEmpty((Object[])selection)) {
                    ClientHomesPanel.this.selectHome(null);
                } else {
                    ClientHomesPanel.this.selectHome((HomeInfo)selection[0].getData());
                }
            }
        });
        Composite buttonsGroup = UIUtils.createPlaceholder((Composite)listGroup, (int)2, (int)5);
        buttonsGroup.setLayoutData((Object)new GridData(896));
        Button addButton = new Button(buttonsGroup, 8);
        addButton.setText(CoreMessages.controls_client_homes_panel_button_add_home);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClientHomesPanel.this.addClientHome();
            }
        });
        this.removeButton = new Button(buttonsGroup, 8);
        this.removeButton.setText(CoreMessages.controls_client_homes_panel_button_remove_home);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selection = ClientHomesPanel.this.homesTable.getSelection();
                if (!ArrayUtils.isEmpty((Object[])selection)) {
                    ClientHomesPanel.this.removeClientHome();
                }
            }
        });
        Group infoGroup = UIUtils.createControlGroup((Composite)this, (String)CoreMessages.controls_client_homes_panel_group_information, (int)2, (int)770, (int)0);
        ((GridData)infoGroup.getLayoutData()).minimumWidth = 300;
        this.idText = UIUtils.createLabelText((Composite)infoGroup, (String)CoreMessages.controls_client_homes_panel_label_id, null, (int)2056);
        this.pathText = UIUtils.createLabelText((Composite)infoGroup, (String)CoreMessages.controls_client_homes_panel_label_path, null, (int)2056);
        this.nameText = UIUtils.createLabelText((Composite)infoGroup, (String)CoreMessages.controls_client_homes_panel_label_name, null, (int)2056);
        this.productNameText = UIUtils.createLabelText((Composite)infoGroup, (String)CoreMessages.controls_client_homes_panel_label_product_name, null, (int)2056);
        this.productVersionText = UIUtils.createLabelText((Composite)infoGroup, (String)CoreMessages.controls_client_homes_panel_label_product_version, null, (int)2056);
    }

    private void removeClientHome() {
        int selIndex = this.homesTable.getSelectionIndex();
        HomeInfo info = (HomeInfo)this.homesTable.getItem(selIndex).getData();
        if (!info.isProvided && UIUtils.confirmAction((Shell)this.getShell(), (String)CoreMessages.controls_client_homes_panel_confirm_remove_home_title, (String)NLS.bind((String)CoreMessages.controls_client_homes_panel_confirm_remove_home_text, (Object)info.location.getName()))) {
            this.homesTable.remove(selIndex);
            this.selectHome(null);
        }
    }

    private void addClientHome() {
        String homeId;
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        if (lastHomeDirectory != null) {
            directoryDialog.setFilterPath(lastHomeDirectory);
        }
        if ((homeId = directoryDialog.open()) == null) {
            return;
        }
        lastHomeDirectory = homeId;
        DBPNativeClientLocationManager clientManager = this.driver.getNativeClientManager();
        if (clientManager != null) {
            this.createHomeItem(clientManager, new LocalNativeClientLocation(homeId, homeId), false);
        }
    }

    private void selectHome(HomeInfo home) {
        this.removeButton.setEnabled(home != null && !home.isProvided);
        this.idText.setText(home == null ? "" : CommonUtils.notEmpty((String)home.location.getName()));
        this.pathText.setText(home == null ? "" : home.location.getPath().getAbsolutePath());
        this.nameText.setText(home == null ? "" : CommonUtils.notEmpty((String)home.location.getDisplayName()));
        if (home != null && !home.isValidated) {
            try {
                UIUtils.runInProgressDialog(monitor -> {
                    try {
                        homeInfo.location.validateFilesPresence(monitor);
                        homeInfo.isValidated = true;
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                DBUserInterface.getInstance().showError("Client download", "Failed to download client files", e.getTargetException());
            }
        }
        try {
            this.productNameText.setText(home == null ? "" : CommonUtils.notEmpty((String)this.driver.getNativeClientManager().getProductName(home.location)));
        }
        catch (DBException e) {
            log.warn((Object)e);
        }
        try {
            this.productVersionText.setText(home == null ? "" : CommonUtils.notEmpty((String)this.driver.getNativeClientManager().getProductVersion(home.location)));
        }
        catch (DBException e) {
            log.warn((Object)e);
        }
    }

    public Collection<DBPNativeClientLocation> getLocalLocations() {
        ArrayList<DBPNativeClientLocation> homes = new ArrayList<DBPNativeClientLocation>();
        TableItem[] tableItemArray = this.homesTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            HomeInfo homeInfo = (HomeInfo)item.getData();
            if (!homeInfo.isProvided) {
                homes.add(homeInfo.location);
            }
            ++n2;
        }
        return homes;
    }

    public void loadHomes(DBPDriver driver) {
        this.homesTable.removeAll();
        this.selectHome(null);
        this.driver = driver;
        DBPNativeClientLocationManager clientManager = this.driver.getNativeClientManager();
        if (clientManager == null) {
            log.debug((Object)("Client manager is not supported by driver '" + driver.getName() + "'"));
        }
        LinkedHashSet providedHomes = new LinkedHashSet();
        if (clientManager != null) {
            providedHomes.addAll(clientManager.findLocalClientLocations());
        }
        LinkedHashSet allHomes = new LinkedHashSet();
        allHomes.addAll(driver.getNativeClientLocations());
        allHomes.addAll(providedHomes);
        Iterator iterator = allHomes.iterator();
        while (iterator.hasNext()) {
            DBPNativeClientLocation home;
            TableItem item = this.createHomeItem(clientManager, home, (home = (DBPNativeClientLocation)iterator.next()) instanceof RemoteNativeClientLocation || providedHomes.contains(home));
            if (item == null) continue;
            HomeInfo homeInfo = (HomeInfo)item.getData();
            if (!homeInfo.isDefault) continue;
            this.homesTable.setSelection(this.homesTable.indexOf(item));
            this.selectHome(homeInfo);
        }
    }

    private TableItem createHomeItem(@NotNull DBPNativeClientLocationManager clientManager, @NotNull DBPNativeClientLocation clientLocation, boolean provided) {
        List driverLocations;
        DBPNativeClientLocation defaultLocalClientLocation = clientManager.getDefaultLocalClientLocation();
        if (defaultLocalClientLocation == null && !CommonUtils.isEmpty((Collection)(driverLocations = this.driver.getNativeClientLocations()))) {
            defaultLocalClientLocation = (DBPNativeClientLocation)driverLocations.get(0);
        }
        HomeInfo homeInfo = new HomeInfo(clientLocation);
        homeInfo.isProvided = provided;
        homeInfo.isDefault = defaultLocalClientLocation != null && clientLocation.getName().equals(defaultLocalClientLocation.getName());
        TableItem homeItem = new TableItem(this.homesTable, 0);
        homeItem.setText(clientLocation.getDisplayName());
        homeItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.HOME));
        homeItem.setData((Object)homeInfo);
        if (!homeInfo.isProvided) {
            homeItem.setFont(this.fontItalic);
        } else if (homeInfo.isDefault) {
            homeItem.setFont(this.fontBold);
        }
        return homeItem;
    }

    private String getSelectedHome() {
        Object[] selection = this.homesTable.getSelection();
        if (ArrayUtils.isEmpty((Object[])selection)) {
            return null;
        }
        return ((HomeInfo)selection[0].getData()).location.getName();
    }

    static String chooseClientHome(Shell parent, DBPDriver driver) {
        ChooserDialog dialog = new ChooserDialog(parent, driver);
        if (dialog.open() == 0) {
            return dialog.selectedHome;
        }
        return null;
    }

    private static class ChooserDialog
    extends Dialog {
        private DBPDriver driver;
        private ClientHomesPanel panel;
        private String selectedHome;

        ChooserDialog(Shell parentShell, DBPDriver driver) {
            super(parentShell);
            this.driver = driver;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(CoreMessages.controls_client_homes_panel_dialog_title);
            this.panel = new ClientHomesPanel(parent, 0);
            GridData gd = new GridData(1808);
            this.panel.setLayoutData(gd);
            this.panel.loadHomes(this.driver);
            return parent;
        }

        protected boolean isResizable() {
            return true;
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                this.selectedHome = this.panel.getSelectedHome();
                if (this.driver instanceof DriverDescriptor) {
                    ((DriverDescriptor)this.driver).setNativeClientLocations(this.panel.getLocalLocations());
                    ((DriverDescriptor)this.driver).getProviderDescriptor().getRegistry().saveDrivers();
                }
            }
            super.buttonPressed(buttonId);
        }
    }

    static class HomeInfo {
        DBPNativeClientLocation location;
        boolean isProvided;
        boolean isDefault;
        public boolean isValidated;

        HomeInfo(DBPNativeClientLocation location) {
            this.location = location;
        }
    }
}

