/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.autorefresh;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.controls.autorefresh.AutoRefreshControl;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class AutoRefreshJob
extends AbstractJob {
    private final AutoRefreshControl refreshControl;

    AutoRefreshJob(AutoRefreshControl refreshControl) {
        super("Auto-refresh job (" + refreshControl.getControlId() + ")");
        this.setSystem(true);
        this.setUser(false);
        this.refreshControl = refreshControl;
    }

    protected IStatus run(DBRProgressMonitor monitor) {
        if (!monitor.isCanceled() && this.refreshControl.isAutoRefreshEnabled()) {
            try {
                this.refreshControl.getRunnable().run(monitor);
            }
            catch (InvocationTargetException e) {
                return GeneralUtils.makeErrorStatus((String)"Auto-refresh error", (Throwable)e.getTargetException());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return Status.OK_STATUS;
    }
}

