/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.sql.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDEEncoding;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.eval.ScriptVariablesResolver;
import org.jkiss.dbeaver.runtime.sql.SQLControlCommandHandler;
import org.jkiss.dbeaver.runtime.sql.SQLQueryListener;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.OpenHandler;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class SQLCommandInclude
implements SQLControlCommandHandler {
    public static String getResourceEncoding() {
        String resourceEncoding = IDEEncoding.getResourceEncoding();
        return CommonUtils.isEmpty((String)resourceEncoding) ? GeneralUtils.getDefaultFileEncoding() : resourceEncoding;
    }

    @Override
    public boolean handleCommand(SQLControlCommand command, final SQLScriptContext scriptContext) throws DBException {
        String fileContents;
        File incFile;
        String fileName = command.getParameter();
        if (CommonUtils.isEmpty((String)fileName)) {
            throw new DBException("Empty input file");
        }
        fileName = GeneralUtils.replaceVariables((String)fileName, (GeneralUtils.IVariableResolver)new ScriptVariablesResolver(scriptContext)).trim();
        fileName = DBUtils.getUnQuotedIdentifier((DBPDataSource)scriptContext.getExecutionContext().getDataSource(), (String)fileName);
        File curFile = scriptContext.getSourceFile();
        File file = incFile = curFile == null ? new File(fileName) : new File(curFile.getParent(), fileName);
        if (!incFile.exists()) {
            incFile = new File(fileName);
        }
        if (!incFile.exists()) {
            throw new DBException("File '" + fileName + "' not found");
        }
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try (FileInputStream is = new FileInputStream(incFile);){
                InputStreamReader reader = new InputStreamReader((InputStream)is, SQLCommandInclude.getResourceEncoding());
                fileContents = IOUtils.readToString((Reader)reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DBException("IO error reading file '" + fileName + "'", (Throwable)e);
        }
        final File finalIncFile = incFile;
        final boolean[] statusFlag = new boolean[1];
        UIUtils.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
                IncludeEditorInput input = new IncludeEditorInput(finalIncFile, fileContents);
                SQLEditor sqlEditor = OpenHandler.openSQLConsole(workbenchWindow, scriptContext.getExecutionContext().getDataSource().getContainer(), input);
                IncludeScriptListener scriptListener = new IncludeScriptListener(workbenchWindow, sqlEditor, statusFlag);
                sqlEditor.processSQL(false, true, null, scriptListener);
            }
        });
        while (!statusFlag[0]) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return true;
    }

    private static class IncludeEditorInput
    extends StringEditorInput
    implements IURIEditorInput {
        private final File incFile;

        IncludeEditorInput(File incFile, CharSequence value) {
            super(incFile.getName(), value, true, "UTF-8");
            this.incFile = incFile;
        }

        public URI getURI() {
            return this.incFile.toURI();
        }
    }

    private static class IncludeScriptListener
    implements SQLQueryListener {
        private final IWorkbenchWindow workbenchWindow;
        private final SQLEditor editor;
        private final boolean[] statusFlag;

        IncludeScriptListener(IWorkbenchWindow workbenchWindow, SQLEditor editor, boolean[] statusFlag) {
            this.workbenchWindow = workbenchWindow;
            this.editor = editor;
            this.statusFlag = statusFlag;
        }

        @Override
        public void onStartScript() {
        }

        @Override
        public void onStartQuery(DBCSession session, SQLQuery query) {
        }

        @Override
        public void onEndQuery(DBCSession session, SQLQueryResult result) {
        }

        @Override
        public void onEndScript(DBCStatistics statistics, boolean hasErrors) {
            UIUtils.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    workbenchWindow.getActivePage().closeEditor((IEditorPart)editor, false);
                }
            });
            this.statusFlag[0] = true;
        }
    }
}

