/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.text.NumberFormat;
import java.util.Base64;
import org.eclipse.swt.program.Program;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.access.DBAAuthInfo;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class WebUtils {
    private static final Log log = Log.getLog(WebUtils.class);
    private static final int MAX_RETRY_COUNT = 10;

    @NotNull
    public static URLConnection openConnection(String urlString, String referrer) throws IOException {
        return WebUtils.openConnection(urlString, null, referrer);
    }

    @NotNull
    public static URLConnection openConnection(String urlString, DBAAuthInfo authInfo, String referrer) throws IOException {
        return WebUtils.openURLConnection(urlString, authInfo, referrer, 1);
    }

    @NotNull
    private static URLConnection openURLConnection(String urlString, DBAAuthInfo authInfo, String referrer, int retryNumber) throws IOException {
        int responseCode;
        HttpURLConnection httpConnection;
        if (retryNumber > 10) {
            throw new IOException("Too many redirects (" + retryNumber + ")");
        }
        if (retryNumber > 1) {
            log.debug((Object)("Retry number " + retryNumber));
        }
        log.debug((Object)("Open [" + urlString + "]"));
        DBPPreferenceStore prefs = DBeaverCore.getGlobalPreferenceStore();
        String proxyHost = prefs.getString("ui.proxy.host");
        Proxy proxy = null;
        if (!CommonUtils.isEmpty((String)proxyHost)) {
            int proxyPort = prefs.getInt("ui.proxy.port");
            if (proxyPort <= 0) {
                log.warn((Object)("Invalid proxy port: " + proxyPort));
            }
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
        }
        URL url = new URL(urlString);
        URLConnection connection = proxy == null ? url.openConnection() : url.openConnection(proxy);
        connection.setReadTimeout(10000);
        connection.setConnectTimeout(10000);
        if (connection instanceof HttpURLConnection) {
            httpConnection = (HttpURLConnection)connection;
            httpConnection.setRequestMethod("GET");
            httpConnection.setInstanceFollowRedirects(true);
            HttpURLConnection.setFollowRedirects(true);
            connection.setRequestProperty("User-Agent", GeneralUtils.getProductTitle());
            if (referrer != null) {
                connection.setRequestProperty("X-Referrer", referrer);
            }
            if (authInfo != null && !CommonUtils.isEmpty((String)authInfo.getUserName())) {
                String encoded = Base64.getEncoder().encodeToString((String.valueOf(authInfo.getUserName()) + ":" + CommonUtils.notEmpty((String)authInfo.getUserPassword())).getBytes(GeneralUtils.UTF8_CHARSET));
                connection.setRequestProperty("Authorization", "Basic " + encoded);
            }
        }
        connection.connect();
        if (connection instanceof HttpURLConnection && (responseCode = (httpConnection = (HttpURLConnection)connection).getResponseCode()) != 200) {
            if (responseCode == 302 || responseCode == 301 || responseCode == 303) {
                String newUrl = connection.getHeaderField("Location");
                return WebUtils.openURLConnection(newUrl, authInfo, referrer, retryNumber + 1);
            }
            throw new IOException("Can't open '" + urlString + "': " + httpConnection.getResponseMessage());
        }
        return connection;
    }

    public static void openWebBrowser(String url) {
        if (!((url = url.trim()).startsWith("http://") || url.startsWith("https://") || url.startsWith("ftp://"))) {
            url = "http://" + url;
        }
        Program.launch((String)url);
    }

    public static void downloadRemoteFile(@NotNull DBRProgressMonitor monitor, String taskName, String externalURL, File localFile, DBAAuthInfo authInfo) throws IOException, InterruptedException {
        int bufferLength;
        URLConnection connection = WebUtils.openConnection(externalURL, authInfo, null);
        int contentLength = connection.getContentLength();
        if (contentLength < 0) {
            contentLength = 0;
        }
        if ((bufferLength = contentLength / 10) > 1000000) {
            bufferLength = 1000000;
        }
        if (bufferLength < 50000) {
            bufferLength = 50000;
        }
        monitor.beginTask(String.valueOf(taskName) + " - " + externalURL, contentLength);
        boolean success = false;
        try {
            Throwable throwable = null;
            Object var10_11 = null;
            try (FileOutputStream outputStream = new FileOutputStream(localFile);){
                Throwable throwable2 = null;
                Object var13_16 = null;
                try (InputStream inputStream = connection.getInputStream();){
                    NumberFormat numberFormat = NumberFormat.getNumberInstance();
                    byte[] buffer = new byte[bufferLength];
                    int totalRead = 0;
                    while (true) {
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        int count = inputStream.read(buffer);
                        if (count <= 0) {
                            success = true;
                            break;
                        }
                        ((OutputStream)outputStream).write(buffer, 0, count);
                        monitor.worked(count);
                        totalRead += count;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            if (!success && !localFile.delete()) {
                log.warn((Object)("Can't delete local file '" + localFile.getAbsolutePath() + "'"));
            }
            monitor.done();
        }
    }
}

