/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractSearchPage
extends DialogPage
implements ISearchPage {
    protected static final Log log = Log.getLog(AbstractSearchPage.class);
    protected ISearchPageContainer container;

    protected AbstractSearchPage(String title) {
        super(title);
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateEnablement();
        }
    }

    protected abstract void updateEnablement();

    protected abstract ISearchQuery createQuery() throws DBException;

    protected abstract void loadState(DBPPreferenceStore var1);

    protected abstract void saveState(DBPPreferenceStore var1);

    public void createControl(Composite parent) {
        this.loadState(DBeaverCore.getGlobalPreferenceStore());
    }

    public boolean performAction() {
        try {
            this.saveState(DBeaverCore.getGlobalPreferenceStore());
            NewSearchUI.runQueryInBackground((ISearchQuery)this.createQuery());
        }
        catch (DBException e) {
            DBUserInterface.getInstance().showError("Search error", "Can't perform search", (Throwable)e);
            return false;
        }
        return true;
    }

    protected List<DBNNode> loadTreeState(DBRProgressMonitor monitor, String sources) {
        ArrayList<DBNNode> result = new ArrayList<DBNNode>();
        if (!CommonUtils.isEmpty((String)sources)) {
            HashSet<DBNDataSource> brokenDataSources = new HashSet<DBNDataSource>();
            StringTokenizer st = new StringTokenizer(sources, "|");
            while (st.hasMoreTokens()) {
                String nodePath = st.nextToken();
                try {
                    DBNDataSource dsNode = DBeaverCore.getInstance().getNavigatorModel().getDataSourceByPath(nodePath);
                    if (dsNode == null || brokenDataSources.contains(dsNode)) continue;
                    DBNNode node = DBeaverCore.getInstance().getNavigatorModel().getNodeByPath(monitor, dsNode.getOwnerProject(), nodePath);
                    if (node != null) {
                        result.add(node);
                        continue;
                    }
                    brokenDataSources.add(dsNode);
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
            }
        }
        return result;
    }
}

