/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.templates;

import java.util.HashSet;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLContextTypeBase;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLContextTypeDriver;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLContextTypeProvider;
import org.jkiss.utils.CommonUtils;

public class SQLContextTypeRegistry
extends ContextTypeRegistry {
    public SQLContextTypeRegistry() {
        this.loadContextTypes();
    }

    private void loadContextTypes() {
        this.addContextType(new SQLContextTypeBase());
        for (DataSourceProviderDescriptor provider : DataSourceProviderRegistry.getInstance().getDataSourceProviders()) {
            if (!provider.isDriversManagable()) {
                SQLContextTypeProvider contextType = new SQLContextTypeProvider(provider);
                this.addContextType(contextType);
                provider.loadTemplateVariableResolvers(contextType);
                continue;
            }
            HashSet<String> categoriesAdded = new HashSet<String>();
            for (DriverDescriptor driver : provider.getEnabledDrivers()) {
                if (!CommonUtils.isEmpty((String)driver.getCategory())) {
                    if (categoriesAdded.contains(driver.getCategory())) continue;
                    categoriesAdded.add(driver.getCategory());
                }
                SQLContextTypeDriver contextType = new SQLContextTypeDriver(driver);
                this.addContextType(contextType);
                provider.loadTemplateVariableResolvers(contextType);
            }
        }
    }
}

