/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.Collection;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.ui.TextUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCompletionAnalyzer;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLContextInformer;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLWordPartDetector;
import org.jkiss.utils.CommonUtils;

public class SQLCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalExtension4,
ICompletionProposalExtension5 {
    private static final Log log = Log.getLog(SQLCompletionProposal.class);
    private final DBPDataSource dataSource;
    private SQLSyntaxManager syntaxManager;
    private String displayString;
    private String replacementString;
    private String replacementFull;
    private String replacementLast;
    private String replacementAfter;
    private int replacementOffset;
    private int replacementLength;
    private int cursorPosition;
    private Image image;
    private IContextInformation contextInformation;
    private DBPKeywordType proposalType;
    private String additionalProposalInfo;
    private boolean simpleMode;
    private DBPNamedObject object;
    private int proposalScore;

    public SQLCompletionProposal(SQLCompletionAnalyzer.CompletionRequest request, String displayString, String replacementString, int cursorPosition, @Nullable Image image, IContextInformation contextInformation, DBPKeywordType proposalType, String description, DBPNamedObject object) {
        this.dataSource = request.editor.getDataSource();
        this.syntaxManager = request.editor.getSyntaxManager();
        this.displayString = displayString;
        this.replacementString = replacementString;
        this.replacementFull = this.dataSource == null ? replacementString : DBUtils.getUnQuotedIdentifier((DBPDataSource)this.dataSource, (String)replacementString.toLowerCase(Locale.ENGLISH));
        int divPos = this.replacementFull.lastIndexOf(this.syntaxManager.getStructSeparator());
        this.replacementLast = divPos == -1 ? null : this.replacementFull.substring(divPos + 1);
        this.cursorPosition = cursorPosition;
        this.image = image;
        this.contextInformation = contextInformation;
        this.proposalType = proposalType;
        this.additionalProposalInfo = description;
        this.setPosition(request.wordDetector);
        this.object = object;
        this.simpleMode = request.simpleMode;
    }

    public DBPNamedObject getObject() {
        return this.object;
    }

    private void setPosition(SQLWordPartDetector wordDetector) {
        boolean useFQName;
        String fullWord = wordDetector.getFullWord();
        int curOffset = wordDetector.getCursorOffset() - wordDetector.getStartOffset();
        char structSeparator = this.syntaxManager.getStructSeparator();
        boolean bl = useFQName = this.dataSource != null && this.dataSource.getContainer().getPreferenceStore().getBoolean("SQLEditor.ContentAssistant.proposals.long.name") && this.replacementString.indexOf(structSeparator) != -1;
        if (useFQName) {
            this.replacementOffset = wordDetector.getStartOffset();
            this.replacementLength = wordDetector.getLength();
        } else if (!fullWord.equals(this.replacementString) && !this.replacementString.contains(String.valueOf(structSeparator))) {
            boolean replaceWord;
            int startOffset = fullWord.lastIndexOf(structSeparator, curOffset - 1);
            startOffset = startOffset == -1 ? 0 : (startOffset > curOffset ? ((startOffset = fullWord.lastIndexOf(structSeparator, curOffset)) == -1 ? curOffset : ++startOffset) : ++startOffset);
            int endOffset = fullWord.indexOf(structSeparator, curOffset);
            endOffset = endOffset != -1 ? fullWord.length() - endOffset : 0;
            this.replacementOffset = wordDetector.getStartOffset() + startOffset;
            boolean bl2 = replaceWord = this.dataSource != null && this.dataSource.getContainer().getPreferenceStore().getBoolean("SQLEditor.ContentAssistant.replace.word");
            this.replacementLength = replaceWord ? wordDetector.getEndOffset() - this.replacementOffset - endOffset : curOffset - startOffset;
        } else {
            int startOffset = fullWord.indexOf(structSeparator);
            int endOffset = fullWord.indexOf(structSeparator, curOffset);
            if (endOffset == startOffset) {
                startOffset = -1;
            }
            startOffset = startOffset != -1 ? (startOffset += wordDetector.getStartOffset() + 1) : wordDetector.getStartOffset();
            endOffset = endOffset != -1 ? (endOffset += wordDetector.getStartOffset()) : (wordDetector.getWordPart().isEmpty() ? wordDetector.getCursorOffset() : wordDetector.getEndOffset());
            this.replacementOffset = startOffset;
            this.replacementLength = endOffset - startOffset;
        }
    }

    public void apply(IDocument document) {
        try {
            String replaceOn = this.replacementString;
            String extraString = this.getExtraString();
            if (extraString != null) {
                replaceOn = String.valueOf(replaceOn) + extraString;
            }
            if (this.replacementAfter != null) {
                replaceOn = String.valueOf(replaceOn) + this.replacementAfter;
            }
            if (this.dataSource != null && this.dataSource.getContainer().getPreferenceStore().getBoolean("SQLEditor.ContentAssistant.insert.space.after.proposal") && !(this.object instanceof DBSObjectContainer)) {
                boolean insertTrailingSpace;
                int docLen = document.getLength();
                if (docLen <= this.replacementOffset + this.replacementLength + 2) {
                    insertTrailingSpace = true;
                } else {
                    boolean bl = insertTrailingSpace = document.getChar(this.replacementOffset + this.replacementLength) != ' ';
                }
                if (insertTrailingSpace) {
                    replaceOn = String.valueOf(replaceOn) + " ";
                }
                ++this.cursorPosition;
            }
            document.replace(this.replacementOffset, this.replacementLength, replaceOn);
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
        }
    }

    private String getExtraString() {
        try {
            VoidProgressMonitor monitor = new VoidProgressMonitor();
            if (this.object instanceof DBSObjectReference && DBSProcedure.class.isAssignableFrom(((DBSObjectReference)this.object).getObjectType().getTypeClass())) {
                this.object = ((DBSObjectReference)this.object).resolveObject((DBRProgressMonitor)monitor);
            }
            if (this.object instanceof DBSProcedure) {
                Collection parameters = ((DBSProcedure)this.object).getParameters((DBRProgressMonitor)monitor);
                if (!CommonUtils.isEmpty((Collection)parameters)) {
                    StringBuilder params = new StringBuilder();
                    for (DBSProcedureParameter param : parameters) {
                        if (!param.getParameterKind().isInput()) continue;
                        if (params.length() > 0) {
                            params.append(", ");
                        }
                        params.append(":").append(param.getName());
                    }
                    return "(" + params.toString() + ")";
                }
                return "()";
            }
            return null;
        }
        catch (DBException e) {
            log.error((Object)"Error resolving procedure parameters", (Throwable)e);
            return null;
        }
    }

    public Point getSelection(IDocument document) {
        int newOffset = this.replacementOffset + this.cursorPosition + (this.replacementAfter == null ? 0 : this.replacementAfter.length());
        if (newOffset > document.getLength()) {
            newOffset = document.getLength();
        }
        return new Point(newOffset, 0);
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        if (this.additionalProposalInfo == null) {
            this.additionalProposalInfo = SQLContextInformer.readAdditionalProposalInfo((DBRProgressMonitor)new DefaultProgressMonitor(monitor), this.dataSource, this.object, new String[]{this.displayString}, this.proposalType);
        }
        return this.additionalProposalInfo;
    }

    public String getAdditionalProposalInfo() {
        return CommonUtils.toString((Object)this.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor()));
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public Image getImage() {
        return this.image;
    }

    public IContextInformation getContextInformation() {
        return this.contextInformation;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.apply(viewer.getDocument());
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (event == null) {
            return false;
        }
        SQLWordPartDetector wordDetector = new SQLWordPartDetector(document, this.syntaxManager, offset);
        String wordPart = wordDetector.getWordPart();
        int divPos = wordPart.lastIndexOf(this.syntaxManager.getStructSeparator());
        if (divPos != -1) {
            if (divPos == wordPart.length() - 1) {
                if (this.replacementString.equals(wordPart.substring(0, divPos))) {
                    UIUtils.asyncExec(() -> {
                        ITextViewer textViewer;
                        IEditorPart activeEditor = UIUtils.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                        if (activeEditor != null && (textViewer = (ITextViewer)activeEditor.getAdapter(ITextViewer.class)) != null) {
                            textViewer.getTextOperationTarget().doOperation(13);
                        }
                    });
                }
                return false;
            }
            wordPart = wordPart.substring(divPos + 1);
        }
        String wordLower = wordPart.toLowerCase(Locale.ENGLISH);
        if (!CommonUtils.isEmpty((String)wordPart)) {
            boolean matched;
            boolean matchContains;
            boolean bl = matchContains = this.dataSource != null && this.dataSource.getContainer().getPreferenceStore().getBoolean("SQLEditor.ContentAssistant.matching.fuzzy");
            if (this.object == null) {
                matched = (matchContains ? this.replacementFull.contains(wordLower) : this.replacementFull.startsWith(wordLower)) && (CommonUtils.isEmpty((String)event.getText()) || this.replacementFull.contains(event.getText().toLowerCase(Locale.ENGLISH))) || this.replacementLast != null && this.replacementLast.startsWith(wordLower);
            } else {
                int score = TextUtils.fuzzyScore((CharSequence)this.replacementFull, (CharSequence)wordLower);
                boolean bl2 = matched = score > 0 && (CommonUtils.isEmpty((String)event.getText()) || TextUtils.fuzzyScore((CharSequence)this.replacementFull, (CharSequence)event.getText()) > 0) || this.replacementLast != null && TextUtils.fuzzyScore((CharSequence)this.replacementLast, (CharSequence)wordLower) > 0;
                if (matched) {
                    this.setProposalScore(score);
                }
            }
            if (matched) {
                this.setPosition(wordDetector);
                return true;
            }
        } else if (divPos != -1 && this.object != null) {
            return true;
        }
        return false;
    }

    public boolean hasStructObject() {
        return this.object instanceof DBSObject || this.object instanceof DBSObjectReference;
    }

    public DBSObject getObjectContainer() {
        if (this.object instanceof DBSObject) {
            return ((DBSObject)this.object).getParentObject();
        }
        if (this.object instanceof DBSObjectReference) {
            return ((DBSObjectReference)this.object).getContainer();
        }
        return null;
    }

    public void setReplacementAfter(String replacementAfter) {
        this.replacementAfter = replacementAfter;
    }

    public int getProposalScore() {
        return this.proposalScore;
    }

    public void setProposalScore(int proposalScore) {
        this.proposalScore = proposalScore;
    }

    public String toString() {
        return this.displayString;
    }

    public boolean isAutoInsertable() {
        return true;
    }
}

