/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class RenameHandler
extends AbstractDataSourceHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = (IEditorPart)RuntimeUtils.getObjectAdapter((Object)HandlerUtil.getActivePart((ExecutionEvent)event), IEditorPart.class);
        if (editor == null) {
            log.error((Object)"No active SQL editor");
            return null;
        }
        IFile file = EditorUtils.getFileFromInput(editor.getEditorInput());
        if (file == null) {
            DBUserInterface.getInstance().showError("Rename", "Can't rename - no source file");
            return null;
        }
        RenameHandler.renameFile((IWorkbenchPart)editor, file, "SQL script");
        return null;
    }

    public static void renameFile(IWorkbenchPart editor, IFile file, String fileTitle) {
        int divPos;
        Shell shell = editor.getSite().getShell();
        String newName = EnterNameDialog.chooseName((Shell)shell, (String)("Rename " + fileTitle + " [" + file.getName() + "]"), (String)file.getName());
        if (newName == null) {
            return;
        }
        if (newName.indexOf(46) == -1 && (divPos = file.getName().lastIndexOf(46)) != -1) {
            newName = String.valueOf(newName) + file.getName().substring(divPos);
        }
        if (!newName.equals(file.getName())) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (editor instanceof IEditorPart) {
                ((IEditorPart)editor).doSave((IProgressMonitor)monitor);
            }
            try {
                file.move(file.getParent().getFullPath().append(newName), true, (IProgressMonitor)monitor);
            }
            catch (CoreException e) {
                DBUserInterface.getInstance().showError("Rename", "Error renaming file '" + file.getName() + "'", (Throwable)e);
            }
        }
    }
}

