/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;

public class DatabaseEditorUtils {
    public static void setPartBackground(IEditorPart editor, Composite composite) {
        DBCExecutionContext context;
        if (composite == null || composite.isDisposed()) {
            return;
        }
        CTabFolder tabFolder = null;
        Composite rootComposite = composite;
        Composite c = composite;
        while (c != null) {
            if (!c.isDisposed() && c.getParent() instanceof CTabFolder) {
                tabFolder = (CTabFolder)c.getParent();
                break;
            }
            c = c.getParent();
        }
        if (tabFolder != null) {
            tabFolder.setBorderVisible(false);
        }
        Color bgColor = null;
        if (editor instanceof IDataSourceContainerProvider) {
            DBPDataSourceContainer container = ((IDataSourceContainerProvider)editor).getDataSourceContainer();
            if (container != null) {
                bgColor = UIUtils.getConnectionColor((DBPConnectionConfiguration)container.getConnectionConfiguration());
            }
        } else if (editor instanceof DBPContextProvider && (context = ((DBPContextProvider)editor).getExecutionContext()) != null) {
            bgColor = UIUtils.getConnectionColor((DBPConnectionConfiguration)context.getDataSource().getContainer().getConnectionConfiguration());
        }
        if (bgColor == null) {
            rootComposite.setBackground(null);
        } else {
            rootComposite.setBackground(bgColor);
        }
    }

    public static void contributeStandardEditorActions(IWorkbenchSite workbenchSite, IContributionManager contributionManager) {
        contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.eclipse.ui.file.save", null, (DBPImage)UIIcon.SAVE, null, (boolean)true));
        contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.eclipse.ui.file.revert", null, (DBPImage)UIIcon.RESET, null, (boolean)true));
    }
}

