/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.data;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.editors.ReferenceValueEditor;
import org.jkiss.dbeaver.ui.dialogs.data.ValueViewDialog;

public class DefaultValueViewDialog
extends ValueViewDialog {
    private static final Log log = Log.getLog(DefaultValueViewDialog.class);
    private IValueEditor panelEditor;

    public DefaultValueViewDialog(IValueController valueController) {
        super(valueController);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite dialogGroup = (Composite)super.createDialogArea(parent);
        Label label = new Label(dialogGroup, 0);
        label.setText(CoreMessages.dialog_data_label_value);
        Composite editorPlaceholder = UIUtils.createPlaceholder((Composite)dialogGroup, (int)1);
        GridData gd = new GridData(1808);
        gd.minimumHeight = label.computeSize((int)-1, (int)-1).y + 4;
        editorPlaceholder.setLayoutData((Object)gd);
        editorPlaceholder.setLayout((Layout)new FillLayout());
        try {
            this.panelEditor = this.createPanelEditor(editorPlaceholder);
            if (this.panelEditor == null) {
                return dialogGroup;
            }
            this.panelEditor.primeEditorValue(this.getValueController().getValue());
        }
        catch (DBException e) {
            log.error((Object)e);
            return dialogGroup;
        }
        ReferenceValueEditor referenceValueEditor = new ReferenceValueEditor(this.getValueController(), this);
        if (referenceValueEditor.isReferenceValue()) {
            referenceValueEditor.createEditorSelector(dialogGroup);
        }
        return dialogGroup;
    }

    @Override
    public Object extractEditorValue() throws DBException {
        return this.panelEditor.extractEditorValue();
    }

    @Override
    public void primeEditorValue(@Nullable Object value) throws DBException {
        this.panelEditor.primeEditorValue(value);
    }

    @Override
    public boolean isDirty() {
        return this.panelEditor.isDirty();
    }

    @Override
    public void setDirty(boolean dirty) {
        this.panelEditor.setDirty(dirty);
    }

    @Override
    public Control getControl() {
        return this.panelEditor == null ? null : this.panelEditor.getControl();
    }
}

