/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.txn;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.txn.TransactionInfoDialog;

public class TransactionLogDialog
extends TransactionInfoDialog {
    private static final String DIALOG_ID = "DBeaver.TransactionLogDialog";
    private final DBCExecutionContext context;
    private final boolean showPreviousTxn;

    public TransactionLogDialog(Shell parentShell, DBCExecutionContext context, IWorkbenchPart activeEditor, boolean showPreviousTxn) {
        super(parentShell, activeEditor);
        this.context = context;
        this.showPreviousTxn = showPreviousTxn;
    }

    @Override
    protected boolean isResizable() {
        return true;
    }

    @Override
    protected DBCExecutionContext getCurrentContext() {
        return this.context;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Transaction log [" + this.context.getDataSource().getContainer().getName() + " : " + this.context.getContextName() + "]");
        Composite composite = (Composite)super.createDialogArea(parent);
        super.createTransactionLogPanel(composite);
        this.showPreviousCheck.setSelection(this.showPreviousTxn);
        this.updateTransactionFilter();
        return parent;
    }

    public static void showDialog(Shell shell, DBCExecutionContext executionContext) {
        TransactionLogDialog.showDialog(shell, executionContext, false);
    }

    public static void showDialog(Shell shell, DBCExecutionContext executionContext, boolean showPreviousTxn) {
        IEditorPart activeEditor = UIUtils.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor == null) {
            DBUserInterface.getInstance().showError("No editor", "Transaction log is not available.\nOpen database editor.");
        } else if (executionContext == null) {
            DBUserInterface.getInstance().showError("Not connected", "Transaction log is not available.\nConnect to a database.");
        } else {
            TransactionLogDialog dialog = new TransactionLogDialog(shell, executionContext, (IWorkbenchPart)activeEditor, showPreviousTxn);
            dialog.open();
        }
    }
}

