/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.TextUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataReceiver;
import org.jkiss.dbeaver.ui.controls.resultset.StatusDetailsDialog;
import org.jkiss.dbeaver.utils.RuntimeUtils;

class StatusLabel
extends Composite {
    private final IResultSetController viewer;
    private final Label statusIcon;
    private final Text statusText;
    private DBPMessageType messageType;

    public StatusLabel(@NotNull Composite parent, int style, @Nullable IResultSetController viewer) {
        super(parent, 2048);
        this.viewer = viewer;
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 2;
        layout.horizontalSpacing = 3;
        this.setLayout((Layout)layout);
        Image statusImage = JFaceResources.getImage((String)"dialog_messasge_info_image");
        this.statusIcon = new Label((Composite)this, 0);
        this.statusIcon.setImage(statusImage);
        this.statusIcon.setToolTipText("Status information");
        GridData gd = new GridData(32);
        this.statusIcon.setLayoutData((Object)gd);
        this.statusText = new Text((Composite)this, 12);
        if (RuntimeUtils.isPlatformWindows()) {
            this.statusText.setBackground(null);
        } else {
            this.statusText.setBackground(parent.getBackground());
        }
        gd = new GridData(768);
        gd.minimumHeight = statusImage.getBounds().height;
        this.statusText.setLayoutData((Object)gd);
        if (viewer != null) {
            UIUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)viewer.getSite(), (Control)this.statusText);
            UIUtils.addDefaultEditActionsSupport((IServiceLocator)viewer.getSite(), (Control)this.statusText);
        }
        ToolBar tb = new ToolBar((Composite)this, 256);
        ToolItem detailsIcon = new ToolItem(tb, 0);
        detailsIcon.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.TEXTFIELD));
        tb.setLayoutData((Object)new GridData(32));
        detailsIcon.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatusLabel.this.showDetails();
            }
        });
        this.statusText.addTraverseListener(e -> {
            if (e.detail == 4) {
                this.showDetails();
            }
        });
    }

    protected void showDetails() {
        DBDDataReceiver dataReceiver = this.viewer.getDataReceiver();
        if (dataReceiver instanceof ResultSetDataReceiver) {
            StatusDetailsDialog dialog = new StatusDetailsDialog(this.viewer.getSite().getShell(), this.getMessage(), ((ResultSetDataReceiver)dataReceiver).getErrorList());
            dialog.open();
        }
    }

    public void setStatus(String message) {
        this.setStatus(message, DBPMessageType.INFORMATION);
    }

    public void setStatus(String message, DBPMessageType messageType) {
        String statusIconId;
        if (this.statusText.isDisposed()) {
            return;
        }
        this.messageType = messageType;
        switch (messageType) {
            case ERROR: {
                statusIconId = "dialog_message_error_image";
                break;
            }
            case WARNING: {
                statusIconId = "dialog_messasge_warning_image";
                break;
            }
            default: {
                statusIconId = "dialog_messasge_info_image";
            }
        }
        if (message == null) {
            message = "???";
        }
        this.statusIcon.setImage(JFaceResources.getImage((String)statusIconId));
        this.statusText.setText(TextUtils.getSingleLineString((String)message));
        if (messageType != DBPMessageType.INFORMATION) {
            this.statusText.setToolTipText(message);
        } else {
            this.statusText.setToolTipText(null);
        }
    }

    public String getMessage() {
        return this.statusText.getText();
    }

    public DBPMessageType getMessageType() {
        return this.messageType;
    }

    public void setUpdateListener(Runnable runnable) {
    }
}

