/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.itemlist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectEditor;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.INavigatorListener;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNodeHandler;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.registry.editor.EntityEditorsRegistry;
import org.jkiss.dbeaver.runtime.properties.PropertySourceAbstract;
import org.jkiss.dbeaver.runtime.properties.PropertySourceEditable;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.ObjectViewerRenderer;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.itemlist.ObjectListControl;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class NodeListControl
extends ObjectListControl<DBNNode>
implements IDataSourceContainerProvider,
INavigatorModelView,
INavigatorListener {
    private static final Log log = Log.getLog(NodeListControl.class);
    private final IWorkbenchSite workbenchSite;
    private DBNNode rootNode;
    private DBXTreeNode nodeMeta;
    private final NodeSelectionProvider selectionProvider;

    protected NodeListControl(Composite parent, int style, IWorkbenchSite workbenchSite, DBNNode rootNode, IContentProvider contentProvider) {
        super(parent, style, contentProvider);
        this.workbenchSite = workbenchSite;
        this.rootNode = rootNode;
        this.selectionProvider = new NodeSelectionProvider(super.getSelectionProvider());
        NavigatorUtils.addContextMenu(workbenchSite, (Viewer)this.getItemsViewer());
        this.setDoubleClickHandler(event -> {
            ISelection selection = this.getItemsViewer().getSelection();
            if (selection instanceof IStructuredSelection) {
                for (Object obj : ((IStructuredSelection)selection).toList()) {
                    if (!(obj instanceof DBNNode) || !((DBNNode)obj).allowsOpen()) continue;
                    this.openNodeEditor((DBNNode)obj);
                }
            }
        });
        NavigatorUtils.addDragAndDropSupport((Viewer)this.getItemsViewer());
        if (workbenchSite != null) {
            EditorUtils.trackControlContext(workbenchSite, this.getItemsViewer().getControl(), "org.jkiss.dbeaver.ui.context.navigator");
        }
        DBeaverCore.getInstance().getNavigatorModel().addListener((INavigatorListener)this);
    }

    protected void openNodeEditor(DBNNode node) {
        IWorkbenchWindow serviceLocator = this.workbenchSite != null ? this.workbenchSite : UIUtils.getActiveWorkbenchWindow();
        NavigatorUtils.executeNodeAction(DBXTreeNodeHandler.Action.open, node, (IServiceLocator)serviceLocator);
    }

    NodeListControl(Composite parent, int style, IWorkbenchSite workbenchSite, DBNNode rootNode, DBXTreeNode nodeMeta) {
        this(parent, style, workbenchSite, rootNode, NodeListControl.createContentProvider(rootNode, nodeMeta));
        this.nodeMeta = nodeMeta;
    }

    IWorkbenchSite getWorkbenchSite() {
        return this.workbenchSite;
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        if (this.rootNode instanceof DBNDatabaseNode) {
            return ((DBNDatabaseNode)this.rootNode).getDataSourceContainer();
        }
        return null;
    }

    @Override
    public void disposeControl() {
        if (this.selectionProvider != null) {
            this.selectionProvider.dispose();
        }
        DBeaverCore.getInstance().getNavigatorModel().removeListener((INavigatorListener)this);
        super.disposeControl();
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    private static IContentProvider createContentProvider(DBNNode node, DBXTreeNode metaNode) {
        if (node instanceof DBNDatabaseNode) {
            List<DBXTreeNode> inlineMetas;
            DBNDatabaseNode dbNode = (DBNDatabaseNode)node;
            if (metaNode == null) {
                metaNode = dbNode.getMeta();
            }
            if (!(inlineMetas = NodeListControl.collectInlineMetas(dbNode, metaNode)).isEmpty()) {
                return new TreeContentProvider(){

                    public boolean hasChildren(Object parentElement) {
                        return parentElement instanceof DBNDatabaseNode && ((DBNDatabaseNode)parentElement).hasChildren(false);
                    }

                    public Object[] getChildren(Object parentElement) {
                        if (parentElement instanceof DBNDatabaseNode) {
                            Object[] children;
                            block4: {
                                children = NavigatorUtils.getNodeChildrenFiltered((DBRProgressMonitor)new VoidProgressMonitor(), (DBNNode)((DBNDatabaseNode)parentElement), false);
                                if (!ArrayUtils.isEmpty((Object[])children)) break block4;
                                return null;
                            }
                            try {
                                return children;
                            }
                            catch (DBException e) {
                                log.error((Object)e);
                            }
                        }
                        return null;
                    }
                };
            }
        }
        return new ListContentProvider();
    }

    private static List<DBXTreeNode> collectInlineMetas(DBNDatabaseNode node, DBXTreeNode meta) {
        ArrayList<DBXTreeNode> inlineMetas = new ArrayList<DBXTreeNode>();
        if (meta instanceof DBXTreeFolder) {
            for (DBXTreeNode metaChild : meta.getChildren((DBNNode)node)) {
                NodeListControl.collectInlineChildren(metaChild, inlineMetas);
            }
        } else {
            NodeListControl.collectInlineChildren(meta, inlineMetas);
        }
        return inlineMetas;
    }

    private static void collectInlineChildren(DBXTreeNode meta, List<DBXTreeNode> inlineMetas) {
        List metaChildren = meta.getChildren(null);
        if (!CommonUtils.isEmpty((Collection)metaChildren)) {
            for (DBXTreeNode child : metaChildren) {
                if (!child.isInline()) continue;
                inlineMetas.add(child);
            }
        }
    }

    @Override
    @Nullable
    protected Class<?>[] getListBaseTypes(Collection<DBNNode> items) {
        if (this.getRootNode() instanceof DBNDatabaseNode) {
            Class childrenClass;
            DBNDatabaseNode dbNode = (DBNDatabaseNode)this.getRootNode();
            List baseTypes = dbNode.getChildrenTypes(this.nodeMeta);
            if (CommonUtils.isEmpty((Collection)baseTypes) && dbNode instanceof DBNDatabaseFolder && (childrenClass = ((DBNDatabaseFolder)dbNode).getChildrenClass()) != null) {
                return new Class[]{childrenClass};
            }
            return CommonUtils.isEmpty((Collection)baseTypes) ? null : baseTypes.toArray(new Class[0]);
        }
        return null;
    }

    @Override
    @Nullable
    public Viewer getNavigatorViewer() {
        return this.getItemsViewer();
    }

    @Override
    public DBNNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(DBNNode rootNode) {
        this.rootNode = rootNode;
    }

    protected DBXTreeNode getNodeMeta() {
        return this.nodeMeta;
    }

    @Override
    protected Object getObjectValue(DBNNode item) {
        return item instanceof DBSWrapper ? ((DBSWrapper)item).getObject() : item;
    }

    @Override
    protected DBPImage getObjectImage(DBNNode item) {
        return item.getNodeIconDefault();
    }

    @Override
    protected boolean isNewObject(DBNNode objectValue) {
        return !objectValue.isPersisted();
    }

    @Override
    protected boolean isReadOnlyList() {
        DBPDataSourceContainer container = this.getDataSourceContainer();
        return container != null && container.isConnectionReadOnly();
    }

    @Override
    @NotNull
    protected String getListConfigId(List<Class<?>> classList) {
        StringBuilder sb = new StringBuilder("NodeList");
        for (Class<?> theClass : classList) {
            sb.append("/").append(theClass.getSimpleName());
        }
        return sb.toString();
    }

    @Override
    protected PropertySourceAbstract createListPropertySource() {
        if (this.workbenchSite instanceof IWorkbenchPartSite && ((IWorkbenchPartSite)this.workbenchSite).getPart() instanceof IDatabaseEditor) {
            return new NodeListPropertySource(((IDatabaseEditor)((IWorkbenchPartSite)this.workbenchSite).getPart()).getEditorInput().getCommandContext());
        }
        return super.createListPropertySource();
    }

    public void nodeChanged(DBNEvent event) {
        if (this.isDisposed()) {
            return;
        }
        if (event.getNode().isChildOf(this.getRootNode())) {
            if (event.getAction() != DBNEvent.Action.UPDATE) {
                this.loadData(false);
            } else {
                this.getItemsViewer().update((Object)event.getNode(), null);
            }
        }
    }

    @Override
    protected ObjectViewerRenderer createRenderer() {
        return new NodeRenderer();
    }

    private class NodeListPropertySource
    extends PropertySourceEditable {
        private NodeListPropertySource(DBECommandContext commandContext) {
            super(commandContext, (Object)NodeListControl.this, (Object)NodeListControl.this);
        }

        public DBNNode getSourceObject() {
            return (DBNNode)NodeListControl.this.getCurrentListObject();
        }

        public Object getEditableValue() {
            return NodeListControl.this.getObjectValue((DBNNode)NodeListControl.this.getCurrentListObject());
        }

        public boolean isEditable(Object editableValue) {
            if (editableValue == null) {
                return false;
            }
            DBNNode rootNode = NodeListControl.this.getRootNode();
            if (!(rootNode instanceof DBNDatabaseNode)) {
                return false;
            }
            Class<?> curClass = editableValue.getClass();
            Object valueObject = ((DBNDatabaseNode)rootNode).getValueObject();
            if (valueObject == null) {
                return false;
            }
            DBEObjectEditor objectEditor = EntityEditorsRegistry.getInstance().getObjectManager(curClass, DBEObjectEditor.class);
            return objectEditor != null && editableValue instanceof DBPObject && objectEditor.canEditObject((DBPObject)editableValue);
        }

        public DBPPropertyDescriptor[] getPropertyDescriptors2() {
            Set<DBPPropertyDescriptor> props = NodeListControl.this.getAllProperties();
            return props.toArray(new DBPPropertyDescriptor[0]);
        }
    }

    private class NodeRenderer
    extends ObjectListControl.ViewerRenderer {
        private NodeRenderer() {
            super(NodeListControl.this);
        }

        public boolean isHyperlink(Object cellValue) {
            Object ownerObject = null;
            if (NodeListControl.this.rootNode instanceof DBNDatabaseNode) {
                ownerObject = ((DBNDatabaseNode)NodeListControl.this.rootNode).getValueObject();
            }
            return cellValue instanceof DBSObject && cellValue != ownerObject;
        }

        public void navigateHyperlink(Object cellValue) {
            if (cellValue instanceof DBSObject) {
                NavigatorHandlerObjectOpen.openEntityEditor((DBSObject)cellValue);
            }
        }
    }

    private class NodeSelectionProvider
    implements ISelectionProvider,
    ISelectionChangedListener {
        private final ISelectionProvider original;
        private final List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
        private final StructuredSelection defaultSelection;

        NodeSelectionProvider(ISelectionProvider original) {
            this.original = original;
            this.defaultSelection = new StructuredSelection((Object)NodeListControl.this.rootNode);
            this.original.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            List<ISelectionChangedListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }

        public ISelection getSelection() {
            ISelection selection = this.original.getSelection();
            if (selection == null || selection.isEmpty()) {
                return this.defaultSelection;
            }
            return selection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            List<ISelectionChangedListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }

        public void setSelection(ISelection selection) {
            if (selection == this.defaultSelection) {
                this.original.setSelection((ISelection)new StructuredSelection());
            } else {
                this.original.setSelection(selection);
            }
            this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectionChanged(SelectionChangedEvent event) {
            List<ISelectionChangedListener> list = this.listeners;
            synchronized (list) {
                event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
                for (ISelectionChangedListener listener : this.listeners) {
                    listener.selectionChanged(event);
                }
            }
        }

        void dispose() {
            this.original.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }
}

