/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.navigator;

import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.tools.ToolDescriptor;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.tools.IExternalTool;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public class NavigatorActionExecuteTool
implements IActionDelegate {
    private IWorkbenchWindow window;
    private ToolDescriptor tool;
    private ISelection selection;

    public NavigatorActionExecuteTool(IWorkbenchWindow window, ToolDescriptor tool) {
        this.window = window;
        this.tool = tool;
    }

    public void run(IAction action) {
        if (!this.selection.isEmpty()) {
            List<DBSObject> selectedObjects = NavigatorUtils.getSelectedObjects(this.selection);
            this.executeTool(UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart(), selectedObjects);
        }
    }

    private void executeTool(IWorkbenchPart part, Collection<DBSObject> objects) {
        try {
            IExternalTool toolInstance = this.tool.createTool();
            toolInstance.execute(this.window, part, objects);
        }
        catch (Throwable e) {
            DBUserInterface.getInstance().showError("Tool error", "Error executing tool '" + this.tool.getLabel() + "'", e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

