/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.views.plan;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.controls.ObjectViewerRenderer;
import org.jkiss.dbeaver.ui.controls.itemlist.DatabaseObjectListControl;
import org.jkiss.dbeaver.ui.controls.itemlist.ObjectListControl;
import org.jkiss.utils.CommonUtils;

public class PlanNodesTree
extends DatabaseObjectListControl<DBCPlanNode> {
    private DBCExecutionContext context;
    private DBCQueryPlanner planner;
    private String query;
    private static ITreeContentProvider CONTENT_PROVIDER = new ITreeContentProvider(){

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof DBCPlanNode) {
                Collection nestedNodes = ((DBCPlanNode)parentElement).getNested();
                return CommonUtils.isEmpty((Collection)nestedNodes) ? new Object[]{} : nestedNodes.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof DBCPlanNode) {
                return ((DBCPlanNode)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof DBCPlanNode && !CommonUtils.isEmpty((Collection)((DBCPlanNode)element).getNested());
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };

    public PlanNodesTree(Composite parent, int style, IWorkbenchSite site) {
        super(parent, style, site, (IContentProvider)CONTENT_PROVIDER);
        this.setFitWidth(true);
    }

    @Override
    protected ObjectViewerRenderer createRenderer() {
        return new PlanTreeRenderer();
    }

    @Override
    @NotNull
    protected String getListConfigId(List<Class<?>> classList) {
        return "ExecutionPlan/" + this.context.getDataSource().getContainer().getDriver().getId();
    }

    @Override
    protected LoadingJob<Collection<DBCPlanNode>> createLoadService() {
        return LoadingJob.createService(new ExplainPlanService(), new PlanLoadVisualizer());
    }

    public boolean isInitialized() {
        return this.planner != null;
    }

    public void init(DBCExecutionContext context, DBCQueryPlanner planner, String query) {
        this.context = context;
        this.planner = planner;
        this.query = query;
    }

    private class ExplainPlanService
    extends DatabaseLoadService<Collection<DBCPlanNode>> {
        protected ExplainPlanService() {
            super("Explain plan", PlanNodesTree.this.planner.getDataSource());
        }

        public Collection<DBCPlanNode> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (DBCSession session = PlanNodesTree.this.context.openSession(monitor, DBCExecutionPurpose.UTIL, "Explain '" + PlanNodesTree.this.query + "'");){
                    DBCPlan plan = PlanNodesTree.this.planner.planQueryExecution(session, PlanNodesTree.this.query);
                    return plan.getPlanNodes();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable ex) {
                throw new InvocationTargetException(ex);
            }
        }
    }

    public class PlanLoadVisualizer
    extends ObjectListControl.ObjectsLoadVisualizer {
        @Override
        public void completeLoading(Collection<DBCPlanNode> items) {
            super.completeLoading(items);
            TreeViewer itemsViewer = (TreeViewer)PlanNodesTree.this.getItemsViewer();
            itemsViewer.getControl().setRedraw(false);
            try {
                itemsViewer.expandToLevel(10);
            }
            finally {
                itemsViewer.getControl().setRedraw(true);
            }
        }
    }

    private class PlanTreeRenderer
    extends ObjectListControl.ViewerRenderer {
        private PlanTreeRenderer() {
        }

        public boolean isHyperlink(Object cellValue) {
            return cellValue instanceof DBSObject;
        }

        public void navigateHyperlink(Object cellValue) {
            if (cellValue instanceof DBSObject) {
                NavigatorHandlerObjectOpen.openEntityEditor((DBSObject)cellValue);
            }
        }
    }
}

