/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.grouping;

import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;

public class GroupingDataContainer
implements DBSDataContainer {
    private static final Log log = Log.getLog(GroupingDataContainer.class);
    private IResultSetController parentController;
    private String query;

    public GroupingDataContainer(IResultSetController parentController) {
        this.parentController = parentController;
    }

    public DBSObject getParentObject() {
        return this.parentController.getDataContainer();
    }

    public String getName() {
        return "Grouping";
    }

    public String getDescription() {
        return "Grouping data";
    }

    public DBPDataSource getDataSource() {
        return this.parentController.getDataContainer().getDataSource();
    }

    public int getSupportedFeatures() {
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public DBCStatistics readData(DBCExecutionSource source, DBCSession session, DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags) throws DBCException {
        statistics = new DBCStatistics();
        hasLimits = firstRow >= 0L && maxRows > 0L;
        monitor = session.getProgressMonitor();
        sqlQuery = new StringBuilder(this.query);
        SQLUtils.appendQueryOrder((DBPDataSource)this.getDataSource(), (StringBuilder)sqlQuery, null, (DBDDataFilter)dataFilter);
        statistics.setQueryText(sqlQuery.toString());
        statistics.addStatementsCount();
        monitor.subTask(ModelMessages.model_jdbc_fetch_table_data);
        try {
            var15_12 = null;
            var16_14 = null;
            try {
                dbStat = DBUtils.makeStatement((DBCExecutionSource)source, (DBCSession)session, (DBCStatementType)DBCStatementType.SCRIPT, (String)sqlQuery.toString(), (long)firstRow, (long)maxRows);
                try {
                    if (monitor.isCanceled()) {
                        var29_17 = statistics;
                        while (true) {
                            dataReceiver.close();
                            return var29_17;
                        }
                    }
                    startTime = System.currentTimeMillis();
                    executeResult = dbStat.executeStatement();
                    statistics.setExecuteTime(System.currentTimeMillis() - startTime);
                    if (executeResult) {
                        var21_21 = null;
                        var22_23 = null;
                        try {
                            dbResult = dbStat.openResultSet();
                            try {
                                try {
                                    dataReceiver.fetchStart(session, dbResult, firstRow, maxRows);
                                    startTime = System.currentTimeMillis();
                                    rowCount = 0L;
                                    while (dbResult.nextRow()) {
                                        if (monitor.isCanceled() || hasLimits && rowCount >= maxRows) break;
                                        dataReceiver.fetchRow(session, dbResult);
                                        ++rowCount;
                                    }
                                    statistics.setFetchTime(System.currentTimeMillis() - startTime);
                                    statistics.setRowsFetched(rowCount);
                                }
                                finally {
                                    try {
                                        dataReceiver.fetchEnd(session, dbResult);
                                    }
                                    catch (Throwable e) {
                                        GroupingDataContainer.log.error((Object)"Error while finishing result set fetch", e);
                                    }
                                }
                            }
                            finally {
                                if (dbResult != null) {
                                    dbResult.close();
                                }
                            }
                        }
                        catch (Throwable var22_24) {
                            if (var21_21 == null) {
                                var21_21 = var22_24;
                            } else if (var21_21 != var22_24) {
                                var21_21.addSuppressed(var22_24);
                            }
                            throw var21_21;
                        }
                    }
                    var29_18 = statistics;
                    ** try [egrp 9[TRYBLOCK] [7 : 421->430)] { 
                }
lbl65:
                // 1 sources

                catch (Throwable var15_13) {
                    throw var15_13;
                }
                finally {
                    if (dbStat == null) ** continue;
                    dbStat.close();
                }
lbl-1000:
                // 1 sources

                {
                    dataReceiver.close();
                    return var29_18;
                }
            }
            catch (Throwable var16_15) {
                if (var15_12 == null) {
                    var15_12 = var16_15;
                } else if (var15_12 != var16_15) {
                    var15_12.addSuppressed(var16_15);
                }
                throw var15_12;
            }
        }
        catch (Throwable var28_30) {
            dataReceiver.close();
            throw var28_30;
        }
    }

    public long countData(DBCExecutionSource source, DBCSession session, DBDDataFilter dataFilter, long flags) throws DBCException {
        return 0L;
    }

    public boolean isPersisted() {
        return false;
    }

    public void setGroupingQuery(String sql) {
        this.query = sql;
    }
}

