/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.utils.CommonUtils;

class ValidateUniqueKeyUsageDialog
extends MessageDialogWithToggle {
    @NotNull
    private final ResultSetViewer viewer;
    @NotNull
    private final DBCExecutionContext executionContext;

    protected ValidateUniqueKeyUsageDialog(@NotNull ResultSetViewer viewer, @NotNull DBCExecutionContext executionContext) {
        super(viewer.getControl().getShell(), "Possible multiple rows modification", null, "There is no physical unique key defined for  '" + DBUtils.getObjectFullName((DBPNamedObject)viewer.getVirtualEntityIdentifier().getUniqueKey().getParentObject(), (DBPEvaluationContext)DBPEvaluationContext.UI) + "'.\nDBeaver will use all columns as unique key. Possible multiple rows modification. \nAre you sure you want to proceed?", 4, new String[]{"Use All Columns", "Custom Unique Key", IDialogConstants.CANCEL_LABEL}, 0, "Do not ask again for '" + executionContext.getDataSource().getContainer().getName() + "'", false);
        this.viewer = viewer;
        this.executionContext = executionContext;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected void buttonPressed(int buttonId) {
        this.executionContext.getDataSource().getContainer().getPreferenceStore().setValue("resultset.edit.key.use_all_columns", this.getToggleState());
        switch (buttonId) {
            case 1: {
                super.buttonPressed(buttonId);
                break;
            }
            case 256: {
                if (!ValidateUniqueKeyUsageDialog.useAllColumns(this.getShell(), this.viewer)) break;
                super.buttonPressed(0);
                break;
            }
            case 257: {
                this.editCustomKey();
            }
        }
        this.executionContext.getDataSource().getContainer().persistConfiguration();
    }

    private void editCustomKey() {
        try {
            if (this.viewer.editEntityIdentifier((DBRProgressMonitor)new VoidProgressMonitor())) {
                super.buttonPressed(0);
            }
        }
        catch (DBException e) {
            DBUserInterface.getInstance().showError("Virtual key edit", "Error editing virtual key", (Throwable)e);
        }
    }

    private static boolean useAllColumns(Shell shell, ResultSetViewer viewer) {
        DBDRowIdentifier identifier = viewer.getVirtualEntityIdentifier();
        DBVEntityConstraint constraint = (DBVEntityConstraint)identifier.getUniqueKey();
        ArrayList<DBSEntityAttribute> uniqueColumns = new ArrayList<DBSEntityAttribute>();
        DBDAttributeBinding[] dBDAttributeBindingArray = viewer.getModel().getAttributes();
        int n = dBDAttributeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
            if (binding.getEntityAttribute() != null) {
                uniqueColumns.add(binding.getEntityAttribute());
            }
            ++n2;
        }
        if (uniqueColumns.isEmpty()) {
            DBUserInterface.getInstance().showError("Use All Columns", "No valid columns found for unique key");
            return false;
        }
        constraint.setAttributes(uniqueColumns);
        try {
            identifier.reloadAttributes((DBRProgressMonitor)new VoidProgressMonitor(), viewer.getModel().getAttributes());
        }
        catch (DBException e) {
            DBUserInterface.getInstance().showError("Use All Columns", "Can't reload unique columns", (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean validateUniqueKey(@NotNull ResultSetViewer viewer, @NotNull DBCExecutionContext executionContext) {
        DBDRowIdentifier identifier = viewer.getVirtualEntityIdentifier();
        if (identifier == null) {
            return false;
        }
        if (!CommonUtils.isEmpty((Collection)identifier.getAttributes())) {
            return true;
        }
        if (executionContext.getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.edit.key.use_all_columns") && ValidateUniqueKeyUsageDialog.useAllColumns(viewer.getControl().getShell(), viewer)) {
            return true;
        }
        ValidateUniqueKeyUsageDialog dialog = new ValidateUniqueKeyUsageDialog(viewer, executionContext);
        int result = dialog.open();
        return result == 0;
    }
}

