/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DataSourceUtils {
    public static final String PARAM_ID = "id";
    public static final String PARAM_DRIVER = "driver";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_URL = "url";
    public static final String PARAM_HOST = "host";
    public static final String PARAM_PORT = "port";
    public static final String PARAM_SERVER = "server";
    public static final String PARAM_DATABASE = "database";
    public static final String PARAM_USER = "user";
    public static final String PARAM_PASSWORD = "password";
    public static final String PARAM_SAVE_PASSWORD = "savePassword";
    public static final String PARAM_SHOW_SYSTEM_OBJECTS = "showSystemObjects";
    public static final String PARAM_SHOW_UTILITY_OBJECTS = "showUtilityObjects";
    public static final String PARAM_FOLDER = "folder";
    public static final String PARAM_AUTO_COMMIT = "autoCommit";
    public static final String PREFIX_HANDLER = "handler.";
    public static final String PREFIX_PROP = "prop.";
    private static final Log log = Log.getLog(DataSourceUtils.class);

    /*
     * WARNING - void declaration
     */
    public static DBPDataSourceContainer getDataSourceBySpec(@NotNull IProject project, @NotNull String connectionSpec, @Nullable GeneralUtils.IParameterHandler parameterHandler, boolean searchByParameters, boolean createNewDataSource) {
        void var25_30;
        String[] conParams;
        String driverName = null;
        String url = null;
        String host = null;
        String port = null;
        String server = null;
        String database = null;
        String user = null;
        String password = null;
        boolean showSystemObjects = false;
        boolean showUtilityObjects = false;
        boolean savePassword = true;
        Boolean autoCommit = null;
        HashMap<String, String> conProperties = new HashMap<String, String>();
        HashMap<String, Map> handlerProps = new HashMap<String, Map>();
        DBPDataSourceFolder folder = null;
        String dsId = null;
        String dsName = null;
        DataSourceRegistry dsRegistry = DBeaverCore.getInstance().getProjectRegistry().getDataSourceRegistry(project);
        if (dsRegistry == null) {
            log.debug((Object)("No datasource registry for project '" + project.getName() + "'"));
            return null;
        }
        String[] stringArray = conParams = connectionSpec.split("\\|");
        int n = conParams.length;
        boolean n2 = false;
        while (var25_30 < n) {
            block80: {
                String cp = stringArray[var25_30];
                int divPos = cp.indexOf(61);
                if (divPos == -1) break block80;
                String paramName = cp.substring(0, divPos);
                String paramValue = cp.substring(divPos + 1);
                switch (paramName) {
                    case "id": {
                        dsId = paramValue;
                        break;
                    }
                    case "driver": {
                        driverName = paramValue;
                        break;
                    }
                    case "name": {
                        dsName = paramValue;
                        break;
                    }
                    case "url": {
                        url = paramValue;
                        break;
                    }
                    case "host": {
                        host = paramValue;
                        break;
                    }
                    case "port": {
                        port = paramValue;
                        break;
                    }
                    case "server": {
                        server = paramValue;
                        break;
                    }
                    case "database": {
                        database = paramValue;
                        break;
                    }
                    case "user": {
                        user = paramValue;
                        break;
                    }
                    case "password": {
                        password = paramValue;
                        break;
                    }
                    case "savePassword": {
                        savePassword = CommonUtils.toBoolean((Object)paramValue);
                        break;
                    }
                    case "showSystemObjects": {
                        showSystemObjects = CommonUtils.toBoolean((Object)paramValue);
                        break;
                    }
                    case "showUtilityObjects": {
                        showUtilityObjects = CommonUtils.toBoolean((Object)paramValue);
                        break;
                    }
                    case "folder": {
                        folder = dsRegistry.getFolder(paramValue);
                        break;
                    }
                    case "autoCommit": {
                        autoCommit = CommonUtils.toBoolean((Object)paramValue);
                        break;
                    }
                    default: {
                        boolean handled = false;
                        if (paramName.length() > PREFIX_PROP.length() && paramName.startsWith(PREFIX_PROP)) {
                            paramName = paramName.substring(PREFIX_PROP.length());
                            conProperties.put(paramName, paramValue);
                            handled = true;
                        } else if (paramName.length() > PREFIX_HANDLER.length() && paramName.startsWith(PREFIX_HANDLER)) {
                            divPos = (paramName = paramName.substring(PREFIX_HANDLER.length())).indexOf(46);
                            if (divPos == -1) {
                                log.debug((Object)("Wrong handler parameter: '" + paramName + "'"));
                                break;
                            }
                            String handlerId = paramName.substring(0, divPos);
                            paramName = paramName.substring(divPos + 1);
                            Map handlerPopMap = handlerProps.computeIfAbsent(handlerId, k -> new HashMap());
                            handlerPopMap.put(paramName, paramValue);
                            handled = true;
                        } else if (parameterHandler != null) {
                            handled = parameterHandler.setParameter(paramName, paramValue);
                        }
                        if (handled) break;
                        log.debug((Object)("Unknown connection parameter '" + paramName + "'"));
                    }
                }
            }
            ++var25_30;
        }
        DataSourceDescriptor dataSource = null;
        if (!(dsId == null || (dataSource = dsRegistry.getDataSource(dsId)) == null && createNewDataSource)) {
            return dataSource;
        }
        if (!(dsName == null || (dataSource = dsRegistry.findDataSourceByName(dsName)) == null && createNewDataSource)) {
            return dataSource;
        }
        if (searchByParameters) {
            if (url != null) {
                for (DBPDataSourceContainer dBPDataSourceContainer : dsRegistry.getDataSources()) {
                    if (!url.equals(dBPDataSourceContainer.getConnectionConfiguration().getUrl()) || user != null && !user.equals(dBPDataSourceContainer.getConnectionConfiguration().getUserName())) continue;
                    return dBPDataSourceContainer;
                }
            } else {
                for (DBPDataSourceContainer dBPDataSourceContainer : dsRegistry.getDataSources()) {
                    DBPConnectionConfiguration cfg = dBPDataSourceContainer.getConnectionConfiguration();
                    if (server != null && !server.equals(cfg.getServerName()) || host != null && !host.equals(cfg.getHostName()) || port != null && !port.equals(cfg.getHostPort()) || database != null && !database.equals(cfg.getDatabaseName()) || user != null && !user.equals(cfg.getUserName())) continue;
                    boolean matched = true;
                    if (!conProperties.isEmpty()) {
                        for (Map.Entry prop : conProperties.entrySet()) {
                            if (CommonUtils.equalObjects((Object)cfg.getProperty((String)prop.getKey()), prop.getValue())) continue;
                            matched = false;
                            break;
                        }
                        if (!matched) continue;
                    }
                    if (!handlerProps.isEmpty()) {
                        for (Map.Entry handlerProp : handlerProps.entrySet()) {
                            DBWHandlerConfiguration handler = cfg.getDeclaredHandler((String)handlerProp.getKey());
                            if (handler == null) {
                                matched = false;
                                break;
                            }
                            for (Map.Entry prop : ((Map)handlerProp.getValue()).entrySet()) {
                                if (CommonUtils.equalObjects(handler.getProperties().get(prop.getKey()), prop.getValue())) continue;
                                matched = false;
                                break;
                            }
                            if (!matched) break;
                        }
                        if (!matched) continue;
                    }
                    return dBPDataSourceContainer;
                }
            }
        }
        if (!createNewDataSource) {
            return null;
        }
        if (driverName == null) {
            log.error((Object)"Driver name not specified - can't create new datasource");
            return null;
        }
        DriverDescriptor driverDescriptor = DataSourceProviderRegistry.getInstance().findDriver(driverName);
        if (driverDescriptor == null) {
            log.error((Object)("Driver '" + driverName + "' not found"));
            return null;
        }
        if (dsName == null) {
            dsName = "Ext: " + driverDescriptor.getName();
            if (database != null) {
                dsName = String.valueOf(dsName) + " - " + database;
            } else if (server != null) {
                dsName = String.valueOf(dsName) + " - " + server;
            }
        }
        DBPConnectionConfiguration connConfig = new DBPConnectionConfiguration();
        connConfig.setUrl(url);
        connConfig.setHostName(host);
        connConfig.setHostPort(port);
        connConfig.setServerName(server);
        connConfig.setDatabaseName(database);
        connConfig.setUserName(user);
        connConfig.setUserPassword(password);
        connConfig.setProperties(conProperties);
        if (autoCommit != null) {
            connConfig.getBootstrap().setDefaultAutoCommit(autoCommit);
        }
        DataSourceDescriptor newDS = new DataSourceDescriptor(dsRegistry, DataSourceDescriptor.generateNewId(driverDescriptor), driverDescriptor, connConfig);
        newDS.setName(dsName);
        newDS.setTemporary(true);
        if (savePassword) {
            newDS.setSavePassword(true);
        }
        if (folder != null) {
            newDS.setFolder(folder);
        }
        newDS.setShowSystemObjects(showSystemObjects);
        newDS.setShowUtilityObjects(showUtilityObjects);
        dsRegistry.addDataSource(newDS);
        return newDS;
    }
}

