/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core;

import java.io.File;
import java.util.Properties;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.SecurityUtils;

public class DBeaverWorkspace
implements DBPWorkspace {
    private static final String WORKSPACE_ID = "workspace-id";
    private DBPPlatform platform;
    private IWorkspace eclipseWorkspace;
    private String workspaceId;

    DBeaverWorkspace(DBPPlatform platform, IWorkspace eclipseWorkspace) {
        this.platform = platform;
        this.eclipseWorkspace = eclipseWorkspace;
        Properties workspaceInfo = DBeaverCore.readWorkspaceInfo(GeneralUtils.getMetadataFolder());
        this.workspaceId = workspaceInfo.getProperty(WORKSPACE_ID);
        if (CommonUtils.isEmpty((String)this.workspaceId)) {
            this.workspaceId = "D" + Long.toString(Math.abs(SecurityUtils.generateRandomLong()), 36).toUpperCase();
            workspaceInfo.setProperty(WORKSPACE_ID, this.workspaceId);
            DBeaverCore.writeWorkspaceInfo(GeneralUtils.getMetadataFolder(), workspaceInfo);
        }
    }

    public IWorkspace getEclipseWorkspace() {
        return this.eclipseWorkspace;
    }

    public DBPPlatform getPlatform() {
        return this.platform;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public boolean isActive() {
        return true;
    }

    public File getAbsolutePath() {
        return this.eclipseWorkspace.getRoot().getFullPath().toFile();
    }

    public void save(DBRProgressMonitor monitor) throws DBException {
        try {
            this.eclipseWorkspace.save(true, monitor.getNestedMonitor());
        }
        catch (CoreException e) {
            throw new DBException("Error saving Eclipse workspace", (Throwable)e);
        }
    }
}

