/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.figures;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.internal.xygraph.undo.SaveStateCommand;
import org.eclipse.nebula.visualization.internal.xygraph.undo.ZoomCommand;
import org.eclipse.nebula.visualization.xygraph.figures.Annotation;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.Grid;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.ZoomType;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class PlotArea
extends Figure {
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport((Object)this);
    public static final String BACKGROUND_COLOR = "background_color";
    public static final int BUTTON1 = 1;
    public static final int BUTTON2 = 2;
    private final IXYGraph xyGraph;
    private final List<Trace> traceList = new ArrayList<Trace>();
    private final List<Grid> gridList = new ArrayList<Grid>();
    private final List<Annotation> annotationList = new ArrayList<Annotation>();
    private final Cursor grabbing;
    private boolean showBorder;
    private ZoomType zoomType;
    private Point start;
    private Point dynamicStart;
    private Point end;
    private boolean armed;
    private Color revertBackColor;
    private Collection<MouseListener> auxilliaryClickListeners;
    private Collection<MouseMotionListener> auxilliaryMotionListeners;
    private ZoomType previousZoomType = ZoomType.NONE;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(property, listener);
    }

    public PlotArea(IXYGraph xyGraph) {
        this(xyGraph, XYGraphMediaFactory.getInstance().getColor(0, 0, 0), XYGraphMediaFactory.getInstance().getColor(255, 255, 255));
    }

    public PlotArea(IXYGraph xyGraph, Color foreground, Color background) {
        this.xyGraph = xyGraph;
        if (foreground != null) {
            this.setForegroundColor(foreground);
        }
        if (background != null) {
            this.internalSetBackgroundColor(background);
        }
        this.setOpaque(true);
        PlotMouseListener zoomer = new PlotMouseListener();
        this.addMouseListener(zoomer);
        this.addMouseMotionListener(zoomer);
        this.grabbing = XYGraphMediaFactory.getInstance().getCursor("images/Grabbing.png");
        this.zoomType = ZoomType.NONE;
    }

    private Color internalSetBackgroundColor(Color bg) {
        RGB backRGB = bg.getRGB();
        this.revertBackColor = XYGraphMediaFactory.getInstance().getColor(255 - backRGB.red, 255 - backRGB.green, 255 - backRGB.blue);
        Color oldColor = this.getBackgroundColor();
        super.setBackgroundColor(bg);
        return oldColor;
    }

    public void setBackgroundColor(Color bg) {
        Color oldColor = this.internalSetBackgroundColor(bg);
        this.changeSupport.firePropertyChange(BACKGROUND_COLOR, oldColor, bg);
    }

    public void addTrace(Trace trace) {
        this.traceList.add(trace);
        this.add((IFigure)trace);
        this.revalidate();
    }

    public boolean removeTrace(Trace trace) {
        boolean result = this.traceList.remove(trace);
        if (result) {
            this.remove((IFigure)trace);
            this.revalidate();
        }
        return result;
    }

    public void addGrid(Grid grid) {
        this.gridList.add(grid);
        this.add((IFigure)grid);
        this.revalidate();
    }

    public boolean removeGrid(Grid grid) {
        boolean result = this.gridList.remove(grid);
        if (result) {
            this.remove((IFigure)grid);
            this.revalidate();
        }
        return result;
    }

    public void addAnnotation(Annotation annotation) {
        this.annotationList.add(annotation);
        annotation.setXYGraph(this.xyGraph);
        this.add((IFigure)annotation);
        this.revalidate();
        this.changeSupport.firePropertyChange("annotationList", null, annotation);
    }

    public boolean removeAnnotation(Annotation annotation) {
        Trace trace;
        boolean result = this.annotationList.remove(annotation);
        if (!annotation.isFree() && (trace = annotation.getTrace()) != null && trace.getDataProvider() != null) {
            trace.getDataProvider().removeDataProviderListener(annotation);
        }
        if (result) {
            this.remove((IFigure)annotation);
            this.revalidate();
            this.changeSupport.firePropertyChange("annotationList", annotation, null);
        }
        return result;
    }

    protected void layout() {
        Rectangle clientArea = this.getClientArea();
        for (Trace trace : this.traceList) {
            if (trace == null || !trace.isVisible()) continue;
            trace.setBounds(clientArea);
        }
        for (Grid grid : this.gridList) {
            if (grid == null || !grid.isVisible()) continue;
            grid.setBounds(clientArea);
        }
        for (Annotation annotation : this.annotationList) {
            if (annotation == null || !annotation.isVisible()) continue;
            annotation.setBounds(clientArea);
        }
        super.layout();
    }

    protected void paintClientArea(Graphics graphics) {
        super.paintClientArea(graphics);
        if (this.showBorder) {
            graphics.setLineWidth(2);
            graphics.drawLine(this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y);
            graphics.drawLine(this.bounds.x + this.bounds.width, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height);
        }
        if (this.armed && this.end != null && this.start != null) {
            switch (this.zoomType) {
                case RUBBERBAND_ZOOM: 
                case DYNAMIC_ZOOM: 
                case HORIZONTAL_ZOOM: 
                case VERTICAL_ZOOM: {
                    graphics.setLineStyle(3);
                    graphics.setLineWidth(1);
                    graphics.setForegroundColor(this.revertBackColor);
                    graphics.drawRectangle(this.start.x, this.start.y, this.end.x - this.start.x, this.end.y - this.start.y);
                    break;
                }
            }
        }
    }

    public void setShowBorder(boolean showBorder) {
        this.showBorder = showBorder;
        this.repaint();
    }

    public boolean isShowBorder() {
        return this.showBorder;
    }

    public void setZoomType(ZoomType zoomType) {
        this.zoomType = zoomType;
        this.setCursor(zoomType.getCursor());
    }

    public ZoomType getZoomType() {
        return this.zoomType;
    }

    public IXYGraph getXYGraph() {
        return this.xyGraph;
    }

    public void zoomInOut(boolean horizontally, boolean vertically, int mouseX, int mouseY, double factor) {
        double center;
        if (horizontally) {
            for (Axis axis : this.xyGraph.getXAxisList()) {
                center = axis.getPositionValue(mouseX, false);
                axis.zoomInOut(center, factor);
            }
        }
        if (vertically) {
            for (Axis axis : this.xyGraph.getYAxisList()) {
                center = axis.getPositionValue(mouseY, false);
                axis.zoomInOut(center, factor);
            }
        }
    }

    public List<Trace> getTraceList() {
        return this.traceList;
    }

    public List<Annotation> getAnnotationList() {
        return this.annotationList;
    }

    public void addAuxilliaryMotionListener(MouseMotionListener auxilliaryMotionListener) {
        if (this.auxilliaryMotionListeners == null) {
            this.auxilliaryMotionListeners = new HashSet<MouseMotionListener>();
        }
        this.auxilliaryMotionListeners.add(auxilliaryMotionListener);
    }

    public void removeAuxilliaryClickListener(MouseListener auxilliaryClickListener) {
        if (this.auxilliaryClickListeners == null) {
            return;
        }
        this.auxilliaryClickListeners.remove(auxilliaryClickListener);
    }

    public void removeAuxilliaryMotionListener(MouseMotionListener auxilliaryMotionListener) {
        if (this.auxilliaryMotionListeners == null) {
            return;
        }
        this.auxilliaryMotionListeners.remove(auxilliaryMotionListener);
    }

    public void addAuxilliaryClickListener(MouseListener auxilliaryClickListener) {
        if (this.auxilliaryClickListeners == null) {
            this.auxilliaryClickListeners = new HashSet<MouseListener>();
        }
        this.auxilliaryClickListeners.add(auxilliaryClickListener);
    }

    public void fireMouseReleased(MouseEvent me) {
        if (this.auxilliaryClickListeners == null) {
            return;
        }
        for (MouseListener l : this.auxilliaryClickListeners) {
            l.mouseReleased(me);
        }
    }

    public void fireMouseDoubleClicked(MouseEvent me) {
        if (this.auxilliaryClickListeners == null) {
            return;
        }
        for (MouseListener l : this.auxilliaryClickListeners) {
            l.mouseDoubleClicked(me);
        }
    }

    public void fireMousePressed(MouseEvent me) {
        if (this.auxilliaryClickListeners == null) {
            return;
        }
        for (MouseListener l : this.auxilliaryClickListeners) {
            l.mousePressed(me);
        }
    }

    public void fireMouseMoved(MouseEvent me) {
        if (this.auxilliaryMotionListeners == null) {
            return;
        }
        for (MouseMotionListener l : this.auxilliaryMotionListeners) {
            l.mouseMoved(me);
        }
    }

    public void fireMouseHover(MouseEvent me) {
        if (this.auxilliaryMotionListeners == null) {
            return;
        }
        for (MouseMotionListener l : this.auxilliaryMotionListeners) {
            l.mouseHover(me);
        }
    }

    public void fireMouseEntered(MouseEvent me) {
        if (this.auxilliaryMotionListeners == null) {
            return;
        }
        for (MouseMotionListener l : this.auxilliaryMotionListeners) {
            l.mouseEntered(me);
        }
    }

    public void fireMouseExited(MouseEvent me) {
        if (this.auxilliaryMotionListeners == null) {
            return;
        }
        for (MouseMotionListener l : this.auxilliaryMotionListeners) {
            l.mouseExited(me);
        }
    }

    public void fireMouseDragged(MouseEvent me) {
        if (this.auxilliaryMotionListeners == null) {
            return;
        }
        for (MouseMotionListener l : this.auxilliaryMotionListeners) {
            l.mouseDragged(me);
        }
    }

    private static enum PanStatus {
        X_FAIL,
        Y_FAIL,
        XY_FAIL,
        SUCCESS;

    }

    class PlotMouseListener
    implements MouseListener,
    MouseMotionListener {
        private final List<Range> xAxisStartRangeList = new ArrayList<Range>();
        private final List<Range> yAxisStartRangeList = new ArrayList<Range>();
        private SaveStateCommand command;
        private boolean dynamicZoomMode = false;

        PlotMouseListener() {
        }

        public void mousePressed(MouseEvent me) {
            PlotArea.this.fireMousePressed(me);
            if ((me.button != 1 || PlotArea.this.zoomType == ZoomType.NONE) && me.button != 2) {
                return;
            }
            PlotArea.this.previousZoomType = PlotArea.this.zoomType;
            if (me.button == 2) {
                PlotArea.this.zoomType = ZoomType.PANNING;
            }
            PlotArea.this.armed = true;
            this.dynamicZoomMode = false;
            switch (PlotArea.this.zoomType) {
                case RUBBERBAND_ZOOM: {
                    PlotArea.this.start = me.getLocation();
                    PlotArea.this.end = null;
                    break;
                }
                case DYNAMIC_ZOOM: {
                    PlotArea.this.start = me.getLocation();
                    PlotArea.this.dynamicStart = me.getLocation();
                    PlotArea.this.end = null;
                    break;
                }
                case HORIZONTAL_ZOOM: {
                    PlotArea.this.start = new Point(me.getLocation().x, ((PlotArea)PlotArea.this).bounds.y);
                    PlotArea.this.end = null;
                    break;
                }
                case VERTICAL_ZOOM: {
                    PlotArea.this.start = new Point(((PlotArea)PlotArea.this).bounds.x, me.getLocation().y);
                    PlotArea.this.end = null;
                    break;
                }
                case PANNING: {
                    PlotArea.this.setCursor(PlotArea.this.grabbing);
                    PlotArea.this.start = me.getLocation();
                    PlotArea.this.end = null;
                    this.xAxisStartRangeList.clear();
                    this.yAxisStartRangeList.clear();
                    for (Axis axis : PlotArea.this.xyGraph.getXAxisList()) {
                        this.xAxisStartRangeList.add(axis.getRange());
                    }
                    for (Axis axis : PlotArea.this.xyGraph.getYAxisList()) {
                        this.yAxisStartRangeList.add(axis.getRange());
                    }
                    break;
                }
                case ZOOM_IN: 
                case ZOOM_OUT: 
                case ZOOM_IN_HORIZONTALLY: 
                case ZOOM_OUT_HORIZONTALLY: 
                case ZOOM_IN_VERTICALLY: 
                case ZOOM_OUT_VERTICALLY: {
                    PlotArea.this.start = me.getLocation();
                    PlotArea.this.end = new Point();
                    Display.getCurrent().timerExec(200, new Runnable(){

                        @Override
                        public void run() {
                            if (!PlotArea.this.armed) {
                                return;
                            }
                            PlotMouseListener.this.performInOutZoom();
                            Display.getCurrent().timerExec(200, (Runnable)this);
                        }
                    });
                    break;
                }
            }
            this.command = new ZoomCommand(PlotArea.this.zoomType.getDescription(), PlotArea.this.xyGraph.getXAxisList(), PlotArea.this.xyGraph.getYAxisList());
            me.consume();
        }

        public void mouseDoubleClicked(MouseEvent me) {
            PlotArea.this.fireMouseDoubleClicked(me);
        }

        public void mouseDragged(MouseEvent me) {
            PlotArea.this.fireMouseDragged(me);
            if (!PlotArea.this.armed) {
                return;
            }
            if (this.dynamicZoomMode) {
                PlotArea.this.zoomType = ZoomType.DYNAMIC_ZOOM;
            }
            block0 : switch (PlotArea.this.zoomType) {
                case DYNAMIC_ZOOM: {
                    this.dynamicZoomMode = true;
                    if (Math.abs(((PlotArea)PlotArea.this).dynamicStart.x - me.x) < 30) {
                        PlotArea.this.start = new Point(((PlotArea)PlotArea.this).bounds.x, ((PlotArea)PlotArea.this).dynamicStart.y);
                        PlotArea.this.end = new Point(((PlotArea)PlotArea.this).bounds.x + ((PlotArea)PlotArea.this).bounds.width, me.getLocation().y);
                        PlotArea.this.setZoomType(ZoomType.VERTICAL_ZOOM);
                        break;
                    }
                    if (Math.abs(((PlotArea)PlotArea.this).dynamicStart.y - me.y) < 30) {
                        PlotArea.this.start = new Point(((PlotArea)PlotArea.this).dynamicStart.x, ((PlotArea)PlotArea.this).bounds.y);
                        PlotArea.this.end = new Point(me.getLocation().x, ((PlotArea)PlotArea.this).bounds.y + ((PlotArea)PlotArea.this).bounds.height);
                        PlotArea.this.setZoomType(ZoomType.HORIZONTAL_ZOOM);
                        break;
                    }
                    PlotArea.this.start = PlotArea.this.dynamicStart;
                    PlotArea.this.end = me.getLocation();
                    PlotArea.this.setZoomType(ZoomType.RUBBERBAND_ZOOM);
                    break;
                }
                case RUBBERBAND_ZOOM: {
                    PlotArea.this.end = me.getLocation();
                    break;
                }
                case HORIZONTAL_ZOOM: {
                    PlotArea.this.end = new Point(me.getLocation().x, ((PlotArea)PlotArea.this).bounds.y + ((PlotArea)PlotArea.this).bounds.height);
                    break;
                }
                case VERTICAL_ZOOM: {
                    PlotArea.this.end = new Point(((PlotArea)PlotArea.this).bounds.x + ((PlotArea)PlotArea.this).bounds.width, me.getLocation().y);
                    break;
                }
                case PANNING: {
                    Point old = PlotArea.this.end == null ? PlotArea.this.start : PlotArea.this.end;
                    PlotArea.this.end = me.getLocation();
                    switch (this.pan()) {
                        case XY_FAIL: {
                            PlotArea.this.end = old;
                            break block0;
                        }
                        case X_FAIL: {
                            ((PlotArea)PlotArea.this).end.x = old.x;
                            break block0;
                        }
                        case Y_FAIL: {
                            ((PlotArea)PlotArea.this).end.y = old.y;
                            break block0;
                        }
                    }
                    break;
                }
            }
            PlotArea.this.repaint();
        }

        public void mouseExited(MouseEvent me) {
            PlotArea.this.fireMouseExited(me);
            switch (PlotArea.this.zoomType) {
                case ZOOM_IN: 
                case ZOOM_OUT: 
                case ZOOM_IN_HORIZONTALLY: 
                case ZOOM_OUT_HORIZONTALLY: 
                case ZOOM_IN_VERTICALLY: 
                case ZOOM_OUT_VERTICALLY: {
                    this.mouseReleased(me);
                }
            }
        }

        public void mouseReleased(MouseEvent me) {
            PlotArea.this.fireMouseReleased(me);
            if (!PlotArea.this.armed) {
                return;
            }
            PlotArea.this.armed = false;
            if (PlotArea.this.zoomType == ZoomType.PANNING) {
                PlotArea.this.setCursor(PlotArea.this.zoomType.getCursor());
            }
            if (PlotArea.this.end == null || PlotArea.this.start == null) {
                return;
            }
            if (this.dynamicZoomMode) {
                double t2;
                double t1;
                if (PlotArea.this.zoomType != ZoomType.VERTICAL_ZOOM) {
                    for (Axis axis : PlotArea.this.xyGraph.getXAxisList()) {
                        t1 = axis.getPositionValue(((PlotArea)PlotArea.this).start.x, false);
                        t2 = axis.getPositionValue(((PlotArea)PlotArea.this).end.x, false);
                        axis.setRange(t1, t2, true);
                    }
                }
                if (PlotArea.this.zoomType != ZoomType.HORIZONTAL_ZOOM) {
                    for (Axis axis : PlotArea.this.xyGraph.getYAxisList()) {
                        t1 = axis.getPositionValue(((PlotArea)PlotArea.this).start.y, false);
                        t2 = axis.getPositionValue(((PlotArea)PlotArea.this).end.y, false);
                        axis.setRange(t1, t2, true);
                    }
                }
                PlotArea.this.setZoomType(ZoomType.DYNAMIC_ZOOM);
            } else {
                switch (PlotArea.this.zoomType) {
                    case RUBBERBAND_ZOOM: {
                        double t2;
                        double t1;
                        for (Axis axis : PlotArea.this.xyGraph.getXAxisList()) {
                            t1 = axis.getPositionValue(((PlotArea)PlotArea.this).start.x, false);
                            t2 = axis.getPositionValue(((PlotArea)PlotArea.this).end.x, false);
                            axis.setRange(t1, t2, true);
                        }
                        for (Axis axis : PlotArea.this.xyGraph.getYAxisList()) {
                            t1 = axis.getPositionValue(((PlotArea)PlotArea.this).start.y, false);
                            t2 = axis.getPositionValue(((PlotArea)PlotArea.this).end.y, false);
                            axis.setRange(t1, t2, true);
                        }
                        break;
                    }
                    case HORIZONTAL_ZOOM: {
                        for (Axis axis : PlotArea.this.xyGraph.getXAxisList()) {
                            double t1 = axis.getPositionValue(((PlotArea)PlotArea.this).start.x, false);
                            double t2 = axis.getPositionValue(((PlotArea)PlotArea.this).end.x, false);
                            axis.setRange(t1, t2, true);
                        }
                        break;
                    }
                    case VERTICAL_ZOOM: {
                        for (Axis axis : PlotArea.this.xyGraph.getYAxisList()) {
                            double t1 = axis.getPositionValue(((PlotArea)PlotArea.this).start.y, false);
                            double t2 = axis.getPositionValue(((PlotArea)PlotArea.this).end.y, false);
                            axis.setRange(t1, t2, true);
                        }
                        break;
                    }
                    case PANNING: {
                        this.pan();
                        break;
                    }
                    case ZOOM_IN: 
                    case ZOOM_OUT: 
                    case ZOOM_IN_HORIZONTALLY: 
                    case ZOOM_OUT_HORIZONTALLY: 
                    case ZOOM_IN_VERTICALLY: 
                    case ZOOM_OUT_VERTICALLY: {
                        this.performInOutZoom();
                        break;
                    }
                }
            }
            if (me.button == 2 && PlotArea.this.previousZoomType != ZoomType.PANNING) {
                PlotArea.this.zoomType = PlotArea.this.previousZoomType;
                PlotArea.this.setCursor(PlotArea.this.previousZoomType.getCursor());
            }
            if (PlotArea.this.zoomType != ZoomType.NONE && this.command != null) {
                this.command.saveState();
                PlotArea.this.xyGraph.getOperationsManager().addCommand(this.command);
                this.command = null;
            }
            PlotArea.this.start = null;
            PlotArea.this.end = null;
            PlotArea.this.repaint();
        }

        private PanStatus pan() {
            Axis axis;
            List<Axis> axes = PlotArea.this.xyGraph.getXAxisList();
            PanStatus status = PanStatus.SUCCESS;
            int i = 0;
            while (i < axes.size()) {
                axis = axes.get(i);
                if (axis.panChecked(this.xAxisStartRangeList.get(i), axis.getPositionValue(((PlotArea)PlotArea.this).start.x, false), axis.getPositionValue(((PlotArea)PlotArea.this).end.x, false))) {
                    status = PanStatus.X_FAIL;
                    break;
                }
                ++i;
            }
            axes = PlotArea.this.xyGraph.getYAxisList();
            i = 0;
            while (i < axes.size()) {
                axis = axes.get(i);
                if (axis.panChecked(this.yAxisStartRangeList.get(i), axis.getPositionValue(((PlotArea)PlotArea.this).start.y, false), axis.getPositionValue(((PlotArea)PlotArea.this).end.y, false))) {
                    status = status == PanStatus.X_FAIL ? PanStatus.XY_FAIL : PanStatus.Y_FAIL;
                    break;
                }
                ++i;
            }
            return status;
        }

        private void performInOutZoom() {
            switch (PlotArea.this.zoomType) {
                case ZOOM_IN: {
                    PlotArea.this.zoomInOut(true, true, ((PlotArea)PlotArea.this).start.x, ((PlotArea)PlotArea.this).start.y, 0.1);
                    break;
                }
                case ZOOM_IN_HORIZONTALLY: {
                    PlotArea.this.zoomInOut(true, false, ((PlotArea)PlotArea.this).start.x, ((PlotArea)PlotArea.this).start.y, 0.1);
                    break;
                }
                case ZOOM_IN_VERTICALLY: {
                    PlotArea.this.zoomInOut(false, true, ((PlotArea)PlotArea.this).start.x, ((PlotArea)PlotArea.this).start.y, 0.1);
                    break;
                }
                case ZOOM_OUT: {
                    PlotArea.this.zoomInOut(true, true, ((PlotArea)PlotArea.this).start.x, ((PlotArea)PlotArea.this).start.y, -0.1);
                    break;
                }
                case ZOOM_OUT_HORIZONTALLY: {
                    PlotArea.this.zoomInOut(true, false, ((PlotArea)PlotArea.this).start.x, ((PlotArea)PlotArea.this).start.y, -0.1);
                    break;
                }
                case ZOOM_OUT_VERTICALLY: {
                    PlotArea.this.zoomInOut(false, true, ((PlotArea)PlotArea.this).start.x, ((PlotArea)PlotArea.this).start.y, -0.1);
                }
            }
        }

        public void mouseEntered(MouseEvent me) {
            PlotArea.this.fireMouseEntered(me);
        }

        public void mouseHover(MouseEvent me) {
            PlotArea.this.fireMouseHover(me);
        }

        public void mouseMoved(MouseEvent me) {
            PlotArea.this.fireMouseMoved(me);
        }
    }
}

