/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.polygonize;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.polygonize.PolygonizeEdge;
import com.vividsolutions.jts.planargraph.DirectedEdge;
import java.util.ArrayList;
import java.util.List;

class EdgeRing {
    private GeometryFactory factory;
    private List deList = new ArrayList();
    private LinearRing ring = null;
    private Coordinate[] ringPts = null;
    private List holes;

    public static EdgeRing findEdgeRingContaining(EdgeRing testEr, List shellList) {
        LinearRing testRing = testEr.getRing();
        Envelope testEnv = testRing.getEnvelopeInternal();
        Coordinate testPt = testRing.getCoordinateN(0);
        EdgeRing minShell = null;
        Envelope minShellEnv = null;
        for (EdgeRing tryShell : shellList) {
            LinearRing tryShellRing = tryShell.getRing();
            Envelope tryShellEnv = tryShellRing.getEnvelopeInternal();
            if (tryShellEnv.equals(testEnv) || !tryShellEnv.contains(testEnv)) continue;
            testPt = CoordinateArrays.ptNotInList(testRing.getCoordinates(), tryShellRing.getCoordinates());
            boolean isContained = false;
            if (CGAlgorithms.isPointInRing(testPt, tryShellRing.getCoordinates())) {
                isContained = true;
            }
            if (!isContained || minShell != null && !minShellEnv.contains(tryShellEnv)) continue;
            minShell = tryShell;
            minShellEnv = minShell.getRing().getEnvelopeInternal();
        }
        return minShell;
    }

    public static Coordinate ptNotInList(Coordinate[] testPts, Coordinate[] pts) {
        for (int i = 0; i < testPts.length; ++i) {
            Coordinate testPt = testPts[i];
            if (EdgeRing.isInList(testPt, pts)) continue;
            return testPt;
        }
        return null;
    }

    public static boolean isInList(Coordinate pt, Coordinate[] pts) {
        for (int i = 0; i < pts.length; ++i) {
            if (!pt.equals(pts[i])) continue;
            return true;
        }
        return false;
    }

    public EdgeRing(GeometryFactory factory) {
        this.factory = factory;
    }

    public void add(DirectedEdge de) {
        this.deList.add(de);
    }

    public boolean isHole() {
        LinearRing ring = this.getRing();
        return CGAlgorithms.isCCW(ring.getCoordinates());
    }

    public void addHole(LinearRing hole) {
        if (this.holes == null) {
            this.holes = new ArrayList();
        }
        this.holes.add(hole);
    }

    public Polygon getPolygon() {
        LinearRing[] holeLR = null;
        if (this.holes != null) {
            holeLR = new LinearRing[this.holes.size()];
            for (int i = 0; i < this.holes.size(); ++i) {
                holeLR[i] = (LinearRing)this.holes.get(i);
            }
        }
        Polygon poly = this.factory.createPolygon(this.ring, holeLR);
        return poly;
    }

    public boolean isValid() {
        this.getCoordinates();
        if (this.ringPts.length <= 3) {
            return false;
        }
        this.getRing();
        return this.ring.isValid();
    }

    private Coordinate[] getCoordinates() {
        if (this.ringPts == null) {
            CoordinateList coordList = new CoordinateList();
            for (DirectedEdge de : this.deList) {
                PolygonizeEdge edge = (PolygonizeEdge)de.getEdge();
                EdgeRing.addEdge(edge.getLine().getCoordinates(), de.getEdgeDirection(), coordList);
            }
            this.ringPts = coordList.toCoordinateArray();
        }
        return this.ringPts;
    }

    public LineString getLineString() {
        this.getCoordinates();
        return this.factory.createLineString(this.ringPts);
    }

    public LinearRing getRing() {
        if (this.ring != null) {
            return this.ring;
        }
        this.getCoordinates();
        if (this.ringPts.length < 3) {
            System.out.println(this.ringPts);
        }
        try {
            this.ring = this.factory.createLinearRing(this.ringPts);
        }
        catch (Exception ex) {
            System.out.println(this.ringPts);
        }
        return this.ring;
    }

    private static void addEdge(Coordinate[] coords, boolean isForward, CoordinateList coordList) {
        if (isForward) {
            for (int i = 0; i < coords.length; ++i) {
                coordList.add(coords[i], false);
            }
        } else {
            for (int i = coords.length - 1; i >= 0; --i) {
                coordList.add(coords[i], false);
            }
        }
    }
}

