/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.ui;

import com.dbeaver.lm.ui.LicenseUIUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMUtils;
import org.jkiss.utils.IOUtils;

public class LicenseImportDialog
extends Dialog {
    private static final Log log = Log.getLog(LicenseImportDialog.class);
    private final LMLicenseManager licenseManager;
    private final LMProduct product;
    private Text licenseText;

    public LicenseImportDialog(Shell parentShell, LMLicenseManager licenseManager, LMProduct product) {
        super(parentShell);
        this.licenseManager = licenseManager;
        this.product = product;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Import License");
        Composite composite = (Composite)super.createDialogArea(parent);
        Label infoLabel = new Label(composite, 0);
        infoLabel.setLayoutData((Object)new GridData(768));
        infoLabel.setText("Copy/paste license text or load it from file");
        Group licenseGroup = UIUtils.createControlGroup((Composite)composite, (String)"License", (int)1, (int)1808, (int)0);
        this.licenseText = new Text((Composite)licenseGroup, 2562);
        GridData gd = new GridData(1808);
        gd.heightHint = this.licenseText.getLineHeight() * 6;
        gd.widthHint = this.licenseText.getLineHeight() * 30;
        this.licenseText.setLayoutData((Object)gd);
        Composite buttonsBar = UIUtils.createPlaceholder((Composite)licenseGroup, (int)2, (int)5);
        UIUtils.createPushButton((Composite)buttonsBar, (String)"Paste", (Image)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_PASTE")).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseImportDialog.this.copyLicenseFromClipboard();
            }
        });
        UIUtils.createPushButton((Composite)buttonsBar, (String)"Load", (Image)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE")).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseImportDialog.this.loadLicenseFromFile();
            }
        });
        return parent;
    }

    private void loadLicenseFromFile() {
        File file = DialogUtils.openFile((Shell)this.getShell(), (String[])new String[]{"*", "*.txt", "*.lic"});
        if (file != null) {
            try {
                String fileContents = IOUtils.toString((File)file, (String)"UTF-8");
                if (fileContents != null) {
                    this.licenseText.setText(fileContents);
                }
            }
            catch (IOException e) {
                DBUserInterface.getInstance().showError("Load license", "Error loading license from file", (Throwable)e);
            }
        }
    }

    private void copyLicenseFromClipboard() {
        Object textContents = new Clipboard(Display.getCurrent()).getContents((Transfer)TextTransfer.getInstance());
        if (textContents instanceof String) {
            this.licenseText.setText(textContents.toString());
        }
    }

    private boolean importLicenseFromText() {
        byte[] licenseData;
        int divPos;
        String licenseEncoded = this.licenseText.getText().trim();
        if (licenseEncoded.startsWith("DBeaver") && (divPos = licenseEncoded.indexOf("--")) != -1) {
            licenseEncoded = licenseEncoded.substring(divPos);
        }
        if (!licenseEncoded.contains("\n")) {
            divPos = licenseEncoded.indexOf("//");
            if (divPos != -1) {
                licenseEncoded = licenseEncoded.substring(divPos + "//".length());
            } else {
                DBUserInterface.getInstance().showError("Incorrect license text", "License text is incorrect.\nLicense text usually consists of several lines, it starts with -- characters and ends with ==.\nPlease recheck the license text. You can get correct license text on your profile page on the website.");
                return false;
            }
        }
        if (licenseEncoded.isEmpty()) {
            DBUserInterface.getInstance().showError("Empty license", "You have to fill (copy) license text");
            return false;
        }
        try {
            licenseData = LMUtils.readEncryptedString((Reader)new StringReader(licenseEncoded));
        }
        catch (IOException e) {
            DBUserInterface.getInstance().showError("Decode license", "Error decoding license text", (Throwable)e);
            return false;
        }
        try {
            LMLicense license = this.licenseManager.importLicense(this.product, licenseData);
            if (license.isSubscription()) {
                this.licenseManager.validateLicense(LicenseUIUtils.getClientId(), this.product, license);
            }
        }
        catch (LMException e) {
            log.error((Object)e);
            DBUserInterface.getInstance().showError("Bad license", "License corrupted or doesn't match product", (Throwable)e);
            return false;
        }
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Import", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && !this.importLicenseFromText()) {
            return;
        }
        super.buttonPressed(buttonId);
    }
}

