/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.core;

import com.dbeaver.lm.core.LicenseCheckResult;
import com.dbeaver.lm.internal.core.PublicServiceClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMLicenseStatus;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMSubscription;
import org.jkiss.lm.LMUtils;
import org.jkiss.utils.CommonUtils;

public class LMPublicAPI {
    public static final String BUNDLE_SYMBOLIC_NAME = "com.dbeaver.lm.core";
    private static final Log log = Log.getLog(LMPublicAPI.class);

    public static IStatus generateTrialLicense(IProgressMonitor iProgressMonitor, LMLicenseManager lMLicenseManager, String string, LMProduct lMProduct, String string2, String string3, String string4, String string5) {
        return LMPublicAPI.generateLicense(iProgressMonitor, lMLicenseManager, string, lMProduct, string2, string3, string4, string5);
    }

    public static LicenseCheckResult checkLicenseStatus(IProgressMonitor iProgressMonitor, String string, LMLicenseManager lMLicenseManager, LMLicense lMLicense, LMProduct lMProduct) {
        iProgressMonitor.beginTask("Check license status", 3);
        try {
            LMLicenseStatus lMLicenseStatus;
            BufferedReader bufferedReader;
            PublicServiceClient publicServiceClient = new PublicServiceClient(string, 4000, 4000);
            try {
                iProgressMonitor.subTask("Validate using public service");
                String string2 = publicServiceClient.checkLicenseStatus(lMLicense, lMProduct);
                if (CommonUtils.isEmpty((String)string2)) {
                    LicenseCheckResult licenseCheckResult = new LicenseCheckResult(Status.OK_STATUS, LMLicenseStatus.VALID);
                    return licenseCheckResult;
                }
                bufferedReader = new BufferedReader(new StringReader(string2));
            }
            catch (Exception exception) {
                LicenseCheckResult licenseCheckResult = new LicenseCheckResult(GeneralUtils.makeErrorStatus((String)"Error checking license status", (Throwable)exception), LMLicenseStatus.VALID);
                return licenseCheckResult;
            }
            String string3 = bufferedReader.readLine();
            iProgressMonitor.worked(1);
            int n = string3.indexOf(58);
            if (n == -1) {
                LicenseCheckResult licenseCheckResult = new LicenseCheckResult(GeneralUtils.makeErrorStatus((String)("Bad check status: " + string3)), LMLicenseStatus.INVALID);
                return licenseCheckResult;
            }
            String string4 = string3.substring(0, n).trim();
            String string5 = string3.substring(n + 1).trim();
            try {
                lMLicenseStatus = LMLicenseStatus.valueOf((String)string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.debug((Object)("Bad license status: [" + string4 + "]"));
                lMLicenseStatus = LMLicenseStatus.VALID;
            }
            LicenseCheckResult licenseCheckResult = new LicenseCheckResult(GeneralUtils.makeInfoStatus((String)string5), lMLicenseStatus);
            if (lMLicense.isSubscription()) {
                try {
                    byte[] byArray = LMUtils.readEncryptedString((Reader)bufferedReader);
                    LMSubscription lMSubscription = lMLicenseManager.readSubscriptionFromData(lMProduct, byArray);
                    licenseCheckResult.setSubscription(lMSubscription);
                }
                catch (IOException iOException) {
                    log.debug((Object)"Error reading subscription info", (Throwable)iOException);
                }
            }
            LicenseCheckResult licenseCheckResult2 = licenseCheckResult;
            return licenseCheckResult2;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private static IStatus generateLicense(IProgressMonitor iProgressMonitor, LMLicenseManager lMLicenseManager, String string, LMProduct lMProduct, String string2, String string3, String string4, String string5) {
        iProgressMonitor.beginTask("Generate trial license", 3);
        try {
            String string6;
            Object object;
            PublicServiceClient publicServiceClient = new PublicServiceClient(string);
            try {
                iProgressMonitor.subTask("Check license server");
                log.debug((Object)"Ping license server");
                object = publicServiceClient.ping();
                log.debug((Object)("Ping result: " + (String)object));
                iProgressMonitor.worked(1);
            }
            catch (Exception exception) {
                IStatus iStatus = GeneralUtils.makeErrorStatus((String)"Can't contact license service at dbeaver.com", (Throwable)exception);
                iProgressMonitor.done();
                return iStatus;
            }
            try {
                iProgressMonitor.subTask("Generate license");
                log.debug((Object)"Request trial license");
                string6 = publicServiceClient.generateTrialLicense(lMProduct, string2, string3, string4, string5);
                iProgressMonitor.worked(1);
            }
            catch (Exception exception) {
                IStatus iStatus = GeneralUtils.makeErrorStatus((String)("Can't generate trial license:\n" + exception.getMessage()));
                iProgressMonitor.done();
                return iStatus;
            }
            try {
                iProgressMonitor.subTask("Import license");
                object = LMUtils.readEncryptedString((Reader)new StringReader(string6));
                lMLicenseManager.importLicense(lMProduct, (byte[])object);
                iProgressMonitor.worked(1);
            }
            catch (Throwable throwable) {
                IStatus iStatus = GeneralUtils.makeErrorStatus((String)"Trial license corrupted or doesn't match the product", (Throwable)throwable);
                iProgressMonitor.done();
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            iProgressMonitor.done();
        }
    }
}

