/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor.panel;

import com.dbeaver.ee.vqb.VQBUtils;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryElements;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryExpression;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.utils.CommonUtils;

abstract class VQBPanelQueryCondition
extends VQBPanelQueryExpression<Expression> {
    private static final Log log = Log.getLog(VQBPanelQueryCondition.class);

    protected VQBPanelQueryCondition(VQBEditorPresentation vQBEditorPresentation) {
        super(vQBEditorPresentation);
    }

    @Override
    protected void fillColumns(ViewerColumnController<Object, Expression> viewerColumnController) {
        super.fillColumns(viewerColumnController);
        viewerColumnController.addColumn("Left Operand", "Left operand expression", 16384, true, false, expression -> {
            Expression expression2 = this.getItemExpression(expression);
            if (!VQBUtils.isCompoundExpression(expression2)) {
                if (expression2 instanceof BinaryExpression) {
                    return ((BinaryExpression)expression2).getLeftExpression().toString();
                }
                if (expression2 instanceof IsNullExpression) {
                    return ((IsNullExpression)expression2).getLeftExpression().toString();
                }
                if (expression2 instanceof InExpression) {
                    return ((InExpression)expression2).getLeftExpression().toString();
                }
            }
            return null;
        }, (EditingSupport)new ColumnEditingSupport());
        viewerColumnController.addColumn("Operation", "Operation", 16384, true, false, expression -> {
            Expression expression2 = this.getItemExpression(expression);
            if (!VQBUtils.isCompoundExpression(expression2)) {
                return this.getExpressionOperator(expression2);
            }
            return null;
        }, (EditingSupport)new OperationEditingSupport());
        viewerColumnController.addColumn("Right Operand", "Right operand expression", 16384, true, false, expression -> {
            Expression expression2 = this.getItemExpression(expression);
            if (expression2 instanceof BinaryExpression && !VQBUtils.isCompoundExpression(expression2)) {
                return ((BinaryExpression)expression2).getRightExpression().toString();
            }
            if (expression2 instanceof InExpression) {
                return ((InExpression)expression2).getRightItemsList().toString();
            }
            return null;
        }, (EditingSupport)new OperandEditingSupport());
    }

    @Override
    protected EditingSupport makeExpressionEditSupport() {
        return new ConditionExpressionEditingSupport();
    }

    @Override
    protected Expression getExpression(Expression expression) {
        return expression;
    }

    @Override
    protected void fillPanelContributions(IContributionManager iContributionManager) {
        super.fillPanelContributions(iContributionManager);
        iContributionManager.add((IAction)new Action("Add Column/Expression", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_ADD)){

            public void run() {
                PlainSelect plainSelect = VQBPanelQueryCondition.this.getPlainSelect();
                if (plainSelect != null) {
                    Expression expression = (Expression)VQBPanelQueryCondition.this.getSelectedElement();
                    Expression expression2 = (Expression)VQBPanelQueryCondition.this.getParentElement();
                    EqualsTo equalsTo = new EqualsTo();
                    equalsTo.setLeftExpression((Expression)new LongValue(1L));
                    equalsTo.setRightExpression((Expression)new LongValue(1L));
                    if (expression == null) {
                        plainSelect.setWhere((Expression)equalsTo);
                    } else if (expression2 == null) {
                        AndExpression andExpression = new AndExpression(expression, (Expression)equalsTo);
                        plainSelect.setWhere((Expression)andExpression);
                    } else if (expression2 instanceof BinaryExpression) {
                        ((BinaryExpression)expression2).setRightExpression((Expression)new AndExpression(((BinaryExpression)expression2).getRightExpression(), (Expression)equalsTo));
                    } else {
                        DBUserInterface.getInstance().showError("Add condition error", "Cannot add child condition to '" + expression2 + "'");
                        return;
                    }
                    VQBPanelQueryCondition.this.addNewElement(equalsTo, 1);
                }
            }
        });
        iContributionManager.add((IAction)new Action("Remove", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_DELETE)){

            public void run() {
                final PlainSelect plainSelect = VQBPanelQueryCondition.this.getPlainSelect();
                final Expression expression = (Expression)VQBPanelQueryCondition.this.getSelectedElement();
                Expression expression2 = (Expression)VQBPanelQueryCondition.this.getParentElement();
                if (expression != null) {
                    if (expression2 == null) {
                        plainSelect.setWhere(null);
                    } else if (expression2 instanceof BinaryExpression) {
                        expression2.accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

                            public void visitBinaryExpression(BinaryExpression binaryExpression) {
                                if (binaryExpression.getRightExpression() == expression) {
                                    if (VQBUtils.isCompoundExpression(expression)) {
                                        if (expression instanceof BinaryExpression) {
                                            binaryExpression.setRightExpression(((BinaryExpression)expression).getRightExpression());
                                        } else if (expression instanceof Parenthesis) {
                                            binaryExpression.setRightExpression(((Parenthesis)expression).getExpression());
                                        }
                                    } else if (VQBUtils.isCompoundExpression((Expression)binaryExpression)) {
                                        VQBUtils.replaceCompoundWithSingle(plainSelect, binaryExpression, binaryExpression.getLeftExpression());
                                    }
                                } else if (binaryExpression.getLeftExpression() == expression) {
                                    if (VQBUtils.isCompoundExpression(expression)) {
                                        if (expression instanceof BinaryExpression) {
                                            binaryExpression.setLeftExpression(((BinaryExpression)expression).getLeftExpression());
                                        } else if (expression instanceof Parenthesis) {
                                            binaryExpression.setLeftExpression(((Parenthesis)expression).getExpression());
                                        }
                                    } else if (VQBUtils.isCompoundExpression((Expression)binaryExpression)) {
                                        VQBUtils.replaceCompoundWithSingle(plainSelect, binaryExpression, binaryExpression.getRightExpression());
                                    }
                                } else {
                                    super.visitBinaryExpression(binaryExpression);
                                }
                            }
                        });
                        VQBPanelQueryCondition.this.refreshDiagramAndStatement();
                    } else {
                        DBUserInterface.getInstance().showError("Remove condition error", "Cannot remove child condition from '" + expression2 + "'");
                    }
                }
            }

            public boolean isEnabled() {
                return VQBPanelQueryCondition.this.getSelectedElement() != null;
            }
        });
    }

    private boolean updateConditionExpression(PlainSelect plainSelect, Expression expression, Expression expression2) {
        if (plainSelect.getWhere() == expression) {
            plainSelect.setWhere(expression2);
            return true;
        }
        return this.updateConditionExpression(plainSelect.getWhere(), expression, expression2);
    }

    private boolean updateConditionExpression(Expression expression, final Expression expression2, final Expression expression3) {
        if (expression2.toString().equals(expression3.toString())) {
            return true;
        }
        if (expression == null) {
            this.updateExpression(this.getPlainSelect(), expression3);
            return true;
        }
        final boolean[] blArray = new boolean[1];
        expression.accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

            public void visitBinaryExpression(BinaryExpression binaryExpression) {
                super.visitBinaryExpression(binaryExpression);
                if (binaryExpression.getLeftExpression() == expression2) {
                    binaryExpression.setLeftExpression(expression3);
                    blArray[0] = true;
                } else if (binaryExpression.getRightExpression() == expression2) {
                    binaryExpression.setRightExpression(expression3);
                    blArray[0] = true;
                }
            }
        });
        return blArray[0];
    }

    private String getExpressionOperator(Expression expression) {
        if (expression instanceof BinaryExpression) {
            return ((BinaryExpression)expression).getStringExpression();
        }
        if (expression instanceof IsNullExpression) {
            IsNullExpression isNullExpression = (IsNullExpression)expression;
            return isNullExpression.isNot() ? (isNullExpression.isUseIsNull() ? "NOT ISNULL" : "IS NOT NULL") : (isNullExpression.isUseIsNull() ? "ISNULL" : "IS NULL");
        }
        if (expression instanceof InExpression) {
            return "IN";
        }
        return null;
    }

    private Expression removeSubExpression(Expression expression, Expression expression2) {
        return expression;
    }

    protected abstract void updateExpression(PlainSelect var1, Expression var2);

    private class ColumnEditingSupport
    extends ConditionEditingSupport {
        private ColumnEditingSupport() {
        }

        @Override
        protected List<String> getAvailableItems() {
            return VQBUtils.getAttributeNames(VQBPanelQueryCondition.this.presentation.getVQBEditor().getDiagram(), false);
        }

        protected Object getValue(Object object) {
            Expression expression = VQBPanelQueryCondition.this.getItemExpression(object);
            if (expression instanceof BinaryExpression) {
                return ((BinaryExpression)expression).getLeftExpression().toString();
            }
            if (expression instanceof IsNullExpression) {
                return ((IsNullExpression)expression).getLeftExpression().toString();
            }
            if (expression instanceof InExpression) {
                return ((InExpression)expression).getLeftExpression().toString();
            }
            return null;
        }

        protected void setValue(Object object, Object object2) {
            Expression expression = VQBPanelQueryCondition.this.getItemExpression(object);
            String string = CommonUtils.toString((Object)object2);
            try {
                Expression expression2;
                Expression expression3 = expression2 = CommonUtils.isEmpty((String)string) ? null : CCJSqlParserUtil.parseExpression((String)string);
                if (expression2 != null) {
                    if (expression instanceof BinaryExpression) {
                        if (CommonUtils.equalObjects((Object)CommonUtils.toString((Object)expression2), (Object)CommonUtils.toString((Object)((BinaryExpression)expression).getLeftExpression()))) {
                            return;
                        }
                        ((BinaryExpression)expression).setLeftExpression(expression2);
                    } else if (expression instanceof IsNullExpression) {
                        ((IsNullExpression)expression).setLeftExpression(expression2);
                    } else if (expression instanceof InExpression) {
                        ((InExpression)expression).setLeftExpression(expression2);
                    } else {
                        throw new DBException("Expression " + expression2 + " is not supported");
                    }
                    VQBPanelQueryCondition.this.refreshDiagramAndStatement();
                }
            }
            catch (Exception exception) {
                DBUserInterface.getInstance().showError("Parse error", "Error updating left expression", (Throwable)exception);
                log.debug((Object)exception);
            }
        }
    }

    private abstract class ConditionEditingSupport
    extends EditingSupport {
        public ConditionEditingSupport() {
            super((ColumnViewer)VQBPanelQueryCondition.this.elementViewer);
        }

        protected CellEditor getCellEditor(Object object) {
            CustomComboBoxCellEditor customComboBoxCellEditor = new CustomComboBoxCellEditor((ColumnViewer)VQBPanelQueryCondition.this.elementViewer, (Composite)VQBPanelQueryCondition.this.elementViewer.getTree(), new String[0], 4);
            List<String> list = this.getAvailableItems();
            customComboBoxCellEditor.setItems(list.toArray(new String[list.size()]));
            UIUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)VQBPanelQueryCondition.this.presentation.getSQLEditor().getSite(), (Control)customComboBoxCellEditor.getControl());
            return customComboBoxCellEditor;
        }

        protected boolean canEdit(Object object) {
            Expression expression = VQBPanelQueryCondition.this.getItemExpression(object);
            return !VQBUtils.isCompoundExpression(expression);
        }

        protected abstract List<String> getAvailableItems();
    }

    private class ConditionExpressionEditingSupport
    extends VQBPanelQueryElements.ExpressionEditingSupport<Expression> {
        private ConditionExpressionEditingSupport() {
        }

        @Override
        protected boolean canEdit(Object object) {
            return false;
        }

        @Override
        protected Expression parseNewExpression(String string) throws JSQLParserException {
            return CommonUtils.isEmpty((String)string) ? null : CCJSqlParserUtil.parseCondExpression((String)string);
        }

        @Override
        protected boolean updateElementExpression(Expression expression, Expression expression2, Expression expression3) {
            return VQBPanelQueryCondition.this.updateConditionExpression(expression, expression2, expression3);
        }
    }

    private class OperandEditingSupport
    extends ConditionEditingSupport {
        private OperandEditingSupport() {
        }

        @Override
        protected List<String> getAvailableItems() {
            return VQBUtils.getAttributeNames(VQBPanelQueryCondition.this.presentation.getVQBEditor().getDiagram(), false);
        }

        protected Object getValue(Object object) {
            Expression expression = VQBPanelQueryCondition.this.getItemExpression(object);
            if (expression instanceof BinaryExpression) {
                return ((BinaryExpression)expression).getRightExpression().toString();
            }
            if (expression instanceof InExpression) {
                return ((InExpression)expression).getRightItemsList().toString();
            }
            return null;
        }

        protected void setValue(Object object, Object object2) {
            Expression expression = VQBPanelQueryCondition.this.getItemExpression(object);
            try {
                String string = CommonUtils.toString((Object)object2);
                if (expression instanceof InExpression) {
                    String string2 = String.valueOf(((InExpression)expression).getLeftExpression().toString()) + " IN " + string;
                    Expression expression2 = CCJSqlParserUtil.parseCondExpression((String)string2, (boolean)false);
                    ((InExpression)expression).setRightItemsList(((InExpression)expression2).getRightItemsList());
                } else {
                    Expression expression3 = CCJSqlParserUtil.parseExpression((String)string);
                    if (expression instanceof BinaryExpression) {
                        if (CommonUtils.equalObjects((Object)CommonUtils.toString((Object)expression3), (Object)CommonUtils.toString((Object)((BinaryExpression)expression).getRightExpression()))) {
                            return;
                        }
                        ((BinaryExpression)expression).setRightExpression(expression3);
                    } else {
                        throw new DBException("Expression " + expression3 + " is not supported");
                    }
                }
                VQBPanelQueryCondition.this.refreshDiagramAndStatement();
            }
            catch (Exception exception) {
                DBUserInterface.getInstance().showError("Parse error", "Error updating right expression", (Throwable)exception);
                log.debug((Object)exception);
            }
        }
    }

    private class OperationEditingSupport
    extends ConditionEditingSupport {
        private OperationEditingSupport() {
        }

        @Override
        protected List<String> getAvailableItems() {
            ArrayList<String> arrayList = new ArrayList<String>();
            DBCLogicalOperator[] dBCLogicalOperatorArray = DBCLogicalOperator.values();
            int n = dBCLogicalOperatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBCLogicalOperator dBCLogicalOperator = dBCLogicalOperatorArray[n2];
                arrayList.add(dBCLogicalOperator.getStringValue());
                ++n2;
            }
            return arrayList;
        }

        protected Object getValue(Object object) {
            return VQBPanelQueryCondition.this.getExpressionOperator((Expression)object);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void setValue(Object object, Object object2) {
            Expression expression = VQBPanelQueryCondition.this.getItemExpression(object);
            String string = CommonUtils.toString((Object)object2);
            try {
                String string2;
                if ("in".equalsIgnoreCase(string) || "not in".equalsIgnoreCase(string)) {
                    string2 = expression instanceof BinaryExpression ? String.valueOf(((BinaryExpression)expression).getLeftExpression().toString()) + " " + string + " (" + ((BinaryExpression)expression).getRightExpression().toString() + ")" : (expression instanceof IsNullExpression ? String.valueOf(((IsNullExpression)expression).getLeftExpression().toString()) + " " + string + " (?)" : expression.toString());
                } else if ("is null".equalsIgnoreCase(string) || "is not null".equalsIgnoreCase(string)) {
                    if (expression instanceof BinaryExpression) {
                        string2 = String.valueOf(((BinaryExpression)expression).getLeftExpression().toString()) + " " + string;
                    } else if (expression instanceof IsNullExpression) {
                        string2 = String.valueOf(((IsNullExpression)expression).getLeftExpression().toString()) + " " + string;
                    } else {
                        if (!(expression instanceof InExpression)) throw new DBException("Unsupported expression type " + expression);
                        string2 = String.valueOf(((InExpression)expression).getLeftExpression().toString()) + " " + string;
                    }
                } else if (expression instanceof BinaryExpression) {
                    string2 = String.valueOf(((BinaryExpression)expression).getLeftExpression().toString()) + " " + string + " " + ((BinaryExpression)expression).getRightExpression().toString();
                } else if (expression instanceof IsNullExpression) {
                    string2 = String.valueOf(((IsNullExpression)expression).getLeftExpression().toString()) + " " + string + " 1";
                } else {
                    if (!(expression instanceof InExpression)) throw new DBException("Unsupported expression type " + expression);
                    string2 = String.valueOf(((InExpression)expression).getLeftExpression().toString()) + " " + string + " " + ((InExpression)expression).getRightItemsList().toString();
                }
                Expression expression2 = CCJSqlParserUtil.parseCondExpression((String)string2, (boolean)false);
                if (!(expression2 instanceof BinaryExpression || expression2 instanceof IsNullExpression || expression2 instanceof InExpression)) {
                    throw new DBException("Operator " + string + " is not supported");
                }
                if (!VQBPanelQueryCondition.this.updateConditionExpression(VQBPanelQueryCondition.this.getPlainSelect(), expression, expression2)) {
                    throw new DBException("Can't replace condition [" + expression + "] with [" + expression2 + "]");
                }
                VQBPanelQueryCondition.this.refreshDiagramAndStatement();
                return;
            }
            catch (Exception exception) {
                DBUserInterface.getInstance().showError("Parse error", "Error updating expression operation", (Throwable)exception);
                log.debug((Object)exception);
            }
        }
    }
}

