/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb;

import com.dbeaver.ee.vqb.ui.builder.VQBQueryInfo;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPart;
import com.dbeaver.ee.vqb.ui.model.ERDJoin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.FromItemVisitorAdapter;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import org.eclipse.gef.EditPart;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.erd.editor.ERDGraphicalViewer;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDContainer;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.utils.CommonUtils;

public class VQBUtils {
    public static VQBEditorPart getQueryBuilderEditor(EditPart editPart) {
        ERDGraphicalViewer eRDGraphicalViewer = (ERDGraphicalViewer)editPart.getViewer();
        return (VQBEditorPart)eRDGraphicalViewer.getEditor();
    }

    public static VQBQueryInfo getQueryInfo(EditPart editPart) {
        return VQBUtils.getQueryBuilderEditor(editPart).getQueryInfo();
    }

    public static EntityDiagram getDiagram(EditPart editPart) {
        ERDGraphicalViewer eRDGraphicalViewer = (ERDGraphicalViewer)editPart.getViewer();
        return eRDGraphicalViewer.getEditor().getDiagram();
    }

    public static Expression unwrapExpression(Expression expression) {
        return expression;
    }

    public static void collectNestedConditions(VQBQueryInfo vQBQueryInfo, List<Expression> list, Expression expression, Expression expression2) {
        if ((expression2 = VQBUtils.unwrapExpression(expression2)) instanceof BinaryExpression && expression2.getClass() == expression.getClass()) {
            VQBUtils.collectNestedConditions(vQBQueryInfo, list, expression2, ((BinaryExpression)expression2).getLeftExpression());
            VQBUtils.collectNestedConditions(vQBQueryInfo, list, expression2, ((BinaryExpression)expression2).getRightExpression());
        } else if (!vQBQueryInfo.isConditionExcluded(expression2)) {
            list.add(expression2);
        }
    }

    public static boolean isCompoundExpression(Expression expression) {
        return expression instanceof AndExpression || expression instanceof OrExpression || expression instanceof Parenthesis;
    }

    public static Table getTableFromEntity(ERDEntity eRDEntity) {
        FromItem fromItem = (FromItem)eRDEntity.getUserData();
        return fromItem instanceof Table ? (Table)fromItem : null;
    }

    @NotNull
    public static List<Join> getQueryJoins(PlainSelect plainSelect) {
        ArrayList arrayList = plainSelect.getJoins();
        if (arrayList == null) {
            arrayList = new ArrayList();
            plainSelect.setJoins(arrayList);
        }
        return arrayList;
    }

    public static boolean isEntityJoin(Join join, ERDEntity eRDEntity) {
        return join.getRightItem() instanceof Table && VQBUtils.equalTables((Table)join.getRightItem(), eRDEntity);
    }

    public static boolean equalTables(Table table, ERDEntity eRDEntity) {
        String string = DBUtils.getUnQuotedIdentifier((DBPDataSource)((DBSEntity)eRDEntity.getObject()).getDataSource(), (String)table.getName());
        if (table.getAlias() != null && !CommonUtils.isEmpty((String)eRDEntity.getAlias())) {
            return CommonUtils.equalObjects((Object)string, (Object)eRDEntity.getName()) && CommonUtils.equalObjects((Object)table.getAlias().getName(), (Object)eRDEntity.getAlias());
        }
        DBSEntity dBSEntity = (DBSEntity)eRDEntity.getObject();
        DBSCatalog dBSCatalog = (DBSCatalog)DBUtils.getParentOfType(DBSCatalog.class, (DBSObject)dBSEntity);
        DBSSchema dBSSchema = (DBSSchema)DBUtils.getParentOfType(DBSSchema.class, (DBSObject)dBSEntity);
        if (dBSCatalog != null && table.getDatabase() != null && !CommonUtils.isEmpty((String)table.getDatabase().getDatabaseName()) && !CommonUtils.equalObjects((Object)dBSCatalog.getName(), (Object)table.getDatabase().getDatabaseName())) {
            return false;
        }
        if (dBSSchema != null && table.getSchemaName() != null && !CommonUtils.equalObjects((Object)dBSSchema.getName(), (Object)table.getSchemaName())) {
            return false;
        }
        String string2 = table.getAlias() == null ? null : table.getAlias().getName();
        String string3 = eRDEntity.getAlias();
        return CommonUtils.equalObjects((Object)string, (Object)dBSEntity.getName()) || CommonUtils.equalObjects((Object)string, (Object)string3) || CommonUtils.equalObjects((Object)dBSEntity.getName(), (Object)string2);
    }

    public static boolean equalTables(Table table, Table table2) {
        String string;
        if (table.getAlias() != null && table2.getAlias() != null) {
            return CommonUtils.equalObjects((Object)table.getAlias().getName(), (Object)table2.getAlias().getName());
        }
        if (!CommonUtils.equalObjects((Object)(table.getDatabase() == null ? null : table.getDatabase().getDatabaseName()), table2.getDatabase() == null ? null : table2.getDatabase().getDatabaseName())) {
            return false;
        }
        if (!CommonUtils.equalObjects((Object)table.getSchemaName(), (Object)table2.getSchemaName())) {
            return false;
        }
        String string2 = table.getAlias() == null ? null : table.getAlias().getName();
        String string3 = string = table2.getAlias() == null ? null : table2.getAlias().getName();
        return CommonUtils.equalObjects((Object)table.getName(), (Object)table2.getName()) || CommonUtils.equalObjects((Object)table.getName(), (Object)string) || CommonUtils.equalObjects((Object)table2.getName(), (Object)string2);
    }

    public static List<SelectItem> getOrCreateSelectItems(PlainSelect plainSelect) {
        ArrayList arrayList = plainSelect.getSelectItems();
        if (arrayList == null) {
            arrayList = new ArrayList();
            plainSelect.setSelectItems(arrayList);
        }
        return arrayList;
    }

    public static void handleEntityChange(ERDContainer eRDContainer, VQBQueryInfo vQBQueryInfo, ERDEntity eRDEntity, boolean bl) {
        PlainSelect plainSelect = vQBQueryInfo.getPlainSelect();
        if (plainSelect != null) {
            if (!bl) {
                List<SelectItem> list;
                boolean bl2;
                boolean bl3 = bl2 = plainSelect.getFromItem() instanceof Table && VQBUtils.equalTables((Table)plainSelect.getFromItem(), eRDEntity);
                if (bl2 && (list = VQBUtils.getOrCreateSelectItems(plainSelect)).isEmpty()) {
                    list.add((SelectItem)new AllColumns());
                }
                if (!bl2 && CommonUtils.isEmpty((Collection)eRDEntity.getReferences())) {
                    list = VQBUtils.getQueryJoins(plainSelect);
                    Join join = new Join();
                    join.setRightItem((FromItem)VQBUtils.getTableFromEntity(eRDEntity));
                    list.add((SelectItem)join);
                }
            } else {
                VQBUtils.removeTableReferences(eRDContainer, plainSelect, eRDEntity);
            }
        }
    }

    public static void updateTableAlias(VQBQueryInfo vQBQueryInfo, final Table table, final Alias alias) {
        vQBQueryInfo.getParsedQuery().getSelectBody().accept((SelectVisitor)new SelectVisitorAdapter(){

            public void visit(PlainSelect plainSelect) {
                if (plainSelect.getFromItem() != null) {
                    plainSelect.getFromItem().accept((FromItemVisitor)new FromItemVisitorAdapter(){

                        public void visit(Table table2) {
                            if (table2 != table && VQBUtils.equalTables(table2, table)) {
                                table2.setAlias(alias);
                            }
                        }
                    });
                }
                if (plainSelect.getJoins() != null) {
                    for (Join join : plainSelect.getJoins()) {
                        if (join.getOnExpression() == null) continue;
                        VQBUtils.updateTableAlias(join.getOnExpression(), table, alias);
                    }
                }
                if (plainSelect.getSelectItems() != null) {
                    for (Join join : plainSelect.getSelectItems()) {
                        if (!(join instanceof SelectExpressionItem)) continue;
                        VQBUtils.updateTableAlias(((SelectExpressionItem)join).getExpression(), table, alias);
                    }
                }
                if (plainSelect.getWhere() != null) {
                    VQBUtils.updateTableAlias(plainSelect.getWhere(), table, alias);
                }
                if (plainSelect.getHaving() != null) {
                    VQBUtils.updateTableAlias(plainSelect.getHaving(), table, alias);
                }
                if (plainSelect.getGroupByColumnReferences() != null) {
                    for (Join join : plainSelect.getGroupByColumnReferences()) {
                        VQBUtils.updateTableAlias((Expression)join, table, alias);
                    }
                }
                if (plainSelect.getOrderByElements() != null) {
                    for (Join join : plainSelect.getOrderByElements()) {
                        if (join.getExpression() == null) continue;
                        VQBUtils.updateTableAlias(join.getExpression(), table, alias);
                    }
                }
            }
        });
        table.setAlias(alias);
    }

    public static void updateTableAlias(Expression expression, final Table table, Alias alias) {
        expression.accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

            public void visit(Column column) {
                if (column.getTable() != table && VQBUtils.equalTables(column.getTable(), table)) {
                    column.setTable(table);
                }
            }
        });
    }

    public static void removeTableReferences(ERDContainer eRDContainer, PlainSelect plainSelect, ERDEntity eRDEntity) {
        List list;
        Expression expression;
        Join join2;
        Object object;
        List list2 = plainSelect.getJoins();
        if (list2 != null) {
            object = list2.iterator();
            while (object.hasNext()) {
                join2 = (Join)object.next();
                if (VQBUtils.isEntityJoin(join2, eRDEntity)) {
                    object.remove();
                    continue;
                }
                join2.setOnExpression(VQBUtils.removeTableReferences(join2.getOnExpression(), eRDEntity));
            }
        }
        if (plainSelect.getFromItem() instanceof Table && VQBUtils.equalTables((Table)plainSelect.getFromItem(), eRDEntity)) {
            if (CommonUtils.isEmpty((Collection)list2)) {
                plainSelect.setFromItem(null);
            } else {
                object = (Join)list2.remove(0);
                plainSelect.setFromItem(object.getRightItem());
                for (Join join2 : eRDContainer.getEntities()) {
                    if (join2.getUserData() != object.getRightItem()) continue;
                    join2.setPrimary(true);
                    join2.firePropertyChange("NAME", null, (Object)join2.getName());
                }
            }
        }
        if (plainSelect.getSelectItems() != null) {
            object = plainSelect.getSelectItems().iterator();
            while (object.hasNext()) {
                join2 = (SelectItem)object.next();
                if (!(join2 instanceof SelectExpressionItem)) continue;
                expression = VQBUtils.removeTableReferences(((SelectExpressionItem)join2).getExpression(), eRDEntity);
                if (expression == null) {
                    object.remove();
                    continue;
                }
                ((SelectExpressionItem)join2).setExpression(expression);
            }
        }
        if (plainSelect.getWhere() != null) {
            plainSelect.setWhere(VQBUtils.removeTableReferences(plainSelect.getWhere(), eRDEntity));
        }
        if (plainSelect.getHaving() != null) {
            plainSelect.setHaving(VQBUtils.removeTableReferences(plainSelect.getHaving(), eRDEntity));
        }
        if ((object = plainSelect.getGroupByColumnReferences()) != null) {
            int n = 0;
            while (n < object.size()) {
                expression = VQBUtils.removeTableReferences((Expression)object.get(n), eRDEntity);
                if (expression == null) {
                    object.remove(n);
                    continue;
                }
                object.set(n, expression);
                ++n;
            }
        }
        if ((list = plainSelect.getOrderByElements()) != null) {
            int n = 0;
            while (n < list.size()) {
                OrderByElement orderByElement = (OrderByElement)list.get(n);
                Expression expression2 = VQBUtils.removeTableReferences(orderByElement.getExpression(), eRDEntity);
                if (expression2 == null) {
                    list.remove(n);
                    continue;
                }
                orderByElement.setExpression(expression2);
                ++n;
            }
        }
    }

    public static Expression removeTableReferences(Expression expression, ERDEntity eRDEntity) {
        ComparisonOperator comparisonOperator;
        if (expression instanceof ComparisonOperator && ((comparisonOperator = (ComparisonOperator)expression).getLeftExpression() instanceof Column && VQBUtils.equalTables(((Column)comparisonOperator.getLeftExpression()).getTable(), eRDEntity) || comparisonOperator.getRightExpression() instanceof Column && VQBUtils.equalTables(((Column)comparisonOperator.getRightExpression()).getTable(), eRDEntity))) {
            return null;
        }
        if (expression instanceof BinaryExpression) {
            comparisonOperator = VQBUtils.removeTableReferences(((BinaryExpression)expression).getLeftExpression(), eRDEntity);
            Expression expression2 = VQBUtils.removeTableReferences(((BinaryExpression)expression).getRightExpression(), eRDEntity);
            if (comparisonOperator == null && expression2 == null) {
                return null;
            }
            if (comparisonOperator == null) {
                return expression2;
            }
            if (expression2 == null) {
                return comparisonOperator;
            }
        }
        if (expression instanceof Column && VQBUtils.equalTables(((Column)expression).getTable(), eRDEntity)) {
            return null;
        }
        return expression;
    }

    public static Join findEntityJoin(EntityDiagram entityDiagram, PlainSelect plainSelect, ERDEntity eRDEntity, ERDEntity eRDEntity2) {
        if (plainSelect.getJoins() == null) {
            return null;
        }
        for (Join join : plainSelect.getJoins()) {
            boolean bl;
            if (!(join.getRightItem() instanceof Table)) continue;
            boolean bl2 = bl = eRDEntity != null && VQBUtils.equalTables((Table)join.getRightItem(), eRDEntity);
            if (!bl && (eRDEntity2 == null || !VQBUtils.equalTables((Table)join.getRightItem(), eRDEntity2))) continue;
            if (join.getOnExpression() == null) {
                return join;
            }
            if (!(bl ? VQBUtils.containsTableReferences(join.getOnExpression(), eRDEntity2) : VQBUtils.containsTableReferences(join.getOnExpression(), eRDEntity))) continue;
            return join;
        }
        return null;
    }

    public static boolean containsTableReferences(Expression expression, ERDEntity eRDEntity) {
        ComparisonOperator comparisonOperator;
        return expression instanceof ComparisonOperator ? (comparisonOperator = (ComparisonOperator)expression).getLeftExpression() instanceof Column && VQBUtils.equalTables(((Column)comparisonOperator.getLeftExpression()).getTable(), eRDEntity) || comparisonOperator.getRightExpression() instanceof Column && VQBUtils.equalTables(((Column)comparisonOperator.getRightExpression()).getTable(), eRDEntity) : expression instanceof BinaryExpression && (VQBUtils.containsTableReferences(((BinaryExpression)expression).getLeftExpression(), eRDEntity) || VQBUtils.containsTableReferences(((BinaryExpression)expression).getRightExpression(), eRDEntity));
    }

    public static ERDJoin findERDJoin(EntityDiagram entityDiagram, Join join) {
        for (ERDEntity eRDEntity : entityDiagram.getEntities()) {
            for (ERDAssociation eRDAssociation : CommonUtils.safeList((List)eRDEntity.getAssociations())) {
                if (eRDAssociation.getUserData() != join || !(eRDAssociation instanceof ERDJoin)) continue;
                return (ERDJoin)eRDAssociation;
            }
            for (ERDAssociation eRDAssociation : CommonUtils.safeList((List)eRDEntity.getReferences())) {
                if (eRDAssociation.getUserData() != join || !(eRDAssociation instanceof ERDJoin)) continue;
                return (ERDJoin)eRDAssociation;
            }
        }
        return null;
    }

    public static List<String> getAttributeNames(EntityDiagram entityDiagram, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ERDEntity eRDEntity : entityDiagram.getEntities()) {
            String string;
            String string2 = string = !CommonUtils.isEmpty((String)eRDEntity.getAlias()) ? eRDEntity.getAlias() : DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)eRDEntity.getObject()));
            if (bl) {
                arrayList.add(String.valueOf(string) + ".*");
            }
            for (ERDEntityAttribute eRDEntityAttribute : eRDEntity.getAttributes()) {
                arrayList.add(String.valueOf(string) + "." + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)eRDEntityAttribute.getObject())));
            }
        }
        return arrayList;
    }

    public static Statement createEmptySelectStatement() {
        Select select = new Select();
        select.setSelectBody((SelectBody)new PlainSelect());
        Select select2 = select;
        return select2;
    }

    public static void replaceCompoundWithSingle(PlainSelect plainSelect, final BinaryExpression binaryExpression, final Expression expression) {
        if (plainSelect.getWhere() == binaryExpression) {
            plainSelect.setWhere(expression);
        } else {
            plainSelect.getWhere().accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

                public void visitBinaryExpression(BinaryExpression binaryExpression2) {
                    if (binaryExpression2.getRightExpression() == binaryExpression) {
                        binaryExpression2.setRightExpression(expression);
                    } else if (binaryExpression2.getLeftExpression() == binaryExpression) {
                        binaryExpression2.setLeftExpression(expression);
                    } else {
                        super.visitBinaryExpression(binaryExpression2);
                    }
                }
            });
        }
    }

    public static Expression makeColumnExpression(ERDEntity eRDEntity, ERDEntityAttribute eRDEntityAttribute) {
        Column column = new Column(DBUtils.getQuotedIdentifier((DBPNamedObject)eRDEntityAttribute));
        Table table = new Table(DBUtils.getQuotedIdentifier((DBPNamedObject)eRDEntity));
        if (!CommonUtils.isEmpty((String)eRDEntity.getAlias())) {
            table.setAlias(new Alias(eRDEntity.getAlias()));
        }
        if (((DBSEntity)eRDEntity.getObject()).getParentObject() instanceof DBSSchema) {
            table.setSchemaName(DBUtils.getQuotedIdentifier((DBSObject)((DBSEntity)eRDEntity.getObject()).getParentObject()));
        }
        column.setTable(table);
        return column;
    }
}

