/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor.panel;

import com.dbeaver.ee.vqb.VQBUtils;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryElements;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.utils.CommonUtils;

class VQBPanelQuerySelectItems
extends VQBPanelQueryElements<SelectItem> {
    private static final Log log = Log.getLog(VQBPanelQuerySelectItems.class);

    protected VQBPanelQuerySelectItems(VQBEditorPresentation vQBEditorPresentation) {
        super(vQBEditorPresentation);
    }

    @Override
    protected void loadElements() {
        PlainSelect plainSelect = this.getPlainSelect();
        if (plainSelect != null) {
            this.elementViewer.setInput((Object)plainSelect.getSelectItems());
        } else {
            this.elementViewer.setInput(new ArrayList(0));
        }
    }

    private void replaceSelectItem(SelectItem selectItem, SelectItem selectItem2) {
        PlainSelect plainSelect = this.getPlainSelect();
        if (plainSelect != null) {
            List list = plainSelect.getSelectItems();
            int n = list.indexOf(selectItem);
            if (n >= 0) {
                list.set(n, selectItem2);
            } else {
                log.error((Object)("Can't find old select item [" + selectItem + "]"));
            }
        }
    }

    @Override
    protected void fillColumns(ViewerColumnController<Object, SelectItem> viewerColumnController) {
        viewerColumnController.addColumn("#", "Select item position", 16384, true, true, selectItem -> {
            PlainSelect plainSelect = this.getPlainSelect();
            if (plainSelect != null) {
                return String.valueOf(plainSelect.getSelectItems().indexOf(selectItem) + 1);
            }
            return null;
        }, null);
        VQBPanelQueryElements.ExpressionEditingSupport<SelectItem> expressionEditingSupport = new VQBPanelQueryElements.ExpressionEditingSupport<SelectItem>((VQBPanelQueryElements)this){

            @Override
            protected CellEditor getCellEditor(Object object) {
                CustomComboBoxCellEditor customComboBoxCellEditor = new CustomComboBoxCellEditor((ColumnViewer)VQBPanelQuerySelectItems.this.elementViewer, (Composite)VQBPanelQuerySelectItems.this.elementViewer.getTree(), new String[0], 4);
                List<String> list = VQBUtils.getAttributeNames(VQBPanelQuerySelectItems.this.presentation.getVQBEditor().getDiagram(), true);
                list.add("*");
                customComboBoxCellEditor.setItems(list.toArray(new String[list.size()]));
                UIUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)VQBPanelQuerySelectItems.this.presentation.getSQLEditor().getSite(), (Control)customComboBoxCellEditor.getControl());
                return customComboBoxCellEditor;
            }

            @Override
            protected boolean setValue(SelectItem selectItem, String string) {
                if (string.equals("*")) {
                    VQBPanelQuerySelectItems.this.replaceSelectItem(selectItem, (SelectItem)new AllColumns());
                    return true;
                }
                if (string.endsWith(".*")) {
                    VQBPanelQuerySelectItems.this.replaceSelectItem(selectItem, (SelectItem)new AllTableColumns(new Table(string.substring(0, string.length() - 2))));
                    return true;
                }
                return super.setValue(selectItem, string);
            }

            @Override
            protected String convertExpressionToString(SelectItem selectItem) {
                if (selectItem instanceof SelectExpressionItem) {
                    return ((SelectExpressionItem)selectItem).getExpression().toString();
                }
                return super.convertExpressionToString(selectItem);
            }

            @Override
            protected boolean updateElementExpression(SelectItem selectItem, SelectItem selectItem2, Expression expression) {
                SelectExpressionItem selectExpressionItem = new SelectExpressionItem(expression);
                if (selectItem2 instanceof SelectExpressionItem) {
                    selectExpressionItem.setAlias(((SelectExpressionItem)selectItem2).getAlias());
                }
                VQBPanelQuerySelectItems.this.replaceSelectItem(selectItem2, (SelectItem)selectExpressionItem);
                return true;
            }
        };
        viewerColumnController.addColumn("Column or Expression", "Expression", 16384, true, true, selectItem -> {
            if (selectItem instanceof SelectExpressionItem) {
                Expression expression = ((SelectExpressionItem)selectItem).getExpression();
                return expression == null ? null : expression.toString();
            }
            return selectItem.toString();
        }, (EditingSupport)expressionEditingSupport);
        VQBPanelQueryElements.TextEditingSupport<SelectItem> textEditingSupport = new VQBPanelQueryElements.TextEditingSupport<SelectItem>((VQBPanelQueryElements)this){

            @Override
            protected String convertExpressionToString(SelectItem selectItem) {
                if (selectItem instanceof SelectExpressionItem) {
                    Alias alias = ((SelectExpressionItem)selectItem).getAlias();
                    return alias == null ? "" : alias.getName();
                }
                return "";
            }

            @Override
            protected void updateElementText(SelectItem selectItem, String string) {
                if (selectItem instanceof SelectExpressionItem) {
                    if (CommonUtils.isEmpty((String)string)) {
                        ((SelectExpressionItem)selectItem).setAlias(null);
                    } else {
                        ((SelectExpressionItem)selectItem).setAlias(new Alias(string));
                    }
                }
            }
        };
        viewerColumnController.addColumn("Alias", "Select item alias", 16384, true, false, selectItem -> {
            Alias alias;
            if (selectItem instanceof SelectExpressionItem && (alias = ((SelectExpressionItem)selectItem).getAlias()) != null) {
                return alias.getName();
            }
            return null;
        }, (EditingSupport)textEditingSupport);
    }

    @Override
    protected DBIcon getDefaultIcon() {
        return DBIcon.TREE_COLUMN;
    }

    @Override
    protected void fillPanelContributions(IContributionManager iContributionManager) {
        super.fillPanelContributions(iContributionManager);
        iContributionManager.add((IAction)new Action("Add Column/Expression", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_ADD)){

            public void run() {
                PlainSelect plainSelect = VQBPanelQuerySelectItems.this.getPlainSelect();
                if (plainSelect != null) {
                    ArrayList<SelectExpressionItem> arrayList = plainSelect.getSelectItems();
                    if (arrayList == null) {
                        arrayList = new ArrayList<SelectExpressionItem>();
                        plainSelect.setSelectItems(arrayList);
                    }
                    SelectItem selectItem = (SelectItem)VQBPanelQuerySelectItems.this.getSelectedElement();
                    SelectExpressionItem selectExpressionItem = new SelectExpressionItem((Expression)new LongValue(1L));
                    if (selectItem != null) {
                        arrayList.add(arrayList.indexOf(selectItem) + 1, selectExpressionItem);
                    } else {
                        arrayList.add(selectExpressionItem);
                    }
                    VQBPanelQuerySelectItems.this.addNewElement(selectExpressionItem, 1);
                }
            }
        });
        iContributionManager.add((IAction)new VQBPanelQueryElements.DeleteActionAbstract(this){

            protected List<SelectItem> getElementsContainer() {
                PlainSelect plainSelect = VQBPanelQuerySelectItems.this.getPlainSelect();
                return plainSelect != null ? plainSelect.getSelectItems() : null;
            }
        });
        iContributionManager.add((IContributionItem)new Separator());
        iContributionManager.add((IAction)new Action("Move Up", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ARROW_UP)){

            public void run() {
                VQBPanelQuerySelectItems.this.moveElementTo(-1);
            }

            public boolean isEnabled() {
                PlainSelect plainSelect = VQBPanelQuerySelectItems.this.getPlainSelect();
                SelectItem selectItem = (SelectItem)VQBPanelQuerySelectItems.this.getSelectedElement();
                return plainSelect != null && plainSelect.getSelectItems() != null && selectItem != null && plainSelect.getSelectItems().indexOf(selectItem) > 0;
            }
        });
        iContributionManager.add((IAction)new Action("Move Down", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ARROW_DOWN)){

            public void run() {
                VQBPanelQuerySelectItems.this.moveElementTo(1);
            }

            public boolean isEnabled() {
                PlainSelect plainSelect = VQBPanelQuerySelectItems.this.getPlainSelect();
                SelectItem selectItem = (SelectItem)VQBPanelQuerySelectItems.this.getSelectedElement();
                return plainSelect != null && plainSelect.getSelectItems() != null && selectItem != null && plainSelect.getSelectItems().indexOf(selectItem) < plainSelect.getSelectItems().size() - 1;
            }
        });
    }

    protected void moveElementTo(int n) {
        PlainSelect plainSelect;
        List list;
        SelectItem selectItem = (SelectItem)this.getSelectedElement();
        if (selectItem != null && (list = (plainSelect = this.getPlainSelect()).getSelectItems()) != null) {
            int n2 = list.indexOf(selectItem);
            if (list.remove(selectItem)) {
                list.add(n2 + n, selectItem);
                this.presentation.getQueryPanel().refreshActions();
                this.refreshDiagramAndStatement();
            }
        }
    }

    @Override
    protected boolean supportsElementsMove() {
        return true;
    }

    @Override
    protected void moveElementTo(SelectItem selectItem, SelectItem selectItem2) {
        List list = this.getPlainSelect().getSelectItems();
        if (list != null) {
            list.indexOf(selectItem);
            int n = list.indexOf(selectItem2);
            if (list.remove(selectItem)) {
                list.add(n, selectItem);
                this.presentation.getQueryPanel().refreshActions();
                this.refreshDiagramAndStatement();
            }
        }
    }
}

