/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor.panel;

import com.dbeaver.ee.vqb.VQBUtils;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryElements;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryExpression;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;

class VQBPanelQueryOrderBy
extends VQBPanelQueryExpression<OrderByElement> {
    public static final String DIRECTION_ASCENDING = "Ascending";
    public static final String DIRECTION_DESCENDING = "Descending";

    protected VQBPanelQueryOrderBy(VQBEditorPresentation vQBEditorPresentation) {
        super(vQBEditorPresentation);
    }

    @Override
    protected void fillColumns(ViewerColumnController<Object, OrderByElement> viewerColumnController) {
        viewerColumnController.addColumn("#", "Element position", 16384, true, true, orderByElement -> {
            PlainSelect plainSelect = this.getPlainSelect();
            if (plainSelect != null) {
                return String.valueOf(plainSelect.getOrderByElements().indexOf(orderByElement) + 1);
            }
            return null;
        }, null);
        VQBPanelQueryElements.ExpressionEditingSupport<OrderByElement> expressionEditingSupport = new VQBPanelQueryElements.ExpressionEditingSupport<OrderByElement>((VQBPanelQueryElements)this){

            @Override
            protected CellEditor getCellEditor(Object object) {
                CustomComboBoxCellEditor customComboBoxCellEditor = new CustomComboBoxCellEditor((ColumnViewer)VQBPanelQueryOrderBy.this.elementViewer, (Composite)VQBPanelQueryOrderBy.this.elementViewer.getTree(), new String[0], 4);
                List<String> list = VQBUtils.getAttributeNames(VQBPanelQueryOrderBy.this.presentation.getVQBEditor().getDiagram(), false);
                customComboBoxCellEditor.setItems(list.toArray(new String[list.size()]));
                UIUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)VQBPanelQueryOrderBy.this.presentation.getSQLEditor().getSite(), (Control)customComboBoxCellEditor.getControl());
                return customComboBoxCellEditor;
            }

            @Override
            protected String convertExpressionToString(OrderByElement orderByElement) {
                return orderByElement.getExpression().toString();
            }

            @Override
            protected boolean updateElementExpression(OrderByElement orderByElement, OrderByElement orderByElement2, Expression expression) {
                orderByElement2.setExpression(expression);
                return true;
            }
        };
        viewerColumnController.addColumn("Column or Expression", "Expression", 16384, true, true, orderByElement -> orderByElement.getExpression().toString(), (EditingSupport)expressionEditingSupport);
        EditingSupport editingSupport = new EditingSupport((ColumnViewer)this.elementViewer){

            protected CellEditor getCellEditor(Object object) {
                CustomComboBoxCellEditor customComboBoxCellEditor = new CustomComboBoxCellEditor((ColumnViewer)VQBPanelQueryOrderBy.this.elementViewer, (Composite)VQBPanelQueryOrderBy.this.elementViewer.getTree(), new String[0], 12);
                customComboBoxCellEditor.setItems(new String[]{VQBPanelQueryOrderBy.DIRECTION_ASCENDING, VQBPanelQueryOrderBy.DIRECTION_DESCENDING});
                return customComboBoxCellEditor;
            }

            protected boolean canEdit(Object object) {
                return true;
            }

            protected Object getValue(Object object) {
                return ((OrderByElement)object).isAsc() ? VQBPanelQueryOrderBy.DIRECTION_ASCENDING : VQBPanelQueryOrderBy.DIRECTION_DESCENDING;
            }

            protected void setValue(Object object, Object object2) {
                ((OrderByElement)object).setAsc(VQBPanelQueryOrderBy.DIRECTION_ASCENDING.equals(object2));
                VQBPanelQueryOrderBy.this.refreshDiagramAndStatement();
            }
        };
        viewerColumnController.addColumn("Order", "Order", 16384, true, false, orderByElement -> orderByElement.isAsc() ? DIRECTION_ASCENDING : DIRECTION_DESCENDING, editingSupport);
    }

    @Override
    protected List<OrderByElement> extractRootItems(PlainSelect plainSelect) {
        return plainSelect.getOrderByElements();
    }

    @Override
    protected Expression getExpression(OrderByElement orderByElement) {
        return orderByElement.getExpression();
    }

    @Override
    protected DBIcon getDefaultIcon() {
        return UIIcon.SORT;
    }

    @Override
    protected void fillPanelContributions(IContributionManager iContributionManager) {
        super.fillPanelContributions(iContributionManager);
        iContributionManager.add((IAction)new Action("Add Column/Expression", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ROW_ADD)){

            public void run() {
                PlainSelect plainSelect = VQBPanelQueryOrderBy.this.getPlainSelect();
                if (plainSelect != null) {
                    ArrayList<OrderByElement> arrayList = plainSelect.getOrderByElements();
                    if (arrayList == null) {
                        arrayList = new ArrayList<OrderByElement>();
                        plainSelect.setOrderByElements(arrayList);
                    }
                    OrderByElement orderByElement = (OrderByElement)VQBPanelQueryOrderBy.this.getSelectedElement();
                    OrderByElement orderByElement2 = new OrderByElement();
                    orderByElement2.setExpression((Expression)new LongValue(1L));
                    if (orderByElement != null) {
                        arrayList.add(arrayList.indexOf(orderByElement) + 1, orderByElement2);
                    } else {
                        arrayList.add(orderByElement2);
                    }
                    VQBPanelQueryOrderBy.this.addNewElement(orderByElement2, 1);
                }
            }
        });
        iContributionManager.add((IAction)new VQBPanelQueryElements.DeleteActionAbstract(this){

            protected List<OrderByElement> getElementsContainer() {
                PlainSelect plainSelect = VQBPanelQueryOrderBy.this.getPlainSelect();
                return plainSelect != null ? plainSelect.getOrderByElements() : null;
            }
        });
        iContributionManager.add((IContributionItem)new Separator());
        iContributionManager.add((IAction)new Action("Move Up", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ARROW_UP)){

            public void run() {
                VQBPanelQueryOrderBy.this.moveElementTo(-1);
            }

            public boolean isEnabled() {
                PlainSelect plainSelect = VQBPanelQueryOrderBy.this.getPlainSelect();
                OrderByElement orderByElement = (OrderByElement)VQBPanelQueryOrderBy.this.getSelectedElement();
                return plainSelect != null && plainSelect.getOrderByElements() != null && orderByElement != null && plainSelect.getOrderByElements().indexOf(orderByElement) > 0;
            }
        });
        iContributionManager.add((IAction)new Action("Move Down", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ARROW_DOWN)){

            public void run() {
                VQBPanelQueryOrderBy.this.moveElementTo(1);
            }

            public boolean isEnabled() {
                PlainSelect plainSelect = VQBPanelQueryOrderBy.this.getPlainSelect();
                OrderByElement orderByElement = (OrderByElement)VQBPanelQueryOrderBy.this.getSelectedElement();
                return plainSelect != null && plainSelect.getOrderByElements() != null && orderByElement != null && plainSelect.getOrderByElements().indexOf(orderByElement) < plainSelect.getSelectItems().size() - 1;
            }
        });
    }

    private void moveElementTo(int n) {
        List list;
        PlainSelect plainSelect;
        OrderByElement orderByElement = (OrderByElement)this.getSelectedElement();
        if (orderByElement != null && (plainSelect = this.getPlainSelect()) != null && (list = plainSelect.getOrderByElements()) != null) {
            int n2 = list.indexOf(orderByElement);
            if (list.remove(orderByElement)) {
                list.add(n2 + n, orderByElement);
                this.presentation.getQueryPanel().refreshActions();
                this.refreshDiagramAndStatement();
            }
        }
    }

    @Override
    protected boolean supportsElementsMove() {
        return true;
    }

    @Override
    protected void moveElementTo(OrderByElement orderByElement, OrderByElement orderByElement2) {
        List list = this.getPlainSelect().getOrderByElements();
        if (list != null) {
            list.indexOf(orderByElement);
            int n = list.indexOf(orderByElement2);
            if (list.remove(orderByElement)) {
                list.add(n, orderByElement);
                this.presentation.getQueryPanel().refreshActions();
                this.refreshDiagramAndStatement();
            }
        }
    }
}

