/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor.panel;

import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelProperties;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryElements;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryJoins;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryOrderBy;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQuerySelectItems;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryWhere;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolder;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderComposite;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderInfo;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentation;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentationPanel;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class VQBEditorQueryPanel
implements SQLEditorPresentationPanel {
    private static final Log log = Log.getLog(VQBEditorQueryPanel.class);
    public static final String FOLDER_ID_PROPERTIES = "properties";
    public static final String FOLDER_ID_SELECT = "select";
    public static final String FOLDER_ID_WHERE = "where";
    public static final String FOLDER_ID_JOINS = "joins";
    public static final String FOLDER_ID_ORDER_BY = "orderBy";
    public static final String FOLDER_ID_OTHER = "other";
    public static final String PANEL_ID = "vqb_settings";
    private VQBEditorPresentation vqbPresentation;
    private CustomSashForm panelDivider;
    private SQLEditorBase previewEditor;
    private ToolBarManager panelsToolbar;
    private TabbedFolderComposite folderList;

    public static IDialogSettings getPanelSettings() {
        return UIUtils.getDialogSettings((String)"DBeaver.VQBEditorQueryPanel");
    }

    public Control createPanel(Composite composite, SQLEditor sQLEditor, SQLEditorPresentation sQLEditorPresentation) {
        this.vqbPresentation = (VQBEditorPresentation)sQLEditorPresentation;
        this.panelDivider = UIUtils.createPartDivider((IWorkbenchPart)this.vqbPresentation.getSQLEditor(), (Composite)composite, (int)256);
        Composite composite2 = UIUtils.createPlaceholder((Composite)this.panelDivider, (int)2);
        this.folderList = new TabbedFolderComposite(composite2, 16388);
        TabbedFolderInfo[] tabbedFolderInfoArray = new TabbedFolderInfo[]{new TabbedFolderInfo(FOLDER_ID_SELECT, "Columns", (DBPImage)UIIcon.CONFIGURATION, "SELECT items/columns", false, (ITabbedFolder)new VQBPanelQuerySelectItems(this.vqbPresentation)), new TabbedFolderInfo(FOLDER_ID_WHERE, "Conditions", (DBPImage)UIIcon.CONFIGURATION, "WHERE conditions", false, (ITabbedFolder)new VQBPanelQueryWhere(this.vqbPresentation)), new TabbedFolderInfo(FOLDER_ID_JOINS, "Joins", (DBPImage)UIIcon.CONFIGURATION, "Tables participating in query", false, (ITabbedFolder)new VQBPanelQueryJoins(this.vqbPresentation)), new TabbedFolderInfo(FOLDER_ID_ORDER_BY, "Sorting", (DBPImage)UIIcon.CONFIGURATION, "ORDER BY conditions", false, (ITabbedFolder)new VQBPanelQueryOrderBy(this.vqbPresentation)), new TabbedFolderInfo(FOLDER_ID_OTHER, "Miscellaneous", (DBPImage)UIIcon.CONFIGURATION, "Miscellaneous query settings (offset, limit, etc))", false, (ITabbedFolder)new VQBPanelProperties())};
        this.folderList.setFolders(PANEL_ID, tabbedFolderInfoArray);
        this.folderList.setLayoutData((Object)new GridData(1808));
        this.panelsToolbar = new ToolBarManager(512);
        ToolBar toolBar = this.panelsToolbar.createControl(composite2);
        GridData gridData = new GridData(1040);
        gridData.horizontalIndent = 3;
        gridData.verticalIndent = 3;
        toolBar.setLayoutData((Object)gridData);
        this.folderList.addFolderListener(string -> {
            this.panelsToolbar.removeAll();
            ITabbedFolder iTabbedFolder = this.folderList.getActiveFolder();
            if (iTabbedFolder instanceof VQBPanelQueryElements) {
                ((VQBPanelQueryElements)iTabbedFolder).fillPanelContributions((IContributionManager)this.panelsToolbar);
            }
            this.panelsToolbar.update(true);
        });
        if (this.folderList.getActiveFolder() == null) {
            this.folderList.switchFolder(FOLDER_ID_SELECT);
        }
        this.createPreviewPanel(this.panelDivider);
        if (VQBEditorQueryPanel.getPanelSettings().getBoolean("previewHidden")) {
            this.panelDivider.setMaximizedControl(this.panelDivider.getChildren()[0]);
        }
        return this.panelDivider;
    }

    private void createPreviewPanel(CustomSashForm customSashForm) {
        this.previewEditor = new SQLEditorBase(){

            public DBCExecutionContext getExecutionContext() {
                return VQBEditorQueryPanel.this.vqbPresentation.getSQLEditor().getExecutionContext();
            }
        };
        IEditorInput iEditorInput = this.createQueryInput();
        try {
            this.previewEditor.init((IEditorSite)new SubEditorSite((IWorkbenchPartSite)this.vqbPresentation.getSQLEditor().getEditorSite()), iEditorInput);
            this.previewEditor.createPartControl((Composite)customSashForm);
            this.previewEditor.reloadSyntaxRules();
        }
        catch (PartInitException partInitException) {
            DBUserInterface.getInstance().showError("Create error", "Can't create SQL preview editor", (Throwable)partInitException);
        }
    }

    private IEditorInput createQueryInput() {
        return new StringEditorInput("SQL Preview", (CharSequence)this.vqbPresentation.getVQBEditor().getQueryInfo().getQuery().getText(), true, GeneralUtils.getDefaultFileEncoding());
    }

    public void activatePanel() {
    }

    public void deactivatePanel() {
    }

    public void refreshActions() {
        UIUtils.updateContributionItems((IContributionManager)this.panelsToolbar);
    }

    public void refreshFromStatement(boolean bl) {
        this.vqbPresentation.getVQBEditor().getQueryInfo().refreshStatement(true);
        if (bl) {
            TabbedFolderInfo[] tabbedFolderInfoArray = this.folderList.getFolders();
            int n = tabbedFolderInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                TabbedFolderInfo tabbedFolderInfo = tabbedFolderInfoArray[n2];
                if (tabbedFolderInfo.getContents() instanceof VQBPanelQueryElements) {
                    ((VQBPanelQueryElements)tabbedFolderInfo.getContents()).refreshFromStatement();
                }
                ++n2;
            }
        }
        this.previewEditor.setInput(this.createQueryInput());
        this.previewEditor.reloadSyntaxRules();
    }

    public void updateActions() {
        UIUtils.updateContributionItems((IContributionManager)this.panelsToolbar);
    }

    public boolean isPreviewVisible() {
        return this.panelDivider.getMaximizedControl() == null;
    }

    public void togglePreview() {
        if (this.panelDivider.getMaximizedControl() == null) {
            this.panelDivider.setMaximizedControl((Control)this.folderList.getParent());
        } else {
            this.panelDivider.setMaximizedControl(null);
        }
        VQBEditorQueryPanel.getPanelSettings().put("previewHidden", this.panelDivider.getMaximizedControl() != null);
    }

    public void editElement(String string, Object object) {
        ITabbedFolder iTabbedFolder;
        if (!this.vqbPresentation.getSQLEditor().showPresentationPanel((SQLEditorPresentationPanel)this)) {
            return;
        }
        if (this.folderList.switchFolder(string) && (iTabbedFolder = this.folderList.getActiveFolder()) instanceof VQBPanelQueryElements) {
            ((VQBPanelQueryElements)iTabbedFolder).editElement(object);
        }
    }
}

