/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor;

import com.dbeaver.ee.vqb.ui.builder.VQBQueryInfo;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPart;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBEditorQueryPanel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISaveablePart;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListener;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListenerDefault;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentation;

public class VQBEditorPresentation
implements SQLEditorPresentation,
ISaveablePart {
    private static final Log log = Log.getLog(VQBEditorPresentation.class);
    private SQLEditor sqlEditor;
    private VQBEditorPart vqbEditor;
    private SQLListener sqlListener;

    public SQLEditor getSQLEditor() {
        return this.sqlEditor;
    }

    public VQBEditorPart getVQBEditor() {
        return this.vqbEditor;
    }

    public void createPresentation(Composite composite, SQLEditor sQLEditor) {
        this.sqlEditor = sQLEditor;
        this.sqlListener = new SQLListener();
        this.sqlEditor.addListener((SQLEditorListener)this.sqlListener);
        this.vqbEditor = new VQBEditorPart(this);
        try {
            this.vqbEditor.init(sQLEditor.getEditorSite(), sQLEditor.getEditorInput());
            this.vqbEditor.createPartControl(composite);
            this.parseActiveQuery();
        }
        catch (Exception exception) {
            log.error((Object)"Error creating ERD panel", (Throwable)exception);
        }
    }

    public void dispose() {
        this.vqbEditor.dispose();
        this.sqlEditor.removeListener((SQLEditorListener)this.sqlListener);
    }

    public void parseActiveQuery() {
        SQLScriptElement sQLScriptElement = this.sqlEditor.extractActiveQuery();
        if (sQLScriptElement == null) {
            ITextSelection iTextSelection = (ITextSelection)this.sqlEditor.getSelectionProvider().getSelection();
            SQLQuery sQLQuery = new SQLQuery(this.sqlEditor.getDataSource(), "");
            sQLQuery.setOffset(iTextSelection.getOffset());
            sQLQuery.setLength(iTextSelection.getLength());
            this.vqbEditor.loadQuery(sQLQuery);
        } else if (sQLScriptElement instanceof SQLQuery) {
            this.vqbEditor.loadQuery((SQLQuery)sQLScriptElement);
        }
        this.refreshStatement();
    }

    @Nullable
    public VQBEditorQueryPanel getQueryPanel() {
        VQBEditorQueryPanel vQBEditorQueryPanel = (VQBEditorQueryPanel)this.sqlEditor.getExtraPresentationPanel(VQBEditorQueryPanel.class);
        if (vQBEditorQueryPanel == null) {
            vQBEditorQueryPanel = (VQBEditorQueryPanel)this.sqlEditor.showPresentationPanel("vqb_settings");
        }
        return vQBEditorQueryPanel;
    }

    void refreshStatement() {
        VQBEditorQueryPanel vQBEditorQueryPanel = this.getQueryPanel();
        if (vQBEditorQueryPanel != null) {
            vQBEditorQueryPanel.refreshFromStatement(true);
        }
        this.sqlEditor.updateDirtyFlag();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        if (EditorUtils.isInAutoSaveJob()) {
            return;
        }
        if (!this.updateQueryInEditor()) {
            iProgressMonitor.setCanceled(true);
        }
    }

    private boolean updateQueryInEditor() {
        if (!this.vqbEditor.isDirty()) {
            return true;
        }
        VQBQueryInfo vQBQueryInfo = this.vqbEditor.getQueryInfo();
        SQLQuery sQLQuery = vQBQueryInfo.getQuery();
        try {
            String string = String.valueOf(sQLQuery.getText()) + "\n";
            this.sqlEditor.getDocument().replace(sQLQuery.getOffset(), sQLQuery.getLength(), string);
            sQLQuery.setLength(string.length());
            this.sqlEditor.getSelectionProvider().setSelection((ISelection)new TextSelection(sQLQuery.getOffset(), 0));
            this.vqbEditor.resetDirtyFlag();
            return true;
        }
        catch (BadLocationException badLocationException) {
            log.error((Object)"Error updating query in SQL editor", (Throwable)badLocationException);
            return false;
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.vqbEditor.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    private class SQLListener
    extends SQLEditorListenerDefault {
        private SQLListener() {
        }

        public void beforeQueryExecute(boolean bl, boolean bl2) {
            VQBEditorPresentation.this.updateQueryInEditor();
        }

        public void beforeQueryPlanExplain() {
            VQBEditorPresentation.this.updateQueryInEditor();
        }
    }
}

